/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.text;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.draw.DrawObjectElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentMetaElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMetaElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextTrackedChangesElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextExtractor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.NodeList;

public class OdfEditableTextExtractor
extends OdfTextExtractor {
    OdfDocument mDocument = null;
    OdfElement mElement = null;
    boolean mIsDocumentExtractor = false;

    private OdfEditableTextExtractor(OdfDocument doc) {
        this.mTextBuilder = new StringBuilder();
        this.mDocument = doc;
        this.mIsDocumentExtractor = true;
    }

    private OdfEditableTextExtractor(OdfElement element) {
        this.mTextBuilder = new StringBuilder();
        this.mElement = element;
        this.mIsDocumentExtractor = false;
    }

    public static OdfEditableTextExtractor newOdfEditableTextExtractor(OdfDocument doc) {
        return new OdfEditableTextExtractor(doc);
    }

    public static OdfEditableTextExtractor newOdfEditableTextExtractor(OdfElement element) {
        return new OdfEditableTextExtractor(element);
    }

    public void visit(DrawObjectElement element) {
        String embedDocPath = element.getXlinkHrefAttribute();
        OdfDocument embedDoc = ((OdfDocument)((OdfContentDom)element.getOwnerDocument()).getDocument()).loadSubDocument(embedDocPath);
        if (embedDoc != null) {
            try {
                this.mTextBuilder.append(OdfEditableTextExtractor.newOdfEditableTextExtractor(embedDoc).getText());
            }
            catch (Exception e2) {
                Logger.getLogger(OdfEditableTextExtractor.class.getName()).log(Level.SEVERE, null, e2);
            }
        }
    }

    public void visit(TextTrackedChangesElement ele) {
    }

    public void visit(TextAElement ele) {
        String link = ele.getXlinkHrefAttribute();
        this.mTextBuilder.append(link);
        this.appendElementText(ele);
    }

    public void visit(TableTableElement ele) {
        OdfTable table = OdfTable.getInstance(ele);
        List<OdfTableRow> rowlist = table.getRowList();
        for (int i = 0; i < rowlist.size(); ++i) {
            OdfTableRow row = rowlist.get(i);
            for (int j = 0; j < row.getCellCount(); ++j) {
                this.mTextBuilder.append(row.getCellByIndex(j).getDisplayText()).append('\t');
            }
            this.mTextBuilder.append('\r');
        }
    }

    public String getText() {
        if (this.mIsDocumentExtractor) {
            return this.getDocumentText();
        }
        this.visit(this.mElement);
        return this.mTextBuilder.toString();
    }

    private String getDocumentText() {
        StringBuilder builder = new StringBuilder();
        try {
            OfficeDocumentMetaElement root;
            OfficeMetaElement officemeta;
            OdfMetaDom metaDom;
            OdfEditableTextExtractor contentDomExtractor = OdfEditableTextExtractor.newOdfEditableTextExtractor(this.mDocument.getContentRoot());
            builder.append(contentDomExtractor.getText());
            OdfStylesDom styleDom = this.mDocument.getStylesDom();
            if (styleDom != null) {
                StyleMasterPageElement masterpage = null;
                NodeList list = styleDom.getElementsByTagName("style:master-page");
                if (list.getLength() > 0) {
                    masterpage = (StyleMasterPageElement)list.item(0);
                }
                if (masterpage != null) {
                    builder.append(OdfEditableTextExtractor.newOdfEditableTextExtractor(masterpage).getText());
                }
            }
            if ((metaDom = this.mDocument.getMetaDom()) != null && (officemeta = OdfElement.findFirstChildNode(OfficeMetaElement.class, root = metaDom.getRootElement())) != null) {
                builder.append(OdfEditableTextExtractor.newOdfEditableTextExtractor(officemeta).getText());
            }
            return builder.toString();
        }
        catch (Exception e2) {
            Logger.getLogger(OdfEditableTextExtractor.class.getName()).severe(e2.getMessage());
            return builder.toString();
        }
    }
}

