/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.stream.JenaIOEnvironment;
import org.apache.jena.riot.stream.LocationMapper;
import org.apache.jena.riot.stream.Locator;
import org.apache.jena.riot.stream.LocatorClassLoader;
import org.apache.jena.riot.stream.LocatorFTP;
import org.apache.jena.riot.stream.LocatorFile;
import org.apache.jena.riot.stream.LocatorHTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamManager {
    private static Logger log = LoggerFactory.getLogger(StreamManager.class);
    public static boolean logAllLookups = true;
    private List<Locator> handlers = new ArrayList<Locator>();
    private LocationMapper mapper = null;
    private static StreamManager globalStreamManager;

    public StreamManager clone() {
        return StreamManager.clone(this);
    }

    private static StreamManager clone(StreamManager other) {
        StreamManager sm = new StreamManager();
        sm.handlers.addAll(other.handlers);
        sm.mapper = other.mapper == null ? null : other.mapper.clone();
        return sm;
    }

    public static StreamManager makeDefaultStreamManager() {
        StreamManager streamManager = new StreamManager();
        streamManager.addLocator(new LocatorFile(null));
        streamManager.addLocator(new LocatorHTTP());
        streamManager.addLocator(new LocatorFTP());
        streamManager.addLocator(new LocatorClassLoader(streamManager.getClass().getClassLoader()));
        streamManager.setLocationMapper(JenaIOEnvironment.getLocationMapper());
        return streamManager;
    }

    public static StreamManager get() {
        return globalStreamManager;
    }

    public static void setGlobal(StreamManager streamManager) {
        globalStreamManager = streamManager;
    }

    public TypedInputStream open(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("open(" + filenameOrURI + ")");
        }
        String uri = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !uri.equals(filenameOrURI)) {
            log.debug("open: mapped to " + uri);
        }
        return this.openNoMapOrNull(uri);
    }

    public String mapURI(String filenameOrURI) {
        if (this.mapper == null) {
            return filenameOrURI;
        }
        String uri = this.mapper.altMapping(filenameOrURI, null);
        if (uri == null) {
            if (logAllLookups && log.isDebugEnabled()) {
                log.debug("Not mapped: " + filenameOrURI);
            }
            uri = filenameOrURI;
        } else if (log.isDebugEnabled()) {
            log.debug("Mapped: " + filenameOrURI + " => " + uri);
        }
        return uri;
    }

    public TypedInputStream openNoMap(String filenameOrURI) {
        TypedInputStream in = this.openNoMapOrNull(filenameOrURI);
        if (in == null) {
            throw new RiotNotFoundException(filenameOrURI);
        }
        return in;
    }

    public TypedInputStream openNoMapOrNull(String filenameOrURI) {
        for (Locator loc : this.handlers) {
            TypedInputStream in = loc.open(filenameOrURI);
            if (in == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Found: " + filenameOrURI + " (" + loc.getName() + ")");
            }
            return in;
        }
        return null;
    }

    public void setLocationMapper(LocationMapper _mapper) {
        this.mapper = _mapper;
    }

    public LocationMapper getLocationMapper() {
        return this.mapper;
    }

    public List<Locator> locators() {
        return Collections.unmodifiableList(this.handlers);
    }

    public void remove(Locator loc) {
        this.handlers.remove(loc);
    }

    public void clearLocators() {
        this.handlers.clear();
    }

    public void addLocator(Locator loc) {
        this.handlers.add(loc);
    }

    static {
        StreamManager.setGlobal(StreamManager.makeDefaultStreamManager());
    }
}

