/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakAfterAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBreakBeforeAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoMarginTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoTextIndentAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class ParagraphProperties {
    private static final String DEFAULT_LENGTH = "0in";
    StyleParagraphPropertiesElement mElement;

    protected ParagraphProperties() {
    }

    protected ParagraphProperties(StyleParagraphPropertiesElement properties) {
        this.mElement = properties;
    }

    public void setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType alignType) {
        if (alignType == StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT) {
            this.mElement.removeAttribute(FoTextAlignAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoTextAlignAttribute(alignType.getAlignmentString());
        }
    }

    public StyleTypeDefinitions.HorizontalAlignmentType getHorizontalAlignment() {
        String alignType = this.mElement.getFoTextAlignAttribute();
        if (alignType == null || alignType.length() == 0) {
            return StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT;
        }
        FoTextAlignAttribute.Value value = FoTextAlignAttribute.Value.enumValueOf(alignType);
        switch (value) {
            case CENTER: {
                return StyleTypeDefinitions.HorizontalAlignmentType.CENTER;
            }
            case END: {
                return StyleTypeDefinitions.HorizontalAlignmentType.RIGHT;
            }
            case JUSTIFY: {
                return StyleTypeDefinitions.HorizontalAlignmentType.JUSTIFY;
            }
            case LEFT: {
                return StyleTypeDefinitions.HorizontalAlignmentType.LEFT;
            }
            case RIGHT: {
                return StyleTypeDefinitions.HorizontalAlignmentType.RIGHT;
            }
            case START: {
                return StyleTypeDefinitions.HorizontalAlignmentType.LEFT;
            }
        }
        return null;
    }

    public void setMarginLeft(double marginLeft) {
        if (marginLeft == 0.0) {
            this.mElement.removeAttribute(FoMarginLeftAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginLeftAttribute(ParagraphProperties.getInchValue(marginLeft));
        }
    }

    public double getMarginLeft() {
        String valueString = this.mElement.getFoMarginLeftAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble(valueString, Length.Unit.MILLIMETER);
    }

    public void setMarginRight(double marginRight) {
        if (marginRight == 0.0) {
            this.mElement.removeAttribute(FoMarginRightAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginRightAttribute(ParagraphProperties.getInchValue(marginRight));
        }
    }

    public double getMarginRight() {
        String valueString = this.mElement.getFoMarginRightAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble(valueString, Length.Unit.MILLIMETER);
    }

    public void setMarginTop(double marginTop) {
        if (marginTop == 0.0) {
            this.mElement.removeAttribute(FoMarginTopAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginTopAttribute(ParagraphProperties.getInchValue(marginTop));
        }
    }

    public double getMarginTop() {
        String valueString = this.mElement.getFoMarginTopAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble(valueString, Length.Unit.MILLIMETER);
    }

    public void setMarginBottom(double marginBottom) {
        if (marginBottom == 0.0) {
            this.mElement.removeAttribute(FoMarginBottomAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoMarginBottomAttribute(ParagraphProperties.getInchValue(marginBottom));
        }
    }

    public double getMarginBottom() {
        String valueString = this.mElement.getFoMarginBottomAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble(valueString, Length.Unit.MILLIMETER);
    }

    public void setTextIndent(double textIndent) {
        if (textIndent == 0.0) {
            this.mElement.removeAttribute(FoTextIndentAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoTextIndentAttribute(ParagraphProperties.getInchValue(textIndent));
        }
    }

    public double getTextIndent() {
        String valueString = this.mElement.getFoTextIndentAttribute();
        if (valueString == null) {
            valueString = DEFAULT_LENGTH;
        }
        return Length.parseDouble(valueString, Length.Unit.MILLIMETER);
    }

    public static ParagraphProperties getOrCreateParagraphProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
        return new ParagraphProperties((StyleParagraphPropertiesElement)properties);
    }

    public static ParagraphProperties getParagraphProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
        if (properties != null) {
            return new ParagraphProperties((StyleParagraphPropertiesElement)properties);
        }
        return null;
    }

    private static String getInchValue(double value) {
        String mmValueString = value + Length.Unit.MILLIMETER.abbr();
        String inchValueString = Length.mapToUnit(mmValueString, Length.Unit.INCH);
        return inchValueString;
    }

    public void setBreak(String breakPosition, String breakAttribute) {
        if (breakPosition == null) {
            return;
        }
        if (breakAttribute == null) {
            if (breakPosition.equals("before")) {
                this.mElement.removeAttribute(FoBreakBeforeAttribute.ATTRIBUTE_NAME.getQName());
            } else if (breakPosition.equals("after")) {
                this.mElement.removeAttribute(FoBreakAfterAttribute.ATTRIBUTE_NAME.getQName());
            }
        } else if (breakPosition.equals("before")) {
            this.mElement.setFoBreakBeforeAttribute(breakAttribute);
        } else if (breakPosition.equals("after")) {
            this.mElement.setFoBreakAfterAttribute(breakAttribute);
        }
    }

    public String getBreakBefore() {
        return this.mElement.getFoBreakBeforeAttribute();
    }

    public String getBreakAfter() {
        return this.mElement.getFoBreakAfterAttribute();
    }

    public int getPageNumber() {
        return this.mElement.getStylePageNumberAttribute();
    }

    public void setPageNumber(int pageNumber) {
        if (pageNumber > 0) {
            this.mElement.setStylePageNumberAttribute(pageNumber);
        } else {
            this.mElement.removeAttribute("style:page-number");
        }
    }
}

