/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.dom.element.form.FormRadioElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButton
extends FormControl {
    RadioButton(FormRadioElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static RadioButton getInstanceOf(FormRadioElement element) {
        RadioButton radio = new RadioButton(element);
        try {
            radio.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e2) {
            Logger.getLogger(RadioButton.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this radio button.");
        }
        return radio;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormRadioElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public String getId() {
        return ((FormRadioElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public void setId(String id) {
        ((FormRadioElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormRadioElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    public void setLabel(String label) {
        ((FormRadioElement)this.mElement).setFormLabelAttribute(label);
    }

    public String getLabel() {
        return ((FormRadioElement)this.mElement).getFormLabelAttribute();
    }

    @Override
    public String getName() {
        return ((FormRadioElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormRadioElement)this.mElement).setFormNameAttribute(name);
    }

    public String getValue() {
        return ((FormRadioElement)this.mElement).getFormValueAttribute();
    }

    public void setValue(String value) {
        ((FormRadioElement)this.mElement).setFormValueAttribute(value);
    }

    public void setDefaultSelected(boolean isSelected) {
        ((FormRadioElement)this.mElement).setFormSelectedAttribute(isSelected);
    }

    public boolean getDefaultSelected() {
        return ((FormRadioElement)this.mElement).getFormSelectedAttribute();
    }

    public void setCurrentSelected(boolean isSelected) {
        ((FormRadioElement)this.mElement).setFormCurrentSelectedAttribute(isSelected);
    }

    public boolean getCurrentSelected() {
        return ((FormRadioElement)this.mElement).getFormCurrentSelectedAttribute();
    }

    public static Iterator<FormControl> getSimpleIterator(Form container2) {
        return new SimpleRadioButtonIterator(container2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleRadioButtonIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private RadioButton nextElement = null;
        private RadioButton tempElement = null;

        private SimpleRadioButtonIterator(Form container2) {
            this.containerElement = container2.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public RadioButton next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private RadioButton findNext(RadioButton thisRadioButton) {
            FormRadioElement nextRadioButton = null;
            nextRadioButton = thisRadioButton == null ? OdfElement.findFirstChildNode(FormRadioElement.class, this.containerElement) : OdfElement.findNextChildNode(FormRadioElement.class, thisRadioButton.getOdfElement());
            if (nextRadioButton != null) {
                return RadioButton.getInstanceOf(nextRadioButton);
            }
            return null;
        }
    }
}

