/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class Point3D
implements OdfDataType {
    private String mPoint3D;
    private static final Pattern point3DPattern = Pattern.compile("^\\([ ]*-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)((cm)|(mm)|(in)|(pt)|(pc))([ ]+-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)((cm)|(mm)|(in)|(pt)|(pc))){2}[ ]*\\)$");

    public Point3D(String point3D) throws IllegalArgumentException {
        if (!Point3D.isValid(point3D)) {
            throw new IllegalArgumentException("parameter is invalid for datatype Point3D");
        }
        this.mPoint3D = point3D;
    }

    public String toString() {
        return this.mPoint3D;
    }

    public static Point3D valueOf(String stringValue) throws IllegalArgumentException {
        return new Point3D(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && point3DPattern.matcher(stringValue).matches();
    }
}

