/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.IRunBody;
import org.apache.poi.xwpf.usermodel.IRunElement;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFSDTContent;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;

public class XWPFSDT
implements IBodyElement,
IRunBody,
ISDTContents,
IRunElement {
    private final String title;
    private final String tag;
    private final XWPFSDTContent content;
    private final IBody part;

    public XWPFSDT(CTSdtRun sdtRun, IBody part) {
        this.part = part;
        this.content = new XWPFSDTContent(sdtRun.getSdtContent(), part, (IRunBody)this);
        CTSdtPr pr = sdtRun.getSdtPr();
        List<CTString> aliases = pr.getAliasList();
        this.title = aliases != null && aliases.size() > 0 ? aliases.get(0).getVal() : "";
        CTString[] array = pr.getTagArray();
        this.tag = array != null && array.length > 0 ? array[0].getVal() : "";
    }

    public XWPFSDT(CTSdtBlock block, IBody part) {
        this.part = part;
        this.content = new XWPFSDTContent(block.getSdtContent(), part, (IRunBody)this);
        CTSdtPr pr = block.getSdtPr();
        List<CTString> aliases = pr.getAliasList();
        this.title = aliases != null && aliases.size() > 0 ? aliases.get(0).getVal() : "";
        CTString[] array = pr.getTagArray();
        this.tag = array != null && array.length > 0 ? array[0].getVal() : "";
    }

    public String getTitle() {
        return this.title;
    }

    public String getTag() {
        return this.tag;
    }

    public XWPFSDTContent getContent() {
        return this.content;
    }

    public IBody getBody() {
        return null;
    }

    public POIXMLDocumentPart getPart() {
        return this.part.getPart();
    }

    public BodyType getPartType() {
        return BodyType.CONTENTCONTROL;
    }

    public BodyElementType getElementType() {
        return BodyElementType.CONTENTCONTROL;
    }

    public XWPFDocument getDocument() {
        return this.part.getXWPFDocument();
    }
}

