/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class WriterStream {
    private WriterStream() {
    }

    protected static void finish(StreamRDF dest) {
        dest.finish();
    }

    protected static void start(StreamRDF dest) {
        dest.start();
    }

    protected static void writePrefixes(StreamRDF dest, PrefixMap prefixMap) {
        if (prefixMap != null) {
            for (Map.Entry<String, String> e2 : prefixMap.getMappingCopyStr().entrySet()) {
                dest.prefix(e2.getKey(), e2.getValue());
            }
        }
    }

    protected static void write(StreamRDF dest, DatasetGraph datasetGraph, PrefixMap prefixes, String baseURI) {
        WriterStream.start(dest);
        dest.base(baseURI);
        WriterStream.writePrefixes(dest, prefixes);
        Iterator<Quad> iter = datasetGraph.find(null, null, null, null);
        StreamRDFLib.quadsToStream(dest, iter);
        WriterStream.finish(dest);
    }

    protected static void write(StreamRDF dest, Graph graph, PrefixMap prefixes, String baseURI) {
        WriterStream.start(dest);
        dest.base(baseURI);
        WriterStream.writePrefixes(dest, prefixes);
        ExtendedIterator<Triple> iter = graph.find(null, null, null);
        StreamRDFLib.triplesToStream(dest, iter);
        WriterStream.finish(dest);
    }
}

