/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.apache.jena.riot.adapters.JenaReadersWriters;
import org.apache.jena.riot.adapters.RDFReaderRIOT_Web;

public class IO_JenaReaders {
    private static String riotBase = "http://jena.apache.org/riot/";
    private static String streamManagerSymbolStr = riotBase + "streammanager";
    public static Symbol streamManagerSymbol = Symbol.create(streamManagerSymbolStr);
    static String jenaNTriplesReader = "com.hp.hpl.jena.rdf.model.impl.NTripleReader";
    static String jenaTurtleReader;
    static String jenaN3Reader;
    static String jenaRDFReader;

    public static void wireIntoJena() {
        IO_JenaReaders.registerForModelRead("RDF", RDFReaderRIOT_Web.class);
        IO_JenaReaders.registerForModelRead("RDF/XML", JenaReadersWriters.RDFReaderRIOT_RDFXML.class);
        IO_JenaReaders.registerForModelRead("RDF/XML-ABBREV", JenaReadersWriters.RDFReaderRIOT_RDFXML.class);
        IO_JenaReaders.registerForModelRead("N-TRIPLES", JenaReadersWriters.RDFReaderRIOT_NT.class);
        IO_JenaReaders.registerForModelRead("N-Triples", JenaReadersWriters.RDFReaderRIOT_NT.class);
        IO_JenaReaders.registerForModelRead("N-TRIPLE", JenaReadersWriters.RDFReaderRIOT_NT.class);
        IO_JenaReaders.registerForModelRead("N3", JenaReadersWriters.RDFReaderRIOT_TTL.class);
        IO_JenaReaders.registerForModelRead("TURTLE", JenaReadersWriters.RDFReaderRIOT_TTL.class);
        IO_JenaReaders.registerForModelRead("Turtle", JenaReadersWriters.RDFReaderRIOT_TTL.class);
        IO_JenaReaders.registerForModelRead("TTL", JenaReadersWriters.RDFReaderRIOT_TTL.class);
        IO_JenaReaders.registerForModelRead("RDF/JSON", JenaReadersWriters.RDFReaderRIOT_RDFJSON.class);
    }

    public static void resetJena() {
        RDFReaderFImpl.setBaseReaderClassName("RDF", jenaRDFReader);
        RDFReaderFImpl.setBaseReaderClassName("RDF/XML", jenaRDFReader);
        RDFReaderFImpl.setBaseReaderClassName("RDF/XML-ABBREV", jenaRDFReader);
        RDFReaderFImpl.setBaseReaderClassName("N-TRIPLES", jenaNTriplesReader);
        RDFReaderFImpl.setBaseReaderClassName("N-Triples", jenaNTriplesReader);
        RDFReaderFImpl.setBaseReaderClassName("N-TRIPLE", jenaNTriplesReader);
        RDFReaderFImpl.setBaseReaderClassName("N3", jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName("TURTLE", jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName("Turtle", jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName("TTL", jenaTurtleReader);
        RDFReaderFImpl.setBaseReaderClassName("RDF/JSON", "");
        RDFReaderFImpl.setBaseReaderClassName("RDFJSON", "");
    }

    public static void registerForModelRead(String name, Class<?> cls) {
        RDFReaderFImpl.setBaseReaderClassName(name, cls.getName());
    }

    static {
        jenaN3Reader = jenaTurtleReader = "com.hp.hpl.jena.n3.turtle.TurtleReader";
        jenaRDFReader = "com.hp.hpl.jena.rdf.arp.JenaReader";
    }
}

