/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.IRILib;

public class RDFReaderRIOT_ARP
implements RDFReader {
    static FileManager fileMgr = new FileManager();
    JenaReader reader = new JenaReader();

    @Override
    public void read(Model model, Reader r, String base) {
        this.reader.read(model, r, base);
    }

    @Override
    public void read(Model model, InputStream r, String base) {
        this.reader.read(model, r, base);
    }

    @Override
    public void read(Model model, String url) {
        url = RDFReaderRIOT_ARP.fixupURL(url);
        this.reader.read(model, url);
    }

    private static String fixupURL(String url) {
        String scheme = FileUtils.getScheme(url);
        if (scheme != null && !scheme.equals("file") && !RDFReaderRIOT_ARP.isWindowsDrive(scheme)) {
            return url;
        }
        return IRILib.filenameToIRI(url);
    }

    private static boolean isWindowsDrive(String scheme) {
        return SysRIOT.isWindows && scheme.length() == 1;
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        return this.reader.setProperty(propName, propValue);
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        return this.reader.setErrorHandler(errHandler);
    }

    static {
        fileMgr.addLocatorFile();
        fileMgr.addLocatorURL();
    }
}

