/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.gui;

import com.janus.qrinvoice.gui.QRInvoiceParser;
import com.janus.qrinvoice.parser.csv.CSVQRInvoiceParser;
import com.janus.qrinvoice.parser.excel.ExcelParser;
import com.janus.qrinvoice.parser.odf.ODFParser;
import java.nio.file.Path;

public class QRInvoiceParserFactory {
    public static final String XLS = "XLS";
    public static final String CSV = "CSV";
    public static final String XLSX = "XLSX";
    public static final String ODS = "ODS";

    public static QRInvoiceParser create(Path path) {
        String string = path.toAbsolutePath().toString().toUpperCase();
        if (string.endsWith(CSV)) {
            return new CSVQRInvoiceParser();
        }
        if (string.endsWith(XLS) || string.endsWith(XLSX)) {
            return new ExcelParser();
        }
        if (string.endsWith(ODS)) {
            return new ODFParser();
        }
        throw new NullPointerException("File type not supported. " + string);
    }
}

