/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.FatalParsingErrorException;
import com.hp.hpl.jena.rdf.arp.SAX2Model;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.JenaException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class DOM2Model
extends SAX2Model {
    static Logger logger = LoggerFactory.getLogger(DOM2Model.class);

    public static DOM2Model createD2M(String base, Model m) throws SAXParseException {
        return new DOM2Model(base, m, "", true);
    }

    public static DOM2Model createD2M(String base, Model m, String lang) throws SAXParseException {
        return new DOM2Model(base, m, lang, true);
    }

    DOM2Model(String base, Model m, String lang, boolean dummy) throws SAXParseException {
        super(base, m, lang);
    }

    public void load(Node document) {
        DOMSource input = new DOMSource(document);
        SAXResult output = new SAXResult(this);
        output.setLexicalHandler(this);
        TransformerFactory xformFactory = TransformerFactory.newInstance();
        try {
            Transformer idTransform = xformFactory.newTransformer();
            idTransform.transform(input, output);
        }
        catch (FatalParsingErrorException e2) {
            logger.error("Unexpected exception in DOM2Model", (Throwable)e2);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception nrte) {
            throw new JenaException(nrte);
        }
        finally {
            this.close();
        }
    }
}

