/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.chart;

import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartClassAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartDimensionAttribute;
import org.odftoolkit.odfdom.dom.attribute.chart.ChartLegendPositionAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dProjectionAttribute;
import org.odftoolkit.odfdom.dom.attribute.dr3d.Dr3dShadeModeAttribute;
import org.odftoolkit.odfdom.dom.attribute.office.OfficeValueTypeAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleLegendExpansionAttribute;
import org.odftoolkit.odfdom.dom.element.chart.ChartAxisElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartCategoriesElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartChartElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartDataPointElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartFloorElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartGridElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartLegendElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartPlotAreaElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartSeriesElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartTitleElement;
import org.odftoolkit.odfdom.dom.element.chart.ChartWallElement;
import org.odftoolkit.odfdom.dom.element.dr3d.Dr3dLightElement;
import org.odftoolkit.odfdom.dom.element.style.StyleChartPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.odftoolkit.simple.chart.ChartType;
import org.odftoolkit.simple.chart.DataSet;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chart {
    private static final String AXIS_SVG_X = "3.104cm";
    private static final String AXIS_SVG_Y = "6.359cm";
    private static final String AXIS_FONTSIZE = "10pt";
    private static final String AXIS_FONTSIZEASIAN = "10pt";
    private static final String AXIS_FONTSIZECOMPLEX = "10pt";
    private static final String CHART_SVG_WIDTH = "7cm";
    private static final String CHART_SVG_HEIGH = "8cm";
    private static final String CHART_CLASS_TYPE = "chart:bar";
    private static final String CHART_PROPERTIES_STROKE = "none";
    private static final String PLOTAREA_SVG_HEIGHT = "7.52cm";
    private static final String PLOTAREA_SVG_WIDTH = "4.73cm";
    private static final String PLOTAREA_SVG_X = "0.16cm";
    private static final String PLOTAREA_SVG_Y = "1.375cm";
    private ChartChartElement chartElement;
    private DataSet dataSet;
    private ChartTitleElement chartTitle;
    private ChartLegendElement legend;
    private ChartPlotAreaElement plotArea;
    private TableTableElement table;
    private TableTableHeaderColumnsElement headerColumns;
    private TableTableColumnsElement columns;
    private TableTableColumnElement column;
    private TableTableHeaderRowsElement headerRows;
    private TableTableRowElement headerRow;
    private TableTableRowsElement rows;
    private String chartID;
    private boolean isApply3DEffect = false;
    private boolean isUseLegend = false;

    Chart(ChartChartElement chartElement, String chartID) {
        this.chartElement = chartElement;
        this.chartID = chartID;
        this.init();
    }

    private void init() {
        this.chartElement.setSvgWidthAttribute(CHART_SVG_WIDTH);
        this.chartElement.setSvgHeightAttribute(CHART_SVG_HEIGH);
        this.chartElement.setChartClassAttribute(CHART_CLASS_TYPE);
        this.chartElement.setProperty(StyleGraphicPropertiesElement.Stroke, CHART_PROPERTIES_STROKE);
    }

    private void setPlotArea() {
        NodeList plotAreas = this.chartElement.getElementsByTagName(ChartPlotAreaElement.ELEMENT_NAME.getQName());
        if (plotAreas.getLength() > 0) {
            this.chartElement.removeChild(plotAreas.item(0));
        }
        this.plotArea = this.chartElement.newChartPlotAreaElement();
        this.plotArea = (ChartPlotAreaElement)plotAreas.item(0);
        this.plotArea.setProperty(StyleChartPropertiesElement.RightAngledAxes, "true");
        this.plotArea.setSvgHeightAttribute(PLOTAREA_SVG_HEIGHT);
        this.plotArea.setSvgWidthAttribute(PLOTAREA_SVG_WIDTH);
        this.plotArea.setSvgXAttribute(PLOTAREA_SVG_X);
        this.plotArea.setSvgYAttribute(PLOTAREA_SVG_Y);
        ChartAxisElement axisX = this.plotArea.newChartAxisElement(ChartDimensionAttribute.Value.x.toString());
        if (this.getTableCellRange() != null) {
            ChartCategoriesElement categories = axisX.newChartCategoriesElement();
            categories.setTableCellRangeAddressAttribute(this.getTableCellRange());
        }
        axisX.setChartDimensionAttribute(ChartDimensionAttribute.Value.x.toString());
        axisX.setChartNameAttribute("primary-x");
        axisX.setProperty(StyleChartPropertiesElement.DisplayLabel, "true");
        axisX.setProperty(StyleChartPropertiesElement.Logarithmic, "false");
        axisX.setProperty(StyleChartPropertiesElement.ReverseDirection, "false");
        axisX.setProperty(StyleChartPropertiesElement.LineBreak, "false");
        axisX.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
        axisX.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
        axisX.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
        axisX.setProperty(StyleTextPropertiesElement.FontCharsetComplex, "10pt");
        ChartAxisElement axisY = this.plotArea.newChartAxisElement(ChartDimensionAttribute.Value.y.toString());
        axisY.setChartDimensionAttribute(ChartDimensionAttribute.Value.y.toString());
        axisY.setChartNameAttribute("primary-y");
        axisY.setProperty(StyleChartPropertiesElement.DisplayLabel, "true");
        axisY.setProperty(StyleChartPropertiesElement.Logarithmic, "false");
        axisY.setProperty(StyleChartPropertiesElement.ReverseDirection, "false");
        axisY.setProperty(StyleChartPropertiesElement.LineBreak, "false");
        axisY.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
        axisY.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
        axisY.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
        axisY.setProperty(StyleTextPropertiesElement.FontCharsetComplex, "10pt");
        ChartGridElement grid = axisY.newChartGridElement();
        grid.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
        grid.setChartClassAttribute(ChartClassAttribute.Value.MAJOR.toString());
        int numSeries = this.dataSet.getDataSeriesCount();
        Object[] valueCellRange = this.getValueCellRange();
        Object[] labelCellRange = this.getLabelCellRange();
        for (int i = 0; i < numSeries; ++i) {
            ChartSeriesElement series = this.plotArea.newChartSeriesElement();
            series.setChartClassAttribute(this.chartElement.getChartClassAttribute());
            series.setProperty(StyleGraphicPropertiesElement.Stroke, "solid");
            series.setProperty(StyleGraphicPropertiesElement.FillColor, this.getRandColorCode());
            series.setProperty(StyleGraphicPropertiesElement.EdgeRounding, "0%");
            series.setProperty(StyleTextPropertiesElement.FontSize, "6pt");
            series.setProperty(StyleTextPropertiesElement.FontSizeAsian, "6pt");
            series.setProperty(StyleTextPropertiesElement.FontCharsetComplex, "6pt");
            if ((String)valueCellRange[i] != null) {
                series.setChartValuesCellRangeAddressAttribute((String)valueCellRange[i]);
            }
            if ((String)labelCellRange[i] != null) {
                series.setChartLabelCellAddressAttribute((String)labelCellRange[i]);
            }
            ChartDataPointElement point = series.newChartDataPointElement();
            point.setChartRepeatedAttribute(new Integer(numSeries));
        }
        ChartWallElement wall = this.plotArea.newChartWallElement();
        wall.setProperty(StyleGraphicPropertiesElement.Stroke, CHART_PROPERTIES_STROKE);
        wall.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
        wall.setProperty(StyleGraphicPropertiesElement.Fill, CHART_PROPERTIES_STROKE);
        wall.setProperty(StyleGraphicPropertiesElement.FillColor, "#e6e6e6");
        ChartFloorElement floor = this.plotArea.newChartFloorElement();
        floor.setProperty(StyleGraphicPropertiesElement.Stroke, CHART_PROPERTIES_STROKE);
        floor.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
        floor.setProperty(StyleGraphicPropertiesElement.Fill, CHART_PROPERTIES_STROKE);
        floor.setProperty(StyleGraphicPropertiesElement.FillColor, "#e6e6e6");
    }

    public boolean IsApply3DEffect() {
        return this.isApply3DEffect;
    }

    public String getAxisTitle(String dimType) {
        NodeList chartAxises = this.plotArea.getElementsByTagName(ChartAxisElement.ELEMENT_NAME.getQName());
        for (int i = 0; i < chartAxises.getLength(); ++i) {
            ChartAxisElement axis = (ChartAxisElement)chartAxises.item(i);
            String dimension = axis.getAttributeNS(OdfDocumentNamespace.CHART.getUri(), "dimension");
            if (!dimension.equals(dimType)) continue;
            NodeList titles = axis.getElementsByTagName(ChartTitleElement.ELEMENT_NAME.getQName());
            ChartTitleElement axisTitle = (ChartTitleElement)titles.item(0);
            NodeList paras = axisTitle.getElementsByTagName(TextPElement.ELEMENT_NAME.getQName());
            return paras.item(0).getTextContent();
        }
        return null;
    }

    public DataSet getChartData() {
        if (this.dataSet == null) {
            this.dataSet = new DataSet();
            if (this.table == null) {
                this.table = (TableTableElement)this.chartElement.getElementsByTagName(TableTableElement.ELEMENT_NAME.getQName()).item(0);
                this.headerRows = (TableTableHeaderRowsElement)this.table.getElementsByTagName(TableTableHeaderRowsElement.ELEMENT_NAME.getQName()).item(0);
                this.headerRow = (TableTableRowElement)this.table.getElementsByTagName(TableTableRowElement.ELEMENT_NAME.getQName()).item(0);
                NodeList headerCells = this.headerRow.getElementsByTagName(TableTableCellElement.ELEMENT_NAME.getQName());
                int legendcount = headerCells.getLength() - 1;
                String[] legends = new String[legendcount];
                for (int i = 1; i < legendcount + 1; ++i) {
                    TableTableCellElement headerCell = (TableTableCellElement)headerCells.item(i);
                    legends[i - 1] = ((OdfTextParagraph)headerCell.getElementsByTagName(TextPElement.ELEMENT_NAME.getQName()).item(0)).getTextContent();
                }
                this.rows = (TableTableRowsElement)this.table.getElementsByTagName(TableTableRowsElement.ELEMENT_NAME.getQName()).item(0);
                NodeList row = this.rows.getElementsByTagName(TableTableRowElement.ELEMENT_NAME.getQName());
                int labelcount = row.getLength();
                double[][] values = new double[legendcount][labelcount];
                String[] labels = new String[labelcount];
                for (int i = 0; i < labelcount; ++i) {
                    NodeList cells = ((TableTableRowElement)row.item(i)).getElementsByTagNameNS(OdfDocumentNamespace.TABLE.getUri(), "table-cell");
                    labels[i] = ((OdfTextParagraph)((TableTableCellElement)cells.item(0)).getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p").item(0)).getTextContent();
                    for (int j = 0; j < legendcount; ++j) {
                        String aValue = ((TableTableCellElement)cells.item(j + 1)).getOdfAttributeValue(OdfName.newName(OdfNamespace.newNamespace(OdfDocumentNamespace.OFFICE), "value"));
                        values[j][i] = aValue == null || aValue.equals("") ? Double.NaN : Double.valueOf(aValue);
                    }
                }
                this.dataSet.setValues(labels, legends, values);
            }
        }
        return this.dataSet;
    }

    public String getChartTitle() {
        NodeList paras;
        if (this.chartTitle == null) {
            this.chartTitle = (ChartTitleElement)this.chartElement.getElementsByTagName(ChartTitleElement.ELEMENT_NAME.getQName()).item(0);
        }
        if ((paras = this.chartTitle.getElementsByTagName(TextPElement.ELEMENT_NAME.getQName())).getLength() > 0) {
            return paras.item(0).getTextContent();
        }
        return "";
    }

    public ChartType getChartType() {
        return ChartType.enumValueOf(this.chartElement.getChartClassAttribute());
    }

    public String getChartID() {
        return this.chartID;
    }

    public boolean isUseLegend() {
        return this.isUseLegend;
    }

    public void setApply3DEffect(boolean _3deffect) {
        this.isApply3DEffect = _3deffect;
        if (_3deffect) {
            this.legend.setProperty(StyleGraphicPropertiesElement.Stroke, CHART_PROPERTIES_STROKE);
            this.legend.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
            this.legend.setProperty(StyleGraphicPropertiesElement.Fill, CHART_PROPERTIES_STROKE);
            this.legend.setProperty(StyleGraphicPropertiesElement.FillColor, "#e6e6e6");
            this.legend.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
            this.legend.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
            this.legend.setProperty(StyleTextPropertiesElement.FontSizeComplex, "10pt");
            this.plotArea.setDr3dVpnAttribute("(0.416199821709347 0.173649045905254 0.892537795986984)");
            this.plotArea.setDr3dVrpAttribute("(17634.6218373783 10271.4823817647 24594.8639082739)");
            this.plotArea.setDr3dVupAttribute("(-0.0733876362771618 0.984807599917971 -0.157379306090273)");
            this.plotArea.setDr3dProjectionAttribute(Dr3dProjectionAttribute.Value.PARALLEL.toString());
            this.plotArea.setDr3dDistanceAttribute("4.2cm");
            this.plotArea.setDr3dFocalLengthAttribute(CHART_SVG_HEIGH);
            this.plotArea.setDr3dShadowSlantAttribute("0");
            this.plotArea.setDr3dShadeModeAttribute(Dr3dShadeModeAttribute.Value.FLAT.toString());
            this.plotArea.setDr3dAmbientColorAttribute("#999999");
            this.plotArea.setDr3dLightingModeAttribute("");
            this.plotArea.setProperty(StyleChartPropertiesElement.ThreeDimensional, "true");
            this.plotArea.setProperty(StyleChartPropertiesElement.SortByXValues, "false");
            this.plotArea.setProperty(StyleChartPropertiesElement.RightAngledAxes, "true");
            NodeList chartAxises = this.plotArea.getElementsByTagName(ChartAxisElement.ELEMENT_NAME.getQName());
            for (int i = 0; i < chartAxises.getLength(); ++i) {
                ChartAxisElement axis = (ChartAxisElement)chartAxises.item(i);
                if (axis.getChartDimensionAttribute().equals("x")) {
                    axis.setProperty(StyleChartPropertiesElement.DisplayLabel, "true");
                    axis.setProperty(StyleChartPropertiesElement.Logarithmic, "false");
                    axis.setProperty(StyleChartPropertiesElement.ReverseDirection, "false");
                    axis.setProperty(StyleChartPropertiesElement.LineBreak, "false");
                    axis.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
                    axis.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeComplex, "10pt");
                }
                if (axis.getChartDimensionAttribute().equals("y")) {
                    axis.setProperty(StyleTextPropertiesElement.FontSize, "9pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeAsian, "9pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeComplex, "9pt");
                }
                if (!axis.getChartDimensionAttribute().equals("z")) continue;
                axis.setProperty(StyleChartPropertiesElement.DisplayLabel, "true");
                axis.setProperty(StyleChartPropertiesElement.Logarithmic, "false");
                axis.setProperty(StyleChartPropertiesElement.ReverseDirection, "false");
                axis.setProperty(StyleChartPropertiesElement.LineBreak, "false");
                axis.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
                axis.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
                axis.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
                axis.setProperty(StyleTextPropertiesElement.FontSizeComplex, "10pt");
            }
            Dr3dLightElement light1 = this.plotArea.newDr3dLightElement("");
            light1.setDr3dDiffuseColorAttribute("#b3b3b3");
            light1.setDr3dDirectionAttribute("(0 0 1)");
            light1.setDr3dEnabledAttribute(new Boolean(false));
            light1.setDr3dSpecularAttribute(new Boolean(true));
            Dr3dLightElement light2 = this.plotArea.newDr3dLightElement("");
            light2.setDr3dDiffuseColorAttribute("#999999");
            light2.setDr3dDirectionAttribute("(-0.2 0.7 0.6)");
            light2.setDr3dEnabledAttribute(new Boolean(true));
            light2.setDr3dSpecularAttribute(new Boolean(false));
            Dr3dLightElement light3 = this.plotArea.newDr3dLightElement("");
            light3.setDr3dDiffuseColorAttribute("#b3b3b3");
            light3.setDr3dDirectionAttribute("(0 0 1)");
            light3.setDr3dEnabledAttribute(new Boolean(false));
            light3.setDr3dSpecularAttribute(new Boolean(false));
            Dr3dLightElement light4 = this.plotArea.newDr3dLightElement("");
            light4.setDr3dDiffuseColorAttribute("#b3b3b3");
            light4.setDr3dDirectionAttribute("(0 0 1)");
            light4.setDr3dEnabledAttribute(new Boolean(false));
            light4.setDr3dSpecularAttribute(new Boolean(false));
            Dr3dLightElement light5 = this.plotArea.newDr3dLightElement("");
            light5.setDr3dDiffuseColorAttribute("#b3b3b3");
            light5.setDr3dDirectionAttribute("(0 0 1)");
            light5.setDr3dEnabledAttribute(new Boolean(false));
            light5.setDr3dSpecularAttribute(new Boolean(false));
            Dr3dLightElement light6 = this.plotArea.newDr3dLightElement("");
            light6.setDr3dDiffuseColorAttribute("#b3b3b3");
            light6.setDr3dDirectionAttribute("(0 0 1)");
            light6.setDr3dEnabledAttribute(new Boolean(false));
            light6.setDr3dSpecularAttribute(new Boolean(false));
            Dr3dLightElement light7 = this.plotArea.newDr3dLightElement("");
            light7.setDr3dDiffuseColorAttribute("#b3b3b3");
            light7.setDr3dDirectionAttribute("(0 0 1)");
            light7.setDr3dEnabledAttribute(new Boolean(false));
            light7.setDr3dSpecularAttribute(new Boolean(false));
            Dr3dLightElement light8 = this.plotArea.newDr3dLightElement("");
            light8.setDr3dDiffuseColorAttribute("#b3b3b3");
            light8.setDr3dDirectionAttribute("(0 0 1)");
            light8.setDr3dEnabledAttribute(new Boolean(false));
            light8.setDr3dSpecularAttribute(new Boolean(false));
        } else {
            NodeList lights = this.plotArea.getElementsByTagName(Dr3dLightElement.ELEMENT_NAME.getQName());
            for (int i = 0; i < lights.getLength(); ++i) {
                this.plotArea.removeChild(lights.item(i));
            }
            if (lights.getLength() > 0) {
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "vpn");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "vrn");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "vun");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "projection");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "distance");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "focal-length");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "shadow-slant");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "shade-mode");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "ambient-color");
                this.plotArea.removeAttributeNS(OdfDocumentNamespace.SVG.getUri(), "lighting-mode");
                this.plotArea.removeProperty(StyleChartPropertiesElement.ThreeDimensional);
                this.plotArea.removeProperty(StyleChartPropertiesElement.SortByXValues);
                this.plotArea.setProperty(StyleChartPropertiesElement.RightAngledAxes, "true");
            }
            NodeList chartAxises = this.plotArea.getElementsByTagName(ChartAxisElement.ELEMENT_NAME.getQName());
            for (int i = 0; i < chartAxises.getLength(); ++i) {
                ChartAxisElement axis = (ChartAxisElement)chartAxises.item(i);
                if (axis.getChartDimensionAttribute().equals("x")) {
                    axis.setProperty(StyleChartPropertiesElement.DisplayLabel, "true");
                    axis.setProperty(StyleChartPropertiesElement.Logarithmic, "false");
                    axis.setProperty(StyleChartPropertiesElement.ReverseDirection, "false");
                    axis.setProperty(StyleChartPropertiesElement.LineBreak, "false");
                    axis.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
                    axis.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeComplex, "10pt");
                }
                if (axis.getChartDimensionAttribute().equals("y")) {
                    axis.setProperty(StyleChartPropertiesElement.DisplayLabel, "true");
                    axis.setProperty(StyleChartPropertiesElement.Logarithmic, "false");
                    axis.setProperty(StyleChartPropertiesElement.ReverseDirection, "false");
                    axis.setProperty(StyleChartPropertiesElement.LineBreak, "false");
                    axis.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
                    axis.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
                    axis.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
                    axis.setProperty(StyleTextPropertiesElement.FontCharsetComplex, "10pt");
                }
                if (!axis.getChartDimensionAttribute().equals("z")) continue;
                axis.removeProperty(StyleChartPropertiesElement.DisplayLabel);
                axis.removeProperty(StyleChartPropertiesElement.Logarithmic);
                axis.removeProperty(StyleChartPropertiesElement.ReverseDirection);
                axis.removeProperty(StyleChartPropertiesElement.LineBreak);
                axis.removeProperty(StyleGraphicPropertiesElement.StrokeColor);
                axis.removeProperty(StyleTextPropertiesElement.FontSize);
                axis.removeProperty(StyleTextPropertiesElement.FontSizeAsian);
                axis.removeProperty(StyleTextPropertiesElement.FontSizeComplex);
            }
        }
    }

    public void setAxisTitle(String dimType, String title) {
        NodeList chartAxises = this.plotArea.getElementsByTagName(ChartAxisElement.ELEMENT_NAME.getQName());
        for (int i = 0; i < chartAxises.getLength(); ++i) {
            ChartTitleElement axisTitle;
            ChartAxisElement axis = (ChartAxisElement)chartAxises.item(i);
            String dimension = axis.getAttributeNS(OdfDocumentNamespace.CHART.getUri(), "dimension");
            if (!dimension.equals(dimType)) continue;
            NodeList titles = axis.getElementsByTagName(ChartTitleElement.ELEMENT_NAME.getQName());
            if (titles.getLength() == 0) {
                axisTitle = axis.newChartTitleElement();
                if (dimension.equals(ChartDimensionAttribute.Value.x.toString())) {
                    axisTitle.setSvgXAttribute(AXIS_SVG_X);
                    axisTitle.setSvgYAttribute(AXIS_SVG_Y);
                } else {
                    axisTitle.setSvgXAttribute("0.161cm");
                    axisTitle.setSvgYAttribute("4.188cm");
                }
                axisTitle.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
                axisTitle.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
                axisTitle.setProperty(StyleTextPropertiesElement.FontSizeComplex, "10pt");
            } else {
                axisTitle = (ChartTitleElement)titles.item(0);
            }
            NodeList paras = axisTitle.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
            if (paras.getLength() == 0) {
                axisTitle.newTextPElement().setTextContent(title);
                continue;
            }
            TextPElement para0 = (TextPElement)paras.item(0);
            para0.setTextContent(title);
        }
    }

    public void setChartData(DataSet dataset) {
        this.dataSet = dataset;
        boolean isFirstRowAsLabel = this.dataSet.isFirstRowAsLabel();
        boolean isFirstColumnAsLabel = this.dataSet.isFirstColumnAsLabel();
        boolean isRowAsSeries = this.dataSet.isRowAsDataSeries();
        this.setPlotArea();
        NodeList tables = this.chartElement.getElementsByTagNameNS(OdfDocumentNamespace.CHART.getUri(), "table");
        if (tables.getLength() > 0) {
            this.chartElement.removeChild(tables.item(0));
        }
        this.table = this.chartElement.newTableTableElement();
        this.headerColumns = this.table.newTableTableHeaderColumnsElement();
        this.headerColumns.newTableTableColumnElement();
        this.columns = this.table.newTableTableColumnsElement();
        this.column = this.columns.newTableTableColumnElement();
        this.headerRows = this.table.newTableTableHeaderRowsElement();
        this.headerRow = this.headerRows.newTableTableRowElement();
        this.rows = this.table.newTableTableRowsElement();
        int numColumns = dataset.getLocalTableFirstRow().length;
        int numRows = dataset.getLocalTableFirstColumn().length;
        this.column.setTableNumberColumnsRepeatedAttribute(new Integer(numColumns));
        this.headerRow.newTableTableCellElement(0.0, "string");
        Object[] labelCellRange = this.getLabelCellRange();
        Object[] valueCellRange = this.getValueCellRange();
        for (int i = 0; i < numColumns; ++i) {
            TableTableCellElement cell = this.headerRow.newTableTableCellElement(0.0, "string");
            cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            String[] cellContents = dataset.getLocalTableFirstRow();
            OdfTextParagraph paragraph = (OdfTextParagraph)cell.newTextPElement();
            if (isFirstRowAsLabel && !isRowAsSeries && (String)labelCellRange[i] != null) {
                paragraph.setTextIdAttribute((String)labelCellRange[i]);
            }
            if (isFirstRowAsLabel && isRowAsSeries && i == 0 && this.getTableCellRange() != null) {
                paragraph.setTextIdAttribute(this.getTableCellRange());
            }
            if (cellContents[i] != null) {
                paragraph.setTextContent(cellContents[i]);
                continue;
            }
            paragraph.setTextContent("");
        }
        Double[][] cellValues = dataset.getLocalTableData();
        for (int i = 0; i < numRows; ++i) {
            TableTableRowElement row = this.rows.newTableTableRowElement();
            TableTableCellElement nameCell = row.newTableTableCellElement(0.0, "string");
            nameCell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.STRING.toString());
            OdfTextParagraph paragraph = (OdfTextParagraph)nameCell.newTextPElement();
            String[] cellContents = dataset.getLocalTableFirstColumn();
            if (cellContents[i] != null) {
                if (isFirstColumnAsLabel) {
                    if (isRowAsSeries) {
                        paragraph.setTextIdAttribute((String)labelCellRange[i]);
                    }
                    if (!isRowAsSeries && i == 0) {
                        paragraph.setTextIdAttribute(this.getTableCellRange());
                    }
                }
                paragraph.setTextContent(cellContents[i]);
            } else {
                paragraph.setTextContent("");
            }
            for (int j = 0; j < numColumns; ++j) {
                OdfTextParagraph paragraph1;
                TableTableCellElement cell = row.newTableTableCellElement(0.0, "string");
                cell.setOfficeValueTypeAttribute(OfficeValueTypeAttribute.Value.FLOAT.toString());
                if (cellValues[i][j] != null) {
                    cell.setOfficeValueAttribute(cellValues[i][j]);
                    paragraph1 = (OdfTextParagraph)cell.newTextPElement();
                    paragraph1.setTextContent(cellValues[i][j].toString());
                    if (isRowAsSeries && j == 0) {
                        paragraph1.setTextIdAttribute((String)valueCellRange[i]);
                    }
                    if (isRowAsSeries || i != 0) continue;
                    paragraph1.setTextIdAttribute((String)valueCellRange[j]);
                    continue;
                }
                cell.setOfficeValueAttribute(new Double(Double.NaN));
                paragraph1 = (OdfTextParagraph)cell.newTextPElement();
                paragraph1.setTextContent("1.#NAN");
                if (isRowAsSeries && j == 0) {
                    paragraph1.setTextIdAttribute((String)valueCellRange[i]);
                }
                if (isRowAsSeries || i != 0) continue;
                paragraph1.setTextIdAttribute((String)valueCellRange[j]);
            }
        }
    }

    public boolean setChartTitle(String title) {
        NodeList titles = this.chartElement.getElementsByTagNameNS(OdfDocumentNamespace.CHART.getUri(), "title");
        if (titles.getLength() == 0) {
            this.chartTitle = this.chartElement.newChartTitleElement();
            this.chartTitle.setSvgXAttribute("3.669cm");
            this.chartTitle.setSvgYAttribute("0.141cm");
            this.chartTitle.setProperty(StyleTextPropertiesElement.FontSize, "12pt");
            this.chartTitle.setProperty(StyleTextPropertiesElement.FontSizeAsian, "12pt");
            this.chartTitle.setProperty(StyleTextPropertiesElement.FontSizeComplex, "12pt");
        } else {
            this.chartTitle = (ChartTitleElement)titles.item(0);
        }
        NodeList paras = this.chartTitle.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "p");
        if (paras.getLength() == 0) {
            this.chartTitle.newTextPElement().setTextContent(title);
        } else {
            OdfTextParagraph para0 = (OdfTextParagraph)paras.item(0);
            para0.setTextContent(title);
        }
        return true;
    }

    public void setChartType(ChartType type) {
        this.chartElement.setChartClassAttribute(type.toString());
        NodeList plotAreas = this.chartElement.getElementsByTagName(ChartPlotAreaElement.ELEMENT_NAME.getQName());
        if (plotAreas.getLength() > 0) {
            ChartPlotAreaElement plotArea = (ChartPlotAreaElement)plotAreas.item(0);
            NodeList series = plotArea.getElementsByTagName(ChartSeriesElement.ELEMENT_NAME.getQName());
            for (int i = 0; i < series.getLength(); ++i) {
                ChartSeriesElement serie = (ChartSeriesElement)series.item(i);
                serie.setChartClassAttribute(type.toString());
            }
        }
    }

    public void setUseLegend(boolean useLegend) {
        this.isUseLegend = useLegend;
        NodeList legends = this.chartElement.getElementsByTagNameNS(OdfDocumentNamespace.CHART.getUri(), "legend");
        if (useLegend) {
            if (legends.getLength() == 0) {
                this.legend = this.chartElement.newChartLegendElement(ChartLegendPositionAttribute.Value.TOP_END.toString(), StyleLegendExpansionAttribute.Value.BALANCED.toString());
                this.legend.setSvgXAttribute("6.715cm");
                this.legend.setSvgYAttribute("3.192cm");
                this.legend.setProperty(StyleGraphicPropertiesElement.Stroke, CHART_PROPERTIES_STROKE);
                this.legend.setProperty(StyleGraphicPropertiesElement.StrokeColor, "#b3b3b3");
                this.legend.setProperty(StyleGraphicPropertiesElement.Fill, CHART_PROPERTIES_STROKE);
                this.legend.setProperty(StyleGraphicPropertiesElement.FillColor, "#e6e6e6");
                this.legend.setProperty(StyleTextPropertiesElement.FontSize, "10pt");
                this.legend.setProperty(StyleTextPropertiesElement.FontSizeAsian, "10pt");
                this.legend.setProperty(StyleTextPropertiesElement.FontSizeComplex, "10pt");
            }
        } else if (legends.getLength() > 0) {
            this.chartElement.removeChild(legends.item(0));
        }
    }

    public void refreshChart() {
        this.setPlotArea();
        this.setChartData(this.dataSet);
    }

    private String getRandColorCode() {
        Random random = new Random();
        String r = Integer.toHexString(random.nextInt(256)).toUpperCase();
        String g = Integer.toHexString(random.nextInt(256)).toUpperCase();
        String b = Integer.toHexString(random.nextInt(256)).toUpperCase();
        r = r.length() == 1 ? "0" + r : r;
        g = g.length() == 1 ? "0" + g : g;
        b = b.length() == 1 ? "0" + b : b;
        return "#" + r + g + b;
    }

    private Object[] getValueCellRange() {
        Vector<String> seriesCellRange = new Vector<String>();
        Vector<String> legendCellAddr = new Vector<String>();
        if (this.dataSet.isLocalTable()) {
            this.dataSet.getLocalTableCellRanges(this.dataSet.getDataSeriesCount(), this.dataSet.getLabels().length, seriesCellRange, legendCellAddr);
        } else {
            this.dataSet.getCellRanges(this.dataSet.getCellRangeAddress().toString(), this.dataSet.isFirstRowAsLabel(), this.dataSet.isFirstColumnAsLabel(), this.dataSet.isRowAsDataSeries(), seriesCellRange, legendCellAddr);
        }
        return seriesCellRange.toArray();
    }

    private Object[] getLabelCellRange() {
        Vector<String> seriesCellRange = new Vector<String>();
        Vector<String> legendCellAddr = new Vector<String>();
        if (this.dataSet.isLocalTable()) {
            this.getLocalTableCellRanges(this.dataSet.getDataSeriesCount(), this.dataSet.getLabels().length, seriesCellRange, legendCellAddr);
        } else {
            this.getCellRanges(this.dataSet.getCellRangeAddress().toString(), this.dataSet.isFirstRowAsLabel(), this.dataSet.isFirstColumnAsLabel(), this.dataSet.isRowAsDataSeries(), seriesCellRange, legendCellAddr);
        }
        return legendCellAddr.toArray();
    }

    private String getTableCellRange() {
        Vector<String> seriesCellRange = new Vector<String>();
        Vector<String> legendCellAddr = new Vector<String>();
        String cellRange = this.dataSet.isLocalTable() ? this.getLocalTableCellRanges(this.dataSet.getDataSeriesCount(), this.dataSet.getLabels().length, seriesCellRange, legendCellAddr) : this.getCellRanges(this.dataSet.getCellRangeAddress().toString(), this.dataSet.isFirstRowAsLabel(), this.dataSet.isFirstColumnAsLabel(), this.dataSet.isRowAsDataSeries(), seriesCellRange, legendCellAddr);
        return cellRange;
    }

    private String getCellRanges(String tablecellrange, boolean bFirstRowAsLabel, boolean bFirstColumnAsLabel, boolean rowAsDataSeries, Vector<String> seriesCellRange, Vector<String> legendCellAddr) {
        String labelCellRange = null;
        if (seriesCellRange == null) {
            seriesCellRange = new Vector();
        } else {
            seriesCellRange.removeAllElements();
        }
        if (legendCellAddr == null) {
            legendCellAddr = new Vector();
        } else {
            legendCellAddr.removeAllElements();
        }
        StringTokenizer st = new StringTokenizer(tablecellrange, ".:$ ");
        if (st.countTokens() < 3) {
            return null;
        }
        String sheettable = st.nextToken();
        String begincell = st.nextToken();
        String endcell = st.nextToken();
        if (st.hasMoreTokens()) {
            endcell = st.nextToken();
        }
        char beginColumn = begincell.charAt(0);
        char endColumn = endcell.charAt(0);
        int beginRow = Integer.parseInt(begincell.substring(1));
        int endRow = Integer.parseInt(endcell.substring(1));
        if (rowAsDataSeries) {
            int starti = beginRow + 1;
            if (!bFirstRowAsLabel) {
                labelCellRange = null;
                starti = beginRow;
            } else {
                labelCellRange = bFirstColumnAsLabel ? this.createCellRange(sheettable, beginRow, (char)(beginColumn + '\u0001'), beginRow, endColumn) : this.createCellRange(sheettable, beginRow, beginColumn, beginRow, endColumn);
            }
            for (int i = starti; i < endRow + 1; ++i) {
                if (bFirstColumnAsLabel) {
                    seriesCellRange.add(this.createCellRange(sheettable, i, (char)(beginColumn + '\u0001'), i, endColumn));
                } else {
                    seriesCellRange.add(this.createCellRange(sheettable, i, beginColumn, i, endColumn));
                }
                if (bFirstColumnAsLabel) {
                    legendCellAddr.add(sheettable + "." + beginColumn + i);
                    continue;
                }
                legendCellAddr.add(null);
            }
        } else {
            char startch = (char)(beginColumn + '\u0001');
            if (!bFirstColumnAsLabel) {
                labelCellRange = null;
                startch = beginColumn;
            } else {
                labelCellRange = bFirstRowAsLabel ? this.createCellRange(sheettable, beginRow + 1, beginColumn, endRow, beginColumn) : this.createCellRange(sheettable, beginRow, beginColumn, endRow, beginColumn);
            }
            for (char ch = startch; ch <= endColumn; ch = (char)(ch + '\u0001')) {
                if (bFirstRowAsLabel) {
                    seriesCellRange.add(this.createCellRange(sheettable, beginRow + 1, ch, endRow, ch));
                } else {
                    seriesCellRange.add(this.createCellRange(sheettable, beginRow, ch, endRow, ch));
                }
                if (bFirstRowAsLabel) {
                    legendCellAddr.add(sheettable + "." + ch + beginRow);
                    continue;
                }
                legendCellAddr.add(null);
            }
        }
        return labelCellRange;
    }

    private String getLocalTableCellRanges(int seriesCount, int labelLength, Vector<String> seriesCellRange, Vector<String> legendCellAddr) {
        String localtable = "local-table";
        String tablecellrange = localtable + "." + "A1:" + (char)(65 + seriesCount) + (1 + labelLength);
        return this.dataSet.getCellRanges(tablecellrange, true, true, false, seriesCellRange, legendCellAddr);
    }

    private String createCellRange(String table, int beginRow, char beginColumn, int endRow, char endColumn) {
        return table + "." + beginColumn + beginRow + ":" + table + "." + endColumn + endRow;
    }
}

