/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.awt.Rectangle;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeSpreadsheetElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.type.CellRangeAddressList;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.chart.AbstractChartContainer;
import org.odftoolkit.simple.chart.Chart;
import org.odftoolkit.simple.chart.ChartContainer;
import org.odftoolkit.simple.chart.DataSet;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetDocument
extends Document
implements ChartContainer {
    private static final String EMPTY_SPREADSHEET_DOCUMENT_PATH = "/OdfSpreadsheetDocument.ods";
    static final OdfPackageDocument.Resource EMPTY_SPREADSHEET_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfSpreadsheetDocument.ods");
    private ChartContainerImpl chartContainerImpl;

    public static SpreadsheetDocument newSpreadsheetDocument() throws Exception {
        return (SpreadsheetDocument)Document.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE, Document.OdfMediaType.SPREADSHEET);
    }

    public static SpreadsheetDocument newSpreadsheetTemplateDocument() throws Exception {
        SpreadsheetDocument doc = (SpreadsheetDocument)Document.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE, Document.OdfMediaType.SPREADSHEET_TEMPLATE);
        doc.changeMode(OdfMediaType.SPREADSHEET_TEMPLATE);
        return doc;
    }

    protected SpreadsheetDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static SpreadsheetDocument loadDocument(InputStream inputStream) throws Exception {
        return (SpreadsheetDocument)Document.loadDocument(inputStream);
    }

    public static SpreadsheetDocument loadDocument(String documentPath) throws Exception {
        return (SpreadsheetDocument)Document.loadDocument(documentPath);
    }

    public static SpreadsheetDocument loadDocument(File file) throws Exception {
        return (SpreadsheetDocument)Document.loadDocument(file);
    }

    @Override
    public OfficeSpreadsheetElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeSpreadsheetElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public Table getSheetByIndex(int index) {
        if (index < 0) {
            return null;
        }
        int count = 0;
        try {
            OfficeSpreadsheetElement spreadsheetElement = this.getContentRoot();
            for (Node child = spreadsheetElement.getFirstChild(); child != null && count <= index; child = child.getNextSibling()) {
                if (!(child instanceof TableTableElement)) continue;
                if (count == index) {
                    return this.getTableBuilder().getTableInstance((TableTableElement)child);
                }
                ++count;
            }
        }
        catch (Exception e2) {
            Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e2);
        }
        return null;
    }

    public Table getSheetByName(String name) {
        return this.getTableByName(name);
    }

    public Table appendSheet(String name) {
        Table newTable = this.addTable();
        newTable.setTableName(name);
        return newTable;
    }

    public Table appendSheet(Table refTable, String name) {
        TableTableElement refTableElement = refTable.getOdfElement();
        try {
            OdfContentDom contentDom = this.getContentDom();
            TableTableElement newTableEle = (TableTableElement)refTableElement.cloneNode(true);
            if (refTableElement.getOwnerDocument() != contentDom) {
                Document ownerDocument = refTable.getOwnerDocument();
                this.copyLinkedRefInBatch(newTableEle, ownerDocument);
                this.copyForeignStyleRef(newTableEle, ownerDocument);
                newTableEle = (TableTableElement)this.cloneForeignElement(newTableEle, contentDom, true);
            }
            this.updateNames(newTableEle);
            this.updateXMLIds(newTableEle);
            this.getTableContainerElement().appendChild(newTableEle);
            Table tableInstance = this.getTableBuilder().getTableInstance(newTableEle);
            tableInstance.setTableName(name);
            return tableInstance;
        }
        catch (Exception e2) {
            Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e2);
            return null;
        }
    }

    public Table insertSheet(int before) {
        if (before < 0) {
            return null;
        }
        int count = 0;
        try {
            OfficeSpreadsheetElement spreadsheetElement = this.getContentRoot();
            for (Node child = spreadsheetElement.getFirstChild(); child != null && count <= before; child = child.getNextSibling()) {
                if (!(child instanceof TableTableElement)) continue;
                if (count == before) {
                    Table table = this.getTableBuilder().newTable();
                    this.getContentRoot().insertBefore(table.getOdfElement(), child);
                    return table;
                }
                ++count;
            }
        }
        catch (Exception e2) {
            Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e2);
        }
        return null;
    }

    public Table insertSheet(Table refTable, int before) {
        if (before < 0) {
            return null;
        }
        int count = 0;
        try {
            OfficeSpreadsheetElement spreadsheetElement = this.getContentRoot();
            for (Node child = spreadsheetElement.getFirstChild(); child != null && count <= before; child = child.getNextSibling()) {
                if (!(child instanceof TableTableElement)) continue;
                if (count == before) {
                    TableTableElement refTableElement = refTable.getOdfElement();
                    try {
                        OdfContentDom contentDom = this.getContentDom();
                        TableTableElement newTableEle = (TableTableElement)refTableElement.cloneNode(true);
                        if (refTableElement.getOwnerDocument() != contentDom) {
                            Document ownerDocument = refTable.getOwnerDocument();
                            this.copyLinkedRefInBatch(newTableEle, ownerDocument);
                            this.copyForeignStyleRef(newTableEle, ownerDocument);
                            newTableEle = (TableTableElement)this.cloneForeignElement(newTableEle, contentDom, true);
                        }
                        this.updateNames(newTableEle);
                        this.updateXMLIds(newTableEle);
                        newTableEle.setTableNameAttribute(SpreadsheetDocument.getUniqueSheetName(this));
                        this.getContentRoot().insertBefore(newTableEle, child);
                        return this.getTableBuilder().getTableInstance(newTableEle);
                    }
                    catch (Exception e2) {
                        Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e2);
                        continue;
                    }
                }
                ++count;
            }
        }
        catch (Exception e3) {
            Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e3);
        }
        return null;
    }

    public void removeSheet(int index) {
        if (index < 0) {
            return;
        }
        int count = 0;
        try {
            OfficeSpreadsheetElement spreadsheetElement = this.getContentRoot();
            for (Node child = spreadsheetElement.getFirstChild(); child != null && count <= index; child = child.getNextSibling()) {
                if (!(child instanceof TableTableElement)) continue;
                if (count == index) {
                    spreadsheetElement.removeChild(child);
                    return;
                }
                ++count;
            }
        }
        catch (Exception e2) {
            Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e2);
        }
    }

    public int getSheetCount() {
        int count = 0;
        try {
            OfficeSpreadsheetElement spreadsheetElement = this.getContentRoot();
            for (Node child = spreadsheetElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof TableTableElement)) continue;
                ++count;
            }
        }
        catch (Exception e2) {
            Logger.getLogger(SpreadsheetDocument.class.getName()).log(Level.SEVERE, null, e2);
        }
        return count;
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    @Override
    public Chart createChart(String title, DataSet dataset, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, dataset, rect);
    }

    @Override
    public Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, document, cellRangeAddr, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries, rect);
    }

    @Override
    public Chart createChart(String title, String[] labels, String[] legends, double[][] data, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, labels, legends, data, rect);
    }

    public Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect, Cell cell) {
        return this.getChartContainerImpl().createChart(title, document, cellRangeAddr, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries, rect, cell);
    }

    @Override
    public void deleteChartById(String chartId) {
        this.getChartContainerImpl().deleteChartById(chartId);
    }

    @Override
    public void deleteChartByTitle(String title) {
        this.getChartContainerImpl().deleteChartByTitle(title);
    }

    @Override
    public Chart getChartById(String chartId) {
        return this.getChartContainerImpl().getChartById(chartId);
    }

    @Override
    public List<Chart> getChartByTitle(String title) {
        return this.getChartContainerImpl().getChartByTitle(title);
    }

    @Override
    public int getChartCount() {
        return this.getChartContainerImpl().getChartCount();
    }

    private static String getUniqueSheetName(TableContainer container2) {
        List<Table> tableList = container2.getTableList();
        boolean notUnique = true;
        String tablename = "Sheet" + (tableList.size() + 1);
        while (notUnique) {
            notUnique = false;
            for (int i = 0; i < tableList.size(); ++i) {
                if (tableList.get(i).getTableName() == null || !tableList.get(i).getTableName().equalsIgnoreCase(tablename)) continue;
                notUnique = true;
                break;
            }
            if (!notUnique) continue;
            tablename = tablename + Math.round(Math.random() * 10.0);
        }
        return tablename;
    }

    private ChartContainerImpl getChartContainerImpl() {
        if (this.chartContainerImpl == null) {
            this.chartContainerImpl = new ChartContainerImpl(this);
        }
        return this.chartContainerImpl;
    }

    private class ChartContainerImpl
    extends AbstractChartContainer {
        SpreadsheetDocument sdoc;
        DrawFrameElement drawFrame;

        protected ChartContainerImpl(Document doc) {
            super(doc);
            this.sdoc = (SpreadsheetDocument)doc;
        }

        protected DrawFrameElement getChartFrame() throws Exception {
            OdfContentDom contentDom2 = this.sdoc.getContentDom();
            DrawFrameElement drawFrame = contentDom2.newOdfElement(DrawFrameElement.class);
            TableTableCellElement lastCell = (TableTableCellElement)contentDom2.getXPath().evaluate("//table:table-cell[last()]", contentDom2, XPathConstants.NODE);
            lastCell.appendChild(drawFrame);
            drawFrame.removeAttribute("text:anchor-type");
            this.drawFrame = drawFrame;
            return drawFrame;
        }

        private Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect, Cell cell) {
            Chart chart = SpreadsheetDocument.this.getChartContainerImpl().createChart(title, document, cellRangeAddr, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries, rect);
            cell.getOdfElement().appendChild(this.drawFrame);
            return chart;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        SPREADSHEET(Document.OdfMediaType.SPREADSHEET),
        SPREADSHEET_TEMPLATE(Document.OdfMediaType.SPREADSHEET_TEMPLATE);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

