/*
 * Decompiled with CFR 0.152.
 */
package com.janus.qrinvoice.gui;

import com.janus.qrinvoice.QRInvoiceDTO;
import com.janus.qrinvoice.QRInvoiceWriter;
import com.janus.qrinvoice.gui.ApplicationContext;
import com.janus.qrinvoice.gui.ErrorMessages;
import com.janus.qrinvoice.gui.FieldType;
import com.janus.qrinvoice.gui.QRInvoice;
import com.janus.qrinvoice.gui.QRInvoiceOutputSize;
import com.janus.qrinvoice.gui.QRInvoiceParser;
import com.janus.qrinvoice.gui.QRInvoiceParserFactory;
import com.janus.qrinvoice.gui.QRInvoicePreferences;
import com.janus.qrinvoice.gui.QRInvoiceSeparatorType;
import com.janus.qrinvoice.gui.QRInvoiceVerificationStateCallback;
import com.janus.qrinvoice.gui.Styles;
import com.janus.qrinvoice.gui.verifier.NotNullIBANVerifier;
import com.janus.qrinvoice.gui.verifier.NotNullVerifier;
import com.janus.qrinvoice.parser.ParserLineResult;
import com.janus.qrinvoice.parser.ParserResult;
import com.janus.qrinvoice.validator.QRValidator;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.SeparatorType;

public class MainPanel
extends JPanel {
    public static final String LAST_OPEN_DIR = "last.open.dir";
    public static final String LAST_OPEN_DIR_TEMPLATE = "last.open.dir.template";
    private static final long serialVersionUID = 9827349827349L;
    protected Logger logger = Logger.getLogger(MainPanel.class.getName());
    protected StyledDocument centerTextPanelDocument;
    protected Styles logPanelStyle;
    protected JButton downloadButton;
    private final JLabel uploadLabel = new JLabel(ApplicationContext.get().text().getString("noFileSelected"));
    private final JLabel uploadTemplateLabel = new JLabel(ApplicationContext.get().text().getString("noFileSelected"));
    private JButton uploadBtn;
    private JButton uploadTemplateBtn;
    private JLabel ibanLabel;
    private JTextField ibanField;
    private JLabel kontoinhaberLabel;
    private JTextField kontoinhaberField;
    private JLabel strasseHausNrLabel;
    private JTextField strasseHausNrField;
    private JLabel plzOrtLabel;
    private JTextField plzOrtField;
    private JLabel mulitplePDFLabel;
    protected JRadioButton mulitplePDF;
    private JLabel singlePDFLabel;
    protected JRadioButton singlePDF;
    private ButtonGroup optionGroupPDF;
    private JLabel lastPageLabel;
    private JRadioButton lastPage;
    private JLabel newPageLabel;
    private JRadioButton newPage;
    private ButtonGroup optionGroupPage;
    private JLabel separatorLabel;
    private JComboBox<QRInvoiceSeparatorType> separatorComboBox;
    private JLabel outputsizeLabel;
    private JComboBox<QRInvoiceOutputSize> outputsizeComboBox;
    private QRInvoiceDTO qrinvoice;
    private Path invoiceTemplate;
    private ErrorMessages errorMessages;
    private JLabel errorLabel;
    private JButton openManual;
    private JButton openSupportEMail;
    private final QRInvoiceVerificationStateCallback callback;
    QRInvoicePreferences preferences = new QRInvoicePreferences();

    public MainPanel(StyledDocument styledDocument, JButton jButton) {
        this.centerTextPanelDocument = styledDocument;
        this.downloadButton = jButton;
        this.callback = new QRInvoiceVerificationStateCallback(jButton);
        this.logPanelStyle = new Styles(this.centerTextPanelDocument);
        this.init();
    }

    protected void doOpenFileDialog() {
        Object object;
        this.logger.finest("+doOpenFileDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("selectFile"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
        String string = qRInvoicePreferences.loadPreference(LAST_OPEN_DIR);
        if (string != null && ((File)(object = new File(string))).exists()) {
            jFileChooser.setCurrentDirectory((File)object);
        }
        object = new FileNameExtensionFilter(".xls, .xlsx, .csv, .ods", "csv", "xls", "xlsx", "ods");
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("importFile"));
        switch (n) {
            case 0: {
                qRInvoicePreferences.savePreference(LAST_OPEN_DIR, jFileChooser.getCurrentDirectory().toString());
                this.doOpenFile(Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]));
                break;
            }
            case 1: {
                this.logger.fine("Cancel pressed.");
                jFileChooser.setVisible(false);
                break;
            }
        }
        this.logger.finest("-doOpenFileDialog");
    }

    protected void doOpenTemplateFileDialog() {
        Object object;
        this.logger.finest("+doOpenTemplateFileDialog");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(ApplicationContext.get().text().getString("selectFile"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        QRInvoicePreferences qRInvoicePreferences = new QRInvoicePreferences();
        String string = qRInvoicePreferences.loadPreference(LAST_OPEN_DIR_TEMPLATE);
        if (string != null && ((File)(object = new File(string))).exists()) {
            jFileChooser.setCurrentDirectory((File)object);
        }
        object = new FileNameExtensionFilter(".pdf", "pdf");
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        int n = jFileChooser.showDialog(null, ApplicationContext.get().text().getString("importFile"));
        switch (n) {
            case 0: {
                qRInvoicePreferences.savePreference(LAST_OPEN_DIR_TEMPLATE, jFileChooser.getCurrentDirectory().toString());
                this.invoiceTemplate = Paths.get(jFileChooser.getSelectedFile().getAbsolutePath(), new String[0]);
                this.uploadTemplateLabel.setText(this.invoiceTemplate.toFile().getName());
                this.lastPage.setEnabled(true);
                this.newPage.setEnabled(true);
                break;
            }
            case 1: {
                this.logger.fine("Cancel pressed.");
                jFileChooser.setVisible(false);
                this.invoiceTemplate = null;
                this.uploadTemplateLabel.setText(ApplicationContext.get().text().getString("noFileSelected"));
                this.lastPage.setEnabled(false);
                this.newPage.setEnabled(false);
                break;
            }
        }
        this.logger.finest("-doOpenTemplateFileDialog");
    }

    public StyledDocument getCenterTextPanelDocument() {
        return this.centerTextPanelDocument;
    }

    public void setCenterTextPanelDocument(StyledDocument styledDocument) {
        this.centerTextPanelDocument = styledDocument;
    }

    protected void writeLogLine(String string, Style style) throws BadLocationException {
        this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), string, style);
        if (!style.getName().contains("icon")) {
            this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "\n", style);
        }
    }

    public void addFirstSteps() {
        try {
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step1"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step2"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("firstSteps.step3"), this.logPanelStyle.getRegularStyle());
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
        }
        catch (BadLocationException badLocationException) {
            this.logger.log(Level.SEVERE, "Exception while printing log lines.", badLocationException);
        }
    }

    protected static JPopupMenu getCopyCutPasteMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("cut"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("copy"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        jMenuItem.setText(ApplicationContext.get().text().getString("paste"));
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{28, 28, 28, 28, 0};
        gridBagLayout.rowHeights = new int[]{28, 28, 28, 28, 0, 28, 28, 28};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.ibanLabel = new JLabel("IBAN");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.ibanLabel, gridBagConstraints);
        this.ibanField = new JTextField();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        this.add((Component)this.ibanField, gridBagConstraints2);
        this.ibanField.setColumns(10);
        this.ibanField.setText(this.preferences.loadPreference(FieldType.IBAN.name()));
        this.ibanField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.kontoinhaberLabel = new JLabel(ApplicationContext.get().text().getString("accountHolder"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        this.add((Component)this.kontoinhaberLabel, gridBagConstraints3);
        this.kontoinhaberField = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 11;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        this.add((Component)this.kontoinhaberField, gridBagConstraints4);
        this.kontoinhaberField.setColumns(10);
        this.kontoinhaberField.setText(this.preferences.loadPreference(FieldType.KONTOINHABER.name()));
        this.kontoinhaberField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.strasseHausNrLabel = new JLabel(ApplicationContext.get().text().getString("strasseHausNr"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 2;
        this.add((Component)this.strasseHausNrLabel, gridBagConstraints5);
        this.strasseHausNrField = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints6.gridx = 2;
        gridBagConstraints6.gridy = 2;
        this.add((Component)this.strasseHausNrField, gridBagConstraints6);
        this.strasseHausNrField.setColumns(10);
        this.strasseHausNrField.setText(this.preferences.loadPreference(FieldType.STRASSE_HAUSNR.name()));
        this.strasseHausNrField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.plzOrtLabel = new JLabel(ApplicationContext.get().text().getString("plzOrt"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.anchor = 13;
        gridBagConstraints7.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 3;
        this.add((Component)this.plzOrtLabel, gridBagConstraints7);
        this.plzOrtField = new JTextField();
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 11;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.gridx = 2;
        gridBagConstraints8.gridy = 3;
        this.add((Component)this.plzOrtField, gridBagConstraints8);
        this.plzOrtField.setColumns(10);
        this.plzOrtField.setText(this.preferences.loadPreference(FieldType.PLZ_ORT.name()));
        this.plzOrtField.setComponentPopupMenu(MainPanel.getCopyCutPasteMenu());
        this.mulitplePDFLabel = new JLabel(ApplicationContext.get().text().getString("mulitplePDF"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.anchor = 13;
        gridBagConstraints9.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints9.gridx = 1;
        gridBagConstraints9.gridy = 4;
        this.add((Component)this.mulitplePDFLabel, gridBagConstraints9);
        this.mulitplePDF = new JRadioButton();
        this.mulitplePDF.setSelected(this.preferences.loadPreference(FieldType.MULTIPLE_PDF.name(), false));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridx = 2;
        gridBagConstraints10.gridy = 4;
        this.add((Component)this.mulitplePDF, gridBagConstraints10);
        this.singlePDFLabel = new JLabel(ApplicationContext.get().text().getString("singlePDF"));
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 13;
        gridBagConstraints11.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 5;
        this.add((Component)this.singlePDFLabel, gridBagConstraints11);
        this.singlePDF = new JRadioButton();
        this.singlePDF.setSelected(this.preferences.loadPreference(FieldType.SINGLE_PDF.name(), true));
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridx = 2;
        gridBagConstraints12.gridy = 5;
        this.add((Component)this.singlePDF, gridBagConstraints12);
        this.optionGroupPDF = new ButtonGroup();
        this.optionGroupPDF.add(this.mulitplePDF);
        this.optionGroupPDF.add(this.singlePDF);
        this.uploadTemplateLabel.setFont(new Font(this.uploadTemplateLabel.getFont().getName(), 2, this.uploadTemplateLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.anchor = 13;
        gridBagConstraints13.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.gridy = 6;
        this.add((Component)this.uploadTemplateLabel, gridBagConstraints13);
        this.uploadTemplateBtn = new JButton(ApplicationContext.get().text().getString("selectInvoiceTemplate"));
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.anchor = 18;
        gridBagConstraints14.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints14.gridx = 2;
        gridBagConstraints14.gridy = 6;
        this.add((Component)this.uploadTemplateBtn, gridBagConstraints14);
        this.uploadTemplateBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MainPanel.this.doOpenTemplateFileDialog();
            }
        });
        this.lastPageLabel = new JLabel(ApplicationContext.get().text().getString("lastPage"));
        this.lastPageLabel.setFont(new Font(this.lastPageLabel.getFont().getName(), 2, this.lastPageLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.anchor = 13;
        gridBagConstraints15.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints15.gridx = 1;
        gridBagConstraints15.gridy = 7;
        this.add((Component)this.lastPageLabel, gridBagConstraints15);
        this.lastPage = new JRadioButton();
        this.lastPage.setSelected(this.preferences.loadPreference(FieldType.LAST_PAGE.name(), false));
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints16.fill = 2;
        gridBagConstraints16.gridx = 2;
        gridBagConstraints16.gridy = 7;
        this.add((Component)this.lastPage, gridBagConstraints16);
        this.newPageLabel = new JLabel(ApplicationContext.get().text().getString("newPage"));
        this.newPageLabel.setFont(new Font(this.newPageLabel.getFont().getName(), 2, this.newPageLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.anchor = 13;
        gridBagConstraints17.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints17.gridx = 1;
        gridBagConstraints17.gridy = 8;
        this.add((Component)this.newPageLabel, gridBagConstraints17);
        this.newPage = new JRadioButton();
        this.newPage.setSelected(this.preferences.loadPreference(FieldType.NEW_PAGE.name(), true));
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.gridx = 2;
        gridBagConstraints18.gridy = 8;
        this.add((Component)this.newPage, gridBagConstraints18);
        this.optionGroupPage = new ButtonGroup();
        this.optionGroupPage.add(this.lastPage);
        this.optionGroupPage.add(this.newPage);
        this.lastPage.setEnabled(false);
        this.newPage.setEnabled(false);
        this.separatorLabel = new JLabel(ApplicationContext.get().text().getString("separator"));
        this.separatorLabel.setFont(new Font(this.separatorLabel.getFont().getName(), 2, this.separatorLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.anchor = 13;
        gridBagConstraints19.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints19.gridx = 1;
        gridBagConstraints19.gridy = 9;
        this.add((Component)this.separatorLabel, gridBagConstraints19);
        this.separatorComboBox = new JComboBox<QRInvoiceSeparatorType>(QRInvoiceSeparatorType.values());
        String string = this.preferences.loadPreference(FieldType.SEPARATOR_TYPE.name());
        this.separatorComboBox.setSelectedItem((Object)(string != null ? QRInvoiceSeparatorType.valueOf(string) : QRInvoiceSeparatorType.DASHED_LINE_WITH_SCISSORS));
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints20.fill = 2;
        gridBagConstraints20.gridx = 2;
        gridBagConstraints20.gridy = 9;
        this.add(this.separatorComboBox, gridBagConstraints20);
        this.outputsizeLabel = new JLabel(ApplicationContext.get().text().getString("outputsize"));
        this.outputsizeLabel.setFont(new Font(this.outputsizeLabel.getFont().getName(), 2, this.outputsizeLabel.getFont().getSize()));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.anchor = 13;
        gridBagConstraints21.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.gridy = 10;
        this.add((Component)this.outputsizeLabel, gridBagConstraints21);
        this.outputsizeComboBox = new JComboBox<QRInvoiceOutputSize>(QRInvoiceOutputSize.values());
        String string2 = this.preferences.loadPreference(FieldType.OUTPUT_SIZE.name());
        this.separatorComboBox.setSelectedItem((Object)(string2 != null ? QRInvoiceOutputSize.valueOf(string2) : QRInvoiceOutputSize.A4_PORTRAIT_SHEET));
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints22.fill = 2;
        gridBagConstraints22.gridx = 2;
        gridBagConstraints22.gridy = 10;
        this.add(this.outputsizeComboBox, gridBagConstraints22);
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.anchor = 13;
        gridBagConstraints23.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints23.gridx = 1;
        gridBagConstraints23.gridy = 11;
        this.add((Component)this.uploadLabel, gridBagConstraints23);
        this.uploadBtn = new JButton(ApplicationContext.get().text().getString("selectFile"));
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.anchor = 18;
        gridBagConstraints24.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints24.gridx = 2;
        gridBagConstraints24.gridy = 11;
        this.add((Component)this.uploadBtn, gridBagConstraints24);
        this.uploadBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MainPanel.this.doOpenFileDialog();
            }
        });
        this.openManual = new JButton(ApplicationContext.get().text().getString("openManual"));
        this.openManual.setToolTipText(ApplicationContext.get().text().getString("openManualTooltip"));
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints25.fill = 2;
        gridBagConstraints25.gridx = 3;
        gridBagConstraints25.gridy = 12;
        this.add((Component)this.openManual, gridBagConstraints25);
        this.openManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("manualURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    MainPanel.this.logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("manualURL"), exception);
                }
            }
        });
        this.openSupportEMail = new JButton(ApplicationContext.get().text().getString("openSupportEMail"));
        this.openSupportEMail.setToolTipText(ApplicationContext.get().text().getString("openSupportEMailTooltip"));
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints26.fill = 2;
        gridBagConstraints26.gridx = 3;
        gridBagConstraints26.gridy = 13;
        this.add((Component)this.openSupportEMail, gridBagConstraints26);
        this.openSupportEMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QRInvoice.openWebpage(new URL(ApplicationContext.get().text().getString("supportEMailURL")).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    MainPanel.this.logger.log(Level.WARNING, "Could not open connection to " + ApplicationContext.get().text().getString("supportEMailURL"), exception);
                }
            }
        });
        this.errorLabel = new JLabel("");
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints27.gridx = 2;
        gridBagConstraints27.gridy = 14;
        this.add((Component)this.errorLabel, gridBagConstraints27);
        this.errorMessages = new ErrorMessages(this.errorLabel);
        NotNullVerifier notNullVerifier = new NotNullVerifier(this.kontoinhaberField, FieldType.KONTOINHABER, this.callback, this.errorMessages);
        NotNullIBANVerifier notNullIBANVerifier = new NotNullIBANVerifier(this.ibanField, FieldType.IBAN, this.callback, this.errorMessages, false);
        NotNullVerifier notNullVerifier2 = new NotNullVerifier(this.strasseHausNrField, FieldType.STRASSE_HAUSNR, this.callback, this.errorMessages);
        NotNullVerifier notNullVerifier3 = new NotNullVerifier(this.plzOrtField, FieldType.PLZ_ORT, this.callback, this.errorMessages);
        this.kontoinhaberField.setInputVerifier(notNullVerifier);
        this.ibanField.setInputVerifier(notNullIBANVerifier);
        this.strasseHausNrField.setInputVerifier(notNullVerifier2);
        this.plzOrtField.setInputVerifier(notNullVerifier3);
        ((InputVerifier)notNullVerifier).verify(this.kontoinhaberField);
        ((InputVerifier)notNullIBANVerifier).verify(this.ibanField);
        ((InputVerifier)notNullVerifier2).verify(this.strasseHausNrField);
        ((InputVerifier)notNullVerifier3).verify(this.plzOrtField);
    }

    protected void getGuiValues() {
        this.qrinvoice.setKontoinhaber(this.kontoinhaberField.getText());
        this.qrinvoice.setIBAN(this.ibanField.getText());
        this.qrinvoice.setStrasseHausNr(this.strasseHausNrField.getText());
        this.qrinvoice.setPlzOrt(this.plzOrtField.getText());
    }

    protected void doOpenFile(Path path) {
        this.logger.finest("+doOpenFile");
        try {
            this.downloadButton.setEnabled(Boolean.FALSE);
            this.uploadLabel.setText(path.toFile().getName());
            boolean bl = QRValidator.validateQRIBAN(this.ibanField.getText().replace(" ", ""));
            QRInvoiceParser qRInvoiceParser = QRInvoiceParserFactory.create(path);
            ParserResult parserResult = qRInvoiceParser.parse(path.toFile(), bl);
            this.qrinvoice = parserResult.getQrinvoice();
            this.writeLogLine(this.uploadLabel.getText(), this.logPanelStyle.getRegularStyle());
            this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            int n = 0;
            for (ParserLineResult parserLineResult : parserResult.getLineResults()) {
                this.logger.log(Level.FINEST, String.format("Parsing %s", parserLineResult.getLineMessage()));
                ++n;
                if (parserLineResult.isSucessfull()) {
                    this.writeLogLine(parserLineResult.getLineMessage(), this.logPanelStyle.getIconOkStyle());
                    this.writeLogLine(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + (parserResult.getStartingRow() > 0 ? " (" + ApplicationContext.get().text().getString("row") + " " + (n + parserResult.getStartingRow()) + ")" : "") + " - " + parserLineResult.getLineMessage(), this.logPanelStyle.getRegularStyle());
                    continue;
                }
                this.writeLogLine(parserLineResult.getLineMessage(), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(" - " + ApplicationContext.get().text().getString("numberShort") + " " + n + (parserResult.getStartingRow() > 0 ? " (" + ApplicationContext.get().text().getString("row") + " " + (n + parserResult.getStartingRow()) + ")" : "") + " - " + parserLineResult.getLineMessage(), this.logPanelStyle.getErrorStyle());
            }
            this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("successfullyImported") + parserResult.getSuccessfull(), this.logPanelStyle.getRegularStyle());
            this.writeLogLine(ApplicationContext.get().text().getString("errorImported") + parserResult.getNotSuccessfull(), this.logPanelStyle.getRegularStyle());
            if (!parserResult.isHeaderSuccessfull()) {
                this.writeLogLine("---", this.logPanelStyle.getRegularStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("unknownError"), this.logPanelStyle.getErrorStyle());
            }
            this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            this.callback.setExternalVerification(parserResult.isHeaderSuccessfull() && parserResult.getSuccessfull() > 0);
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Exception while opening file.", exception);
        }
        this.logger.finest("-doOpenFile");
    }

    protected void doSave(Path path) {
        this.logger.finest("+doSave");
        if (this.qrinvoice != null && this.qrinvoice.getIBAN() != null && !this.qrinvoice.getIBAN().equals(this.ibanField.getText())) {
            try {
                this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("validation.iban.changed.warning"), this.logPanelStyle.getIconErrorStyle());
                this.writeLogLine(ApplicationContext.get().text().getString("validation.iban.changed.warning"), this.logPanelStyle.getRegularStyle());
                this.writeLogLine("-------------------------------", this.logPanelStyle.getRegularStyle());
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "Exception while printing log lines.", badLocationException);
            }
        } else {
            try {
                QRInvoiceWriter qRInvoiceWriter = new QRInvoiceWriter();
                this.getGuiValues();
                qRInvoiceWriter.createQRInvoices(this.qrinvoice, path, this.invoiceTemplate, this.newPage.isSelected(), this.singlePDF.isSelected(), SeparatorType.valueOf(((QRInvoiceSeparatorType)((Object)this.separatorComboBox.getSelectedItem())).name()), OutputSize.valueOf(((QRInvoiceOutputSize)((Object)this.outputsizeComboBox.getSelectedItem())).name()));
                this.logger.log(Level.INFO, String.format("QR invoice files created: %s", path.toAbsolutePath().toString()));
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getRegularStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconSaveStyle());
                this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("speicherort"), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()), this.logPanelStyle.getRegularStyle());
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "Exception while saving file.", exception);
                try {
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-------------------------------\n", this.logPanelStyle.getErrorStyle());
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), "-", this.logPanelStyle.getIconErrorStyle());
                    this.centerTextPanelDocument.insertString(this.centerTextPanelDocument.getLength(), String.format(" - " + MessageFormat.format(ApplicationContext.get().text().getString("errorWhileSaving"), exception.getMessage(), path.toAbsolutePath().toString()) + "\n", path.toAbsolutePath().toString()), this.logPanelStyle.getErrorStyle());
                }
                catch (BadLocationException badLocationException) {
                    this.logger.log(Level.SEVERE, "Exception while saving file.", badLocationException);
                }
            }
        }
        this.logger.finest("-doSave");
    }

    public QRInvoiceVerificationStateCallback getDownloadButtonCallback() {
        return this.callback;
    }

    public JLabel getUploadLabel() {
        return this.uploadLabel;
    }
}

