/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.graph;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.graph.GraphDistinctDataBag;
import com.hp.hpl.jena.sparql.graph.GraphMemPlain;
import com.hp.hpl.jena.sparql.util.RefBoolean;
import com.hp.hpl.jena.sparql.util.graph.GraphSink;
import org.apache.jena.atlas.data.ThresholdPolicy;

public class GraphFactory {
    private static RefBoolean usePlainGraph = new RefBoolean(ARQ.strictGraph);

    public static Graph createGraphMem() {
        return Factory.createGraphMem();
    }

    public static Graph createDefaultGraph() {
        return usePlainGraph.getValue() ? GraphFactory.createPlainGraph() : GraphFactory.createJenaDefaultGraph();
    }

    public static Graph createJenaDefaultGraph() {
        return Factory.createDefaultGraph();
    }

    public static Graph createPlainGraph() {
        return new GraphMemPlain();
    }

    public static Graph sinkGraph() {
        return new GraphSink();
    }

    public static Graph createDataBagGraph(ThresholdPolicy<Triple> thresholdPolicy) {
        return new GraphDistinctDataBag(thresholdPolicy);
    }

    public static Model makeJenaDefaultModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Model makeDefaultModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createDefaultGraph());
    }

    public static Model makePlainModel() {
        return ModelFactory.createModelForGraph(GraphFactory.createPlainGraph());
    }

    public static Model makeDataBagModel(ThresholdPolicy<Triple> thresholdPolicy) {
        return ModelFactory.createModelForGraph(GraphFactory.createDataBagGraph(thresholdPolicy));
    }
}

