/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpExtendAssign;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.atlas.lib.Lib;

public class OpAssign
extends OpExtendAssign {
    public static Op assign(Op op, Var var, Expr expr) {
        if (!(op instanceof OpAssign)) {
            return OpAssign.createAssign(op, var, expr);
        }
        OpAssign opAssign = (OpAssign)op;
        if (opAssign.assignments.contains(var)) {
            return OpAssign.createAssign(op, var, expr);
        }
        opAssign.add(var, expr);
        return opAssign;
    }

    public static Op assign(Op op, VarExprList exprs) {
        if (!(op instanceof OpAssign)) {
            return OpAssign.createAssign(op, exprs);
        }
        OpAssign opAssign = (OpAssign)op;
        for (Var var : exprs.getVars()) {
            if (!opAssign.assignments.contains(var)) continue;
            return OpAssign.createAssign(op, exprs);
        }
        opAssign.assignments.addAll(exprs);
        return opAssign;
    }

    public static OpAssign assignDirect(Op op, VarExprList exprs) {
        return new OpAssign(op, exprs);
    }

    private static Op createAssign(Op op, Var var, Expr expr) {
        return new OpAssign(op, new VarExprList(var, expr));
    }

    private static Op createAssign(Op op, VarExprList exprs) {
        VarExprList x = new VarExprList();
        x.addAll(exprs);
        return new OpAssign(op, x);
    }

    private OpAssign(Op subOp) {
        super(subOp);
    }

    private OpAssign(Op subOp, VarExprList exprs) {
        super(subOp, exprs);
    }

    @Override
    public String getName() {
        return "assign";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        OpAssign op = new OpAssign(subOp, new VarExprList(this.getVarExprList()));
        return op;
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpAssign)) {
            return false;
        }
        OpAssign assign2 = (OpAssign)other;
        if (!Lib.equal(this.assignments, assign2.assignments)) {
            return false;
        }
        return this.getSubOp().equalTo(assign2.getSubOp(), labelMap);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public OpExtendAssign copy(Op subOp, VarExprList varExprList) {
        return new OpAssign(subOp, varExprList);
    }
}

