<?xml version="1.0" encoding="utf-8"?>
<xs:stylesheet version="1.0"
	xmlns:xs="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xs:attribute-set name="cell-style-header">
		<xs:attribute name="border-width">0pt</xs:attribute>
		<xs:attribute name="border-style">none</xs:attribute>
	</xs:attribute-set>
	<xs:attribute-set name="block-style-header">
		<xs:attribute name="font-size">11pt</xs:attribute>
		<xs:attribute name="line-height">14pt</xs:attribute>
		<xs:attribute name="start-indent">1mm</xs:attribute>
		<xs:attribute name="end-indent">1mm</xs:attribute>
	</xs:attribute-set>
	<xs:attribute-set name="cell-style">
		<xs:attribute name="border-width">0.5pt</xs:attribute>
		<xs:attribute name="border-style">solid</xs:attribute>
		<xs:attribute name="border-color">black</xs:attribute>
	</xs:attribute-set>
	<xs:attribute-set name="block-style">
		<xs:attribute name="font-size">8pt</xs:attribute>
		<xs:attribute name="line-height">9pt</xs:attribute>
		<xs:attribute name="start-indent">1mm</xs:attribute>
		<xs:attribute name="end-indent">1mm</xs:attribute>
	</xs:attribute-set>

	<xs:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="DIN-A4" page-height="29.7cm" page-width="21cm" margin-top="1cm"  margin-bottom="1cm" margin-left="1cm" margin-right="1cm">
					<fo:region-body margin-top="1cm" margin-bottom="1cm" margin-left="1cm" margin-right="1cm" />
					<fo:region-before region-name="header" extent="1cm" />
					<fo:region-after region-name="footer" extent="1cm" />
					<fo:region-start region-name="left" extent="1cm" />
					<fo:region-end region-name="right" extent="1cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="DIN-A4">
				<fo:static-content flow-name="header">
					<fo:block font-size="14pt" text-align="left" font-weight="bold">Report SEPA File - Credit Transfer</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<fo:block text-align="center">
						Page
						<fo:page-number />
						of
						<fo:page-number-citation ref-id="LastPage" />
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:table border-style="none" table-layout="fixed" width="100%">
						<fo:table-column column-width="4.5cm" />
						<fo:table-column column-width="7.5cm" />
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">Batch ID:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/batchId" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">File name:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/fileName" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">File creation date:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/fileCreationDate" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block  xs:use-attribute-sets="block-style-header">&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block  xs:use-attribute-sets="block-style-header">&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">Account holder:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/kontoinhaber" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">IBAN:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/IBAN" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">BIC:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/BIC" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">Execution date:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/executionDateReport" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">Payment ID:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/pmtInfId" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block  xs:use-attribute-sets="block-style-header">&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block  xs:use-attribute-sets="block-style-header">&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">No. of Transactions:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/noOfTx" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">Sum of Transactions:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/sumOfTx" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block  xs:use-attribute-sets="block-style-header">&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block  xs:use-attribute-sets="block-style-header">&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">SHA1:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/sha1" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">SHA256:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/sha256" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">MD5:</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style-header">
									<fo:block xs:use-attribute-sets="block-style-header">
										<xs:value-of select="creditTransfer/md5" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<fo:block>&#160;</fo:block>
					<fo:block>&#160;</fo:block>
					<fo:table border-style="solid" table-layout="fixed"	width="100%">
						<fo:table-column column-width="3.5cm" />
						<fo:table-column column-width="4cm" />
						<fo:table-column column-width="2.5cm" />
						<fo:table-column column-width="4.5cm" />
						<fo:table-column column-width="1.75cm" />
						<fo:table-column column-width="2.25cm" />
						<fo:table-header>
							<fo:table-row>
								<fo:table-cell xs:use-attribute-sets="cell-style">
									<fo:block xs:use-attribute-sets="block-style-header" font-weight="bold" text-align="center">Account holder</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style">
									<fo:block xs:use-attribute-sets="block-style-header" font-weight="bold" text-align="center">IBAN</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style">
									<fo:block xs:use-attribute-sets="block-style-header" font-weight="bold" text-align="center">BIC</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style">
									<fo:block xs:use-attribute-sets="block-style-header" font-weight="bold" text-align="center">Remittance information</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style">
									<fo:block xs:use-attribute-sets="block-style-header" font-weight="bold" text-align="center">Amount</fo:block>
								</fo:table-cell>
								<fo:table-cell xs:use-attribute-sets="cell-style">
									<fo:block xs:use-attribute-sets="block-style-header" font-weight="bold" text-align="center">EndToEnd Id</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-header>
						<fo:table-body>
							<xs:apply-templates select="creditTransfer/transactionList" />
						</fo:table-body>
					</fo:table>
					<fo:block id="LastPage" />
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xs:template>

	<xs:template match="transactionList">
		<fo:table-row>
			<fo:table-cell xs:use-attribute-sets="cell-style">
				<fo:block xs:use-attribute-sets="block-style">
					<xs:value-of select="kontoinhaber" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xs:use-attribute-sets="cell-style">
				<fo:block xs:use-attribute-sets="block-style">
					<xs:value-of select="IBAN" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xs:use-attribute-sets="cell-style">
				<fo:block xs:use-attribute-sets="block-style">
					<xs:value-of select="BIC" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xs:use-attribute-sets="cell-style">
				<fo:block xs:use-attribute-sets="block-style">
					<xs:value-of select="verwendungszweck" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xs:use-attribute-sets="cell-style">
				<fo:block xs:use-attribute-sets="block-style">
					<xs:value-of select="amount" />
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xs:use-attribute-sets="cell-style">
				<fo:block xs:use-attribute-sets="block-style">
					<xs:value-of select="end2EndId" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xs:template>

</xs:stylesheet>