/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBackgroundColorAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoBorderTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoWrapOptionAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthBottomAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthLeftAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthRightAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleBorderLineWidthTopAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalBlTrAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalBlTrWidthsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalTlBrAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleDiagonalTlBrWidthsAttribute;
import org.odftoolkit.odfdom.dom.attribute.style.StyleVerticalAlignAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.BorderPropertiesImpl;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class TableCellProperties {
    String padding;
    String paddingBottom;
    String paddingLeft;
    String paddingRight;
    String paddingTop;
    String cellProtect;
    String decimalPlaces;
    String direction;
    String glyphOrientationVertical;
    String printContent;
    String repeatContent;
    String rotationAlign;
    String rotationAngle;
    String shadow;
    String shrinkToFit;
    String textAlignSource;
    String verticalAlign;
    String writingMode;
    BorderPropertiesImpl mBorderPropertiesHandler;
    StyleTableCellPropertiesElement mElement;

    protected TableCellProperties() {
    }

    protected TableCellProperties(StyleTableCellPropertiesElement properties) {
        this.mElement = properties;
        this.mBorderPropertiesHandler = new BorderPropertiesImpl(this.mElement);
    }

    public void setBorders(StyleTypeDefinitions.CellBordersType bordersType, Border border) {
        switch (bordersType) {
            case BOTTOM: {
                this.setBottomBorder(border);
                break;
            }
            case LEFT: {
                this.setLeftBorder(border);
                break;
            }
            case RIGHT: {
                this.setRightBorder(border);
                break;
            }
            case TOP: {
                this.setTopBorder(border);
                break;
            }
            case DIAGONALBLTR: {
                this.setDiagonalBlTr(border);
                break;
            }
            case DIAGONALTLBR: {
                this.setDiagonalTlBr(border);
                break;
            }
            case ALL_FOUR: {
                this.setBorder(border);
                break;
            }
            case LEFT_RIGHT: {
                this.setLeftBorder(border);
                this.setRightBorder(border);
                break;
            }
            case TOP_BOTTOM: {
                this.setTopBorder(border);
                this.setBottomBorder(border);
                break;
            }
            case DIAGONAL_LINES: {
                this.setDiagonalBlTr(border);
                this.setDiagonalTlBr(border);
                break;
            }
            case NONE: {
                this.mElement.removeAttribute(StyleBorderLineWidthAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderBottomAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthTopAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderTopAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderLeftAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleBorderLineWidthRightAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(FoBorderRightAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalBlTrWidthsAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalBlTrAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalTlBrWidthsAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalTlBrAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public Border getBorder() {
        return this.mBorderPropertiesHandler.getBorder();
    }

    public Border getTopBorder() {
        return this.mBorderPropertiesHandler.getTopBorder();
    }

    public Border getLeftBorder() {
        return this.mBorderPropertiesHandler.getLeftBorder();
    }

    public Border getRightBorder() {
        return this.mBorderPropertiesHandler.getRightBorder();
    }

    public Border getBottomBorder() {
        return this.mBorderPropertiesHandler.getBottomBorder();
    }

    public Border getDiagonalBlTr() {
        Border border = new Border();
        String borderAttr = this.mElement.getStyleDiagonalBlTrAttribute();
        String borderWidth = this.mElement.getStyleDiagonalBlTrWidthsAttribute();
        if (borderWidth == null) {
            borderWidth = this.mElement.getAttribute("style:diagonal-bl-tr-width");
        }
        if (borderAttr == null || borderAttr.length() == 0) {
            return null;
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }

    public Border getDiagonalTlBr() {
        Border border = new Border();
        String borderAttr = this.mElement.getStyleDiagonalTlBrAttribute();
        String borderWidth = this.mElement.getStyleDiagonalTlBrWidthsAttribute();
        if (borderWidth == null) {
            borderWidth = this.mElement.getAttribute("style:diagonal-tl-br-width");
        }
        border.setBorderByDescription(borderAttr);
        if (borderWidth != null && borderWidth.length() != 0) {
            border.setDoubleLineWidthByDescription(borderWidth);
        }
        return border;
    }

    public void setBottomBorder(Border border) {
        this.mBorderPropertiesHandler.setBottomBorder(border);
    }

    public void setTopBorder(Border border) {
        this.mBorderPropertiesHandler.setTopBorder(border);
    }

    public void setLeftBorder(Border border) {
        this.mBorderPropertiesHandler.setLeftBorder(border);
    }

    public void setRightBorder(Border border) {
        this.mBorderPropertiesHandler.setRightBorder(border);
    }

    public void setDiagonalBlTr(Border border) {
        if (border == null) {
            this.mElement.removeAttribute(StyleDiagonalBlTrWidthsAttribute.ATTRIBUTE_NAME.getQName());
            this.mElement.removeAttribute(StyleDiagonalBlTrAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.mElement.setStyleDiagonalBlTrWidthsAttribute(border.getDoubleLineWidthDescription());
                this.mElement.setStyleDiagonalBlTrAttribute(border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.mElement.setStyleDiagonalBlTrAttribute(border.getBorderDescription());
                break;
            }
            case NONE: {
                this.mElement.removeAttribute(StyleDiagonalBlTrWidthsAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalBlTrAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setDiagonalTlBr(Border border) {
        if (border == null) {
            this.mElement.removeAttribute(StyleDiagonalTlBrWidthsAttribute.ATTRIBUTE_NAME.getQName());
            this.mElement.removeAttribute(StyleDiagonalTlBrAttribute.ATTRIBUTE_NAME.getQName());
            return;
        }
        switch (border.lineStyle) {
            case DOUBLE: {
                this.mElement.setStyleDiagonalTlBrWidthsAttribute(border.getDoubleLineWidthDescription());
                this.mElement.setStyleDiagonalTlBrAttribute(border.getBorderDescription());
                break;
            }
            case SINGLE: {
                this.mElement.setStyleDiagonalTlBrAttribute(border.getBorderDescription());
                break;
            }
            case NONE: {
                this.mElement.removeAttribute(StyleDiagonalTlBrWidthsAttribute.ATTRIBUTE_NAME.getQName());
                this.mElement.removeAttribute(StyleDiagonalTlBrAttribute.ATTRIBUTE_NAME.getQName());
            }
        }
    }

    public void setBorder(Border border) {
        this.mBorderPropertiesHandler.setBorder(border);
    }

    public void setBackgroundColor(Color aColor) {
        if (aColor == null) {
            this.mElement.removeAttribute(FoBackgroundColorAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoBackgroundColorAttribute(aColor.toString());
        }
    }

    public Color getBackgroundColor() {
        String property = this.mElement.getFoBackgroundColorAttribute();
        Color color = null;
        try {
            color = Color.valueOf(property);
        }
        catch (Exception e2) {
            Logger.getLogger(TableCellProperties.class.getName()).log(Level.WARNING, e2.getMessage());
        }
        return color;
    }

    public void setWrapped(boolean isWrapped) {
        if (isWrapped) {
            this.mElement.setFoWrapOptionAttribute(FoWrapOptionAttribute.Value.WRAP.toString());
        } else {
            this.mElement.setFoWrapOptionAttribute(FoWrapOptionAttribute.Value.NO_WRAP.toString());
        }
    }

    public void setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType alignType) {
        if (alignType == StyleTypeDefinitions.VerticalAlignmentType.DEFAULT || alignType == null) {
            this.mElement.removeAttribute(StyleVerticalAlignAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setStyleVerticalAlignAttribute(alignType.toString());
        }
    }

    public StyleTypeDefinitions.VerticalAlignmentType getVerticalAlignment() {
        String alignType = this.mElement.getStyleVerticalAlignAttribute();
        if (alignType == null || alignType.length() == 0) {
            return null;
        }
        StyleVerticalAlignAttribute.Value value = StyleVerticalAlignAttribute.Value.enumValueOf(alignType);
        switch (value) {
            case AUTO: {
                return StyleTypeDefinitions.VerticalAlignmentType.DEFAULT;
            }
            case AUTOMATIC: {
                return StyleTypeDefinitions.VerticalAlignmentType.DEFAULT;
            }
            case BASELINE: {
                return StyleTypeDefinitions.VerticalAlignmentType.BOTTOM;
            }
            case BOTTOM: {
                return StyleTypeDefinitions.VerticalAlignmentType.BOTTOM;
            }
            case MIDDLE: {
                return StyleTypeDefinitions.VerticalAlignmentType.MIDDLE;
            }
            case TOP: {
                return StyleTypeDefinitions.VerticalAlignmentType.TOP;
            }
        }
        return null;
    }

    public Boolean isWrapped() {
        String attr = this.mElement.getFoWrapOptionAttribute();
        if (attr == null || attr.length() == 0) {
            return false;
        }
        FoWrapOptionAttribute.Value value = FoWrapOptionAttribute.Value.enumValueOf(attr);
        switch (value) {
            case NO_WRAP: {
                return false;
            }
            case WRAP: {
                return true;
            }
        }
        return null;
    }

    public static TableCellProperties getOrCreateTableCellProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.TableCellProperties);
        return new TableCellProperties((StyleTableCellPropertiesElement)properties);
    }

    public static TableCellProperties getTableCellProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.TableCellProperties);
        if (properties != null) {
            return new TableCellProperties((StyleTableCellPropertiesElement)properties);
        }
        return null;
    }
}

