/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.form;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.form.FormComboboxElement;
import org.odftoolkit.odfdom.dom.element.form.FormFormElement;
import org.odftoolkit.odfdom.dom.element.form.FormItemElement;
import org.odftoolkit.odfdom.dom.element.form.FormPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.form.Form;
import org.odftoolkit.simple.form.FormControl;
import org.odftoolkit.simple.form.FormTypeDefinition;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBox
extends FormControl {
    private ArrayList<String> entries;

    ComboBox(FormComboboxElement element) {
        this.mElement = element;
        this.formElement = (FormFormElement)element.getParentNode();
    }

    public static ComboBox getInstanceOf(FormComboboxElement element) {
        ComboBox combo = new ComboBox(element);
        try {
            combo.loadDrawControl(((Document)((OdfFileDom)element.getOwnerDocument()).getDocument()).getContentRoot());
        }
        catch (Exception e2) {
            Logger.getLogger(ComboBox.class.getName()).log(Level.WARNING, "Cannot load the drawing shape of this combo box.");
        }
        return combo;
    }

    @Override
    FormPropertiesElement getFormPropertiesElementForWrite() {
        if (this.mFormProperties == null) {
            this.mFormProperties = ((FormComboboxElement)this.mElement).newFormPropertiesElement();
        }
        return this.mFormProperties;
    }

    @Override
    public void setControlImplementation(String controlImpl) {
        ((FormComboboxElement)this.mElement).setFormControlImplementationAttribute(controlImpl);
    }

    @Override
    public String getId() {
        return ((FormComboboxElement)this.mElement).getFormIdAttribute();
    }

    @Override
    public void setId(String id) {
        ((FormComboboxElement)this.mElement).setFormIdAttribute(id);
    }

    @Override
    public String getName() {
        return ((FormComboboxElement)this.mElement).getFormNameAttribute();
    }

    @Override
    public void setName(String name) {
        ((FormComboboxElement)this.mElement).setFormNameAttribute(name);
    }

    public void setFormDropdown(boolean isDropDown) {
        ((FormComboboxElement)this.mElement).setFormDropdownAttribute(isDropDown);
    }

    public boolean getFormDropdown() {
        return ((FormComboboxElement)this.mElement).getFormDropdownAttribute();
    }

    public void addItem(String item) {
        if (item == null) {
            return;
        }
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        ((FormComboboxElement)this.mElement).newFormItemElement().setFormLabelAttribute(item);
        this.entries.add(item);
    }

    public void addItems(String[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            this.addItem(items[i]);
        }
    }

    public ArrayList<String> getEntries() {
        NodeList items;
        if ((this.entries == null || this.entries.size() == 0) && (items = this.mElement.getElementsByTagName("form:item")) != null && items.getLength() > 0) {
            for (int i = 0; i < items.getLength(); ++i) {
                if (this.entries == null) {
                    this.entries = new ArrayList();
                }
                this.entries.add(((FormItemElement)items.item(i)).getFormLabelAttribute());
            }
            return this.entries;
        }
        return null;
    }

    public void setListSourceType(FormTypeDefinition.FormListSourceType type) {
        ((FormComboboxElement)this.mElement).setFormListSourceTypeAttribute(type.toString());
    }

    public FormTypeDefinition.FormListSourceType getListSourceType() {
        String value = ((FormComboboxElement)this.mElement).getFormListSourceTypeAttribute();
        return FormTypeDefinition.FormListSourceType.enumValueOf(value);
    }

    public void setListSource(String listSource) {
        ((FormComboboxElement)this.mElement).setFormListSourceAttribute(listSource);
    }

    public String getListSource() {
        return ((FormComboboxElement)this.mElement).getFormListSourceAttribute();
    }

    public void setDataField(String dataField) {
        ((FormComboboxElement)this.mElement).setFormDataFieldAttribute(dataField);
    }

    public String getDataField() {
        return ((FormComboboxElement)this.mElement).getFormDataFieldAttribute();
    }

    public void setValue(String defaultValue) {
        ((FormComboboxElement)this.mElement).setFormValueAttribute(defaultValue);
    }

    public String getValue() {
        return ((FormComboboxElement)this.mElement).getFormValueAttribute();
    }

    public void setCurrentValue(String currentValue) {
        ((FormComboboxElement)this.mElement).setFormCurrentValueAttribute(currentValue);
    }

    public String getCurrentValue() {
        return ((FormComboboxElement)this.mElement).getFormCurrentValueAttribute();
    }

    public static Iterator<FormControl> getSimpleIterator(Form container2) {
        return new SimpleComboBoxIterator(container2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleComboBoxIterator
    implements Iterator<FormControl> {
        private FormFormElement containerElement;
        private ComboBox nextElement = null;
        private ComboBox tempElement = null;

        private SimpleComboBoxIterator(Form container2) {
            this.containerElement = container2.getOdfElement();
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public ComboBox next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.nextElement.remove();
        }

        private ComboBox findNext(ComboBox thisComboBox) {
            FormComboboxElement nextComboBox = null;
            nextComboBox = thisComboBox == null ? OdfElement.findFirstChildNode(FormComboboxElement.class, this.containerElement) : OdfElement.findNextChildNode(FormComboboxElement.class, thisComboBox.getOdfElement());
            if (nextComboBox != null) {
                return ComboBox.getInstanceOf(nextComboBox);
            }
            return null;
        }
    }
}

