/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextNavigation;
import org.odftoolkit.simple.common.navigation.TextSelection;
import org.odftoolkit.simple.style.ParagraphProperties;
import org.odftoolkit.simple.text.Paragraph;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParagraphSelection
extends Selection {
    private TextSelection textSelection;
    private Paragraph paragraphContainer;
    private Paragraph sourceParagraph;

    public Paragraph replaceWithParagraph(Paragraph paragraph) {
        this.sourceParagraph = paragraph;
        if (this.search instanceof TextNavigation) {
            TextNavigation textSearch = (TextNavigation)this.search;
            int leftLength = this.textSelection.getText().length();
            int index = this.textSelection.getIndex();
            boolean continued = false;
            if (textSearch != null && textSearch.getReplacedItem() != null && textSearch.getReplacedItem().getElement() == this.textSelection.getElement()) {
                continued = true;
            } else {
                textSearch.setHandlePageBreak(false);
            }
            this.prepareParagraphContainer(leftLength, index, continued);
            Selection.SelectionManager.unregisterItem(this.textSelection);
            if (textSearch != null) {
                textSearch.setReplacedItem(this.textSelection);
                TextParagraphElementBase containerElement = this.paragraphContainer.getOdfElement();
                String content = TextExtractor.getText(containerElement);
                TextSelection selected = TextSelection.newTextSelection(textSearch, this.textSelection.getText(), containerElement, content.length() - 1);
                textSearch.setSelectedItem(selected);
            }
        }
        return this.paragraphContainer;
    }

    public ParagraphSelection(TextSelection selection) {
        this.textSelection = selection;
        this.search = this.textSelection.getTextNavigation();
        this.paragraphContainer = null;
    }

    public void cut() throws InvalidNavigationException {
        this.textSelection.cut();
    }

    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtEndOf(positionItem);
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e2) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromIndex, leftLength, node);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        this.textSelection.pasteAtFrontOf(positionItem);
    }

    protected void refresh(int offset) {
        this.textSelection.refresh(offset);
    }

    protected void refreshAfterFrontalDelete(Selection deletedItem) {
        this.textSelection.refreshAfterFrontalDelete(deletedItem);
    }

    protected void refreshAfterFrontalInsert(Selection insertedItem) {
        this.textSelection.refreshAfterFrontalInsert(insertedItem);
    }

    private ParagraphProperties getParagraphPropertiesForWrite() {
        OdfStyleBase style = this.paragraphContainer.getStyleHandler().getStyleElementForRead();
        if (style == null || style.getLocalName().equals("default-style")) {
            OdfStyle element = this.paragraphContainer.getStyleHandler().getStyleElementForWrite();
            NodeList nodes = element.getChildNodes();
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                element.removeChild(nodes.item(0));
            }
        }
        ParagraphProperties properties = this.paragraphContainer.getStyleHandler().getParagraphPropertiesForWrite();
        return properties;
    }

    private OdfStyleBase getParagraphStyleElementForWrite() {
        OdfStyleBase style = this.paragraphContainer.getStyleHandler().getStyleElementForRead();
        OdfStyle element = this.paragraphContainer.getStyleHandler().getStyleElementForWrite();
        if (style == null || style.getLocalName().equals("default-style")) {
            NodeList nodes = element.getChildNodes();
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                element.removeChild(nodes.item(0));
            }
        }
        return element;
    }

    private void handlePageBreak(Paragraph origParagraph, String pos, boolean continued) {
        String masterStyle;
        if (continued && this.textSelection.getTextNavigation().isHandlePageBreak()) {
            return;
        }
        ParagraphProperties orgParaPty = origParagraph.getStyleHandler().getParagraphPropertiesForRead();
        boolean handleBreak = false;
        String posInPara = "middle";
        if (continued && pos.equals("whole")) {
            posInPara = "end";
        } else if (continued && pos.endsWith("head")) {
            posInPara = "middle";
        } else if (continued && pos.endsWith("end")) {
            posInPara = "end";
        } else if (!continued && pos.endsWith("whole")) {
            posInPara = "whole";
        } else if (!continued && pos.endsWith("head")) {
            posInPara = "head";
        } else if (!continued && pos.endsWith("end")) {
            posInPara = "end";
        }
        if (orgParaPty != null) {
            String breakAttribute = orgParaPty.getBreakBefore();
            if (breakAttribute != null && (posInPara.equals("head") || posInPara.equals("whole"))) {
                this.getParagraphPropertiesForWrite().setBreak("before", breakAttribute);
                handleBreak = true;
            }
            if ((breakAttribute = orgParaPty.getBreakAfter()) != null && (posInPara.equals("end") || posInPara.equals("whole"))) {
                this.getParagraphPropertiesForWrite().setBreak("after", breakAttribute);
                handleBreak = true;
            }
        }
        if ((masterStyle = origParagraph.getStyleHandler().getStyleElementForRead().getOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "master-page-name"))) != null && !masterStyle.isEmpty() && (posInPara.equals("head") || posInPara.equals("whole"))) {
            this.getParagraphStyleElementForWrite().setOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.STYLE, "master-page-name"), masterStyle);
            handleBreak = true;
            try {
                int pageNumber = orgParaPty.getPageNumber();
                if (pos.equals("head")) {
                    this.paragraphContainer.getStyleHandler().getParagraphPropertiesForWrite().setPageNumber(pageNumber);
                }
            }
            catch (NumberFormatException e2) {
                Logger.getLogger(ParagraphSelection.class.getName()).log(Level.SEVERE, e2.getMessage(), "NumberFormatException");
            }
        }
        if (handleBreak && !posInPara.equals("whole")) {
            this.cleanBreakProperty(origParagraph);
        }
    }

    private void cleanBreakProperty(Paragraph paragraph) {
        TextNavigation search = this.textSelection.getTextNavigation();
        if (search == null) {
            throw new IllegalStateException("Navigation is null");
        }
        OdfStyleBase styleElement = paragraph.getStyleHandler().getStyleElementForRead();
        String name = styleElement.getAttribute("style:name");
        String newName = null;
        OdfElement modifiedStyleElement = search.getModifiedStyleElement(styleElement);
        if (modifiedStyleElement == null) {
            modifiedStyleElement = (OdfElement)styleElement.cloneNode(true);
            search.addModifiedStyleElement(styleElement, modifiedStyleElement);
            NodeList paragraphProperties = modifiedStyleElement.getElementsByTagName("style:paragraph-properties");
            if (paragraphProperties != null && paragraphProperties.getLength() > 0) {
                StyleParagraphPropertiesElement property = (StyleParagraphPropertiesElement)paragraphProperties.item(0);
                property.removeAttribute("fo:break-before");
                property.removeAttribute("fo:break-after");
                property.removeAttribute("style:page-number");
            }
            modifiedStyleElement.removeAttribute("style:master-page-name");
            newName = name + "-" + this.makeUniqueName();
            NamedNodeMap attributes = modifiedStyleElement.getAttributes();
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node item = attributes.item(i);
                    String value = item.getNodeValue();
                    if (!name.equals(value)) continue;
                    item.setNodeValue(newName);
                    break;
                }
            }
            styleElement.getParentNode().appendChild(modifiedStyleElement);
        } else {
            newName = modifiedStyleElement.getAttribute("style:name");
        }
        NamedNodeMap attributes = paragraph.getOdfElement().getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node item = attributes.item(i);
                String value = item.getNodeValue();
                if (!name.equals(value)) continue;
                item.setNodeValue(newName);
                break;
            }
        }
        this.textSelection.getTextNavigation().setHandlePageBreak(true);
    }

    String makeUniqueName() {
        return String.format("p%06x", (int)(Math.random() * 1.6777215E7));
    }

    private void prepareParagraphContainer(int leftLength, int index, boolean continued) {
        if (this.paragraphContainer == null) {
            String pos = "middle";
            OdfElement rightparentElement = this.textSelection.getContainerElement();
            int nodeLength = TextExtractor.getText(rightparentElement).length();
            if (index == 0) {
                if (leftLength == nodeLength) {
                    Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                    TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                    this.paragraphContainer = document.insertParagraph(orgparagraph, this.sourceParagraph, false);
                    NodeList cnl = rightparentElement.getChildNodes();
                    pos = "whole";
                    this.handlePageBreak(orgparagraph, pos, continued);
                    rightparentElement.getParentNode().removeChild(rightparentElement);
                } else {
                    this.delete(index, leftLength, rightparentElement);
                    Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                    TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                    this.paragraphContainer = document.insertParagraph(orgparagraph, this.sourceParagraph, true);
                    pos = "head";
                    this.handlePageBreak(orgparagraph, pos, continued);
                }
            } else if (nodeLength == index + leftLength) {
                this.delete(index, leftLength, rightparentElement);
                Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                this.paragraphContainer = document.insertParagraph(orgparagraph, this.sourceParagraph, false);
                this.handlePageBreak(orgparagraph, pos, continued);
            } else {
                this.delete(index, leftLength, rightparentElement);
                Node leftparentElement = rightparentElement.cloneNode(true);
                rightparentElement.getParentNode().insertBefore(leftparentElement, rightparentElement);
                nodeLength = TextExtractor.getText((OdfElement)leftparentElement).length();
                this.delete(index, nodeLength - index, leftparentElement);
                this.delete(0, index, rightparentElement);
                Paragraph orgparagraph = Paragraph.getInstanceof((TextParagraphElementBase)rightparentElement);
                TextDocument document = (TextDocument)orgparagraph.getOwnerDocument();
                this.paragraphContainer = document.insertParagraph(orgparagraph, this.sourceParagraph, true);
                if (!continued) {
                    this.cleanBreakProperty(orgparagraph);
                }
            }
        } else {
            TextDocument document = (TextDocument)this.paragraphContainer.getOwnerDocument();
            Paragraph tmp = document.insertParagraph(this.paragraphContainer, this.sourceParagraph, true);
            this.paragraphContainer.remove();
            this.paragraphContainer = tmp;
        }
    }
}

