/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.NodeFilter;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.rule.Pattern;
import org.jaxen.VariableContext;
import org.xml.sax.InputSource;

public final class DocumentHelper {
    private DocumentHelper() {
    }

    private static DocumentFactory getDocumentFactory() {
        return DocumentFactory.getInstance();
    }

    public static Document createDocument() {
        return DocumentHelper.getDocumentFactory().createDocument();
    }

    public static Document createDocument(Element rootElement) {
        return DocumentHelper.getDocumentFactory().createDocument(rootElement);
    }

    public static Element createElement(QName qname2) {
        return DocumentHelper.getDocumentFactory().createElement(qname2);
    }

    public static Element createElement(String name) {
        return DocumentHelper.getDocumentFactory().createElement(name);
    }

    public static Attribute createAttribute(Element owner, QName qname2, String value) {
        return DocumentHelper.getDocumentFactory().createAttribute(owner, qname2, value);
    }

    public static Attribute createAttribute(Element owner, String name, String value) {
        return DocumentHelper.getDocumentFactory().createAttribute(owner, name, value);
    }

    public static CDATA createCDATA(String text) {
        return DocumentFactory.getInstance().createCDATA(text);
    }

    public static Comment createComment(String text) {
        return DocumentFactory.getInstance().createComment(text);
    }

    public static Text createText(String text) {
        return DocumentFactory.getInstance().createText(text);
    }

    public static Entity createEntity(String name, String text) {
        return DocumentFactory.getInstance().createEntity(name, text);
    }

    public static Namespace createNamespace(String prefix, String uri) {
        return DocumentFactory.getInstance().createNamespace(prefix, uri);
    }

    public static ProcessingInstruction createProcessingInstruction(String pi2, String d) {
        return DocumentHelper.getDocumentFactory().createProcessingInstruction(pi2, d);
    }

    public static ProcessingInstruction createProcessingInstruction(String pi2, Map data) {
        return DocumentHelper.getDocumentFactory().createProcessingInstruction(pi2, data);
    }

    public static QName createQName(String localName, Namespace namespace2) {
        return DocumentHelper.getDocumentFactory().createQName(localName, namespace2);
    }

    public static QName createQName(String localName) {
        return DocumentHelper.getDocumentFactory().createQName(localName);
    }

    public static XPath createXPath(String xpathExpression) throws InvalidXPathException {
        return DocumentHelper.getDocumentFactory().createXPath(xpathExpression);
    }

    public static XPath createXPath(String xpathExpression, VariableContext context) throws InvalidXPathException {
        return DocumentHelper.getDocumentFactory().createXPath(xpathExpression, context);
    }

    public static NodeFilter createXPathFilter(String xpathFilterExpression) {
        return DocumentHelper.getDocumentFactory().createXPathFilter(xpathFilterExpression);
    }

    public static Pattern createPattern(String xpathPattern) {
        return DocumentHelper.getDocumentFactory().createPattern(xpathPattern);
    }

    public static List selectNodes(String xpathFilterExpression, List nodes) {
        XPath xpath2 = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath2.selectNodes(nodes);
    }

    public static List selectNodes(String xpathFilterExpression, Node node) {
        XPath xpath2 = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath2.selectNodes(node);
    }

    public static void sort(List list, String xpathExpression) {
        XPath xpath2 = DocumentHelper.createXPath(xpathExpression);
        xpath2.sort(list);
    }

    public static void sort(List list, String expression, boolean distinct) {
        XPath xpath2 = DocumentHelper.createXPath(expression);
        xpath2.sort(list, distinct);
    }

    public static Document parseText(String text) throws DocumentException {
        Document result = null;
        SAXReader reader = new SAXReader();
        String encoding = DocumentHelper.getEncoding(text);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(encoding);
        result = reader.read(source);
        if (result.getXMLEncoding() == null) {
            result.setXMLEncoding(encoding);
        }
        return result;
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens2 = new StringTokenizer(sub, " =\"'");
            while (tokens2.hasMoreTokens()) {
                String token = tokens2.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens2.hasMoreTokens()) break;
                result = tokens2.nextToken();
                break;
            }
        }
        return result;
    }

    public static Element makeElement(Branch source, String path) {
        String name;
        Element parent;
        StringTokenizer tokens2 = new StringTokenizer(path, "/");
        if (source instanceof Document) {
            Document document = (Document)source;
            parent = document.getRootElement();
            name = tokens2.nextToken();
            if (parent == null) {
                parent = document.addElement(name);
            }
        } else {
            parent = (Element)source;
        }
        Element element = null;
        while (tokens2.hasMoreTokens()) {
            name = tokens2.nextToken();
            element = name.indexOf(58) > 0 ? parent.element(parent.getQName(name)) : parent.element(name);
            if (element == null) {
                element = parent.addElement(name);
            }
            parent = element;
        }
        return element;
    }
}

