/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.AggregateFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;

public final class Irr
implements Function {
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length == 0 || args.length > 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double[] values = AggregateFunction.ValueCollector.collectValues(args[0]);
            double guess = args.length == 2 ? NumericFunction.singleOperandEvaluate(args[1], srcRowIndex, srcColumnIndex) : 0.1;
            double result = Irr.irr(values, guess);
            NumericFunction.checkValue(result);
            return new NumberEval(result);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
    }

    public static double irr(double[] income) {
        return Irr.irr(income, 0.1);
    }

    public static double irr(double[] values, double guess) {
        int maxIterationCount = 20;
        double absoluteAccuracy = 1.0E-7;
        double x0 = guess;
        for (int i = 0; i < maxIterationCount; ++i) {
            double fValue = 0.0;
            double fDerivative = 0.0;
            for (int k = 0; k < values.length; ++k) {
                fValue += values[k] / Math.pow(1.0 + x0, k);
                fDerivative += (double)(-k) * values[k] / Math.pow(1.0 + x0, k + 1);
            }
            double x1 = x0 - fValue / fDerivative;
            if (Math.abs(x1 - x0) <= absoluteAccuracy) {
                return x1;
            }
            x0 = x1;
        }
        return Double.NaN;
    }
}

