/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal.unmarshallers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.ZipPackage;
import org.apache.poi.openxml4j.opc.internal.PackagePropertiesPart;
import org.apache.poi.openxml4j.opc.internal.PartUnmarshaller;
import org.apache.poi.openxml4j.opc.internal.ZipHelper;
import org.apache.poi.openxml4j.opc.internal.unmarshallers.UnmarshallContext;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public final class PackagePropertiesUnmarshaller
implements PartUnmarshaller {
    private static final Namespace namespaceDC = new Namespace("dc", "http://purl.org/dc/elements/1.1/");
    private static final Namespace namespaceCP = new Namespace("cp", "http://schemas.openxmlformats.org/package/2006/metadata/core-properties");
    private static final Namespace namespaceDcTerms = new Namespace("dcterms", "http://purl.org/dc/terms/");
    private static final Namespace namespaceXML = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
    private static final Namespace namespaceXSI = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    protected static final String KEYWORD_CATEGORY = "category";
    protected static final String KEYWORD_CONTENT_STATUS = "contentStatus";
    protected static final String KEYWORD_CONTENT_TYPE = "contentType";
    protected static final String KEYWORD_CREATED = "created";
    protected static final String KEYWORD_CREATOR = "creator";
    protected static final String KEYWORD_DESCRIPTION = "description";
    protected static final String KEYWORD_IDENTIFIER = "identifier";
    protected static final String KEYWORD_KEYWORDS = "keywords";
    protected static final String KEYWORD_LANGUAGE = "language";
    protected static final String KEYWORD_LAST_MODIFIED_BY = "lastModifiedBy";
    protected static final String KEYWORD_LAST_PRINTED = "lastPrinted";
    protected static final String KEYWORD_MODIFIED = "modified";
    protected static final String KEYWORD_REVISION = "revision";
    protected static final String KEYWORD_SUBJECT = "subject";
    protected static final String KEYWORD_TITLE = "title";
    protected static final String KEYWORD_VERSION = "version";

    public PackagePart unmarshall(UnmarshallContext context, InputStream in) throws InvalidFormatException, IOException {
        Document xmlDoc;
        PackagePropertiesPart coreProps = new PackagePropertiesPart(context.getPackage(), context.getPartName());
        if (in == null) {
            if (context.getZipEntry() != null) {
                in = ((ZipPackage)context.getPackage()).getZipArchive().getInputStream(context.getZipEntry());
            } else if (context.getPackage() != null) {
                ZipEntry zipEntry = ZipHelper.getCorePropertiesZipEntry((ZipPackage)context.getPackage());
                in = ((ZipPackage)context.getPackage()).getZipArchive().getInputStream(zipEntry);
            } else {
                throw new IOException("Error while trying to get the part input stream.");
            }
        }
        SAXReader xmlReader = new SAXReader();
        try {
            xmlDoc = xmlReader.read(in);
            this.checkElementForOPCCompliance(xmlDoc.getRootElement());
        }
        catch (DocumentException e2) {
            throw new IOException(e2.getMessage());
        }
        coreProps.setCategoryProperty(this.loadCategory(xmlDoc));
        coreProps.setContentStatusProperty(this.loadContentStatus(xmlDoc));
        coreProps.setContentTypeProperty(this.loadContentType(xmlDoc));
        coreProps.setCreatedProperty(this.loadCreated(xmlDoc));
        coreProps.setCreatorProperty(this.loadCreator(xmlDoc));
        coreProps.setDescriptionProperty(this.loadDescription(xmlDoc));
        coreProps.setIdentifierProperty(this.loadIdentifier(xmlDoc));
        coreProps.setKeywordsProperty(this.loadKeywords(xmlDoc));
        coreProps.setLanguageProperty(this.loadLanguage(xmlDoc));
        coreProps.setLastModifiedByProperty(this.loadLastModifiedBy(xmlDoc));
        coreProps.setLastPrintedProperty(this.loadLastPrinted(xmlDoc));
        coreProps.setModifiedProperty(this.loadModified(xmlDoc));
        coreProps.setRevisionProperty(this.loadRevision(xmlDoc));
        coreProps.setSubjectProperty(this.loadSubject(xmlDoc));
        coreProps.setTitleProperty(this.loadTitle(xmlDoc));
        coreProps.setVersionProperty(this.loadVersion(xmlDoc));
        return coreProps;
    }

    private String loadCategory(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_CATEGORY, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadContentStatus(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_CONTENT_STATUS, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadContentType(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_CONTENT_TYPE, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadCreated(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_CREATED, namespaceDcTerms));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadCreator(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_CREATOR, namespaceDC));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadDescription(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_DESCRIPTION, namespaceDC));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadIdentifier(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_IDENTIFIER, namespaceDC));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadKeywords(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_KEYWORDS, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadLanguage(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_LANGUAGE, namespaceDC));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadLastModifiedBy(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_LAST_MODIFIED_BY, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadLastPrinted(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_LAST_PRINTED, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadModified(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_MODIFIED, namespaceDcTerms));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadRevision(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_REVISION, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadSubject(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_SUBJECT, namespaceDC));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadTitle(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_TITLE, namespaceDC));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    private String loadVersion(Document xmlDoc) {
        Element el = xmlDoc.getRootElement().element(new QName(KEYWORD_VERSION, namespaceCP));
        if (el == null) {
            return null;
        }
        return el.getStringValue();
    }

    public void checkElementForOPCCompliance(Element el) throws InvalidFormatException {
        List declaredNamespaces = el.declaredNamespaces();
        for (Namespace ns : declaredNamespaces) {
            if (!ns.getURI().equals("http://schemas.openxmlformats.org/markup-compatibility/2006")) continue;
            throw new InvalidFormatException("OPC Compliance error [M4.2]: A format consumer shall consider the use of the Markup Compatibility namespace to be an error.");
        }
        if (el.getNamespace().getURI().equals("http://purl.org/dc/terms/") && !el.getName().equals(KEYWORD_CREATED) && !el.getName().equals(KEYWORD_MODIFIED)) {
            throw new InvalidFormatException("OPC Compliance error [M4.3]: Producers shall not create a document element that contains refinements to the Dublin Core elements, except for the two specified in the schema: <dcterms:created> and <dcterms:modified> Consumers shall consider a document element that violates this constraint to be an error.");
        }
        if (el.attribute(new QName("lang", namespaceXML)) != null) {
            throw new InvalidFormatException("OPC Compliance error [M4.4]: Producers shall not create a document element that contains the xml:lang attribute. Consumers shall consider a document element that violates this constraint to be an error.");
        }
        if (el.getNamespace().getURI().equals("http://purl.org/dc/terms/")) {
            String elName = el.getName();
            if (!elName.equals(KEYWORD_CREATED) && !elName.equals(KEYWORD_MODIFIED)) {
                throw new InvalidFormatException("Namespace error : " + elName + " shouldn't have the following naemspace -> " + "http://purl.org/dc/terms/");
            }
            Attribute typeAtt = el.attribute(new QName("type", namespaceXSI));
            if (typeAtt == null) {
                throw new InvalidFormatException("The element '" + elName + "' must have the '" + namespaceXSI.getPrefix() + ":type' attribute present !");
            }
            if (!typeAtt.getValue().equals("dcterms:W3CDTF")) {
                throw new InvalidFormatException("The element '" + elName + "' must have the '" + namespaceXSI.getPrefix() + ":type' attribute with the value 'dcterms:W3CDTF' !");
            }
        }
        Iterator itChildren = el.elementIterator();
        while (itChildren.hasNext()) {
            this.checkElementForOPCCompliance((Element)itChildren.next());
        }
    }
}

