/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.view.SVRowHeader;
import org.apache.poi.hssf.view.SVTableModel;
import org.apache.poi.hssf.view.brush.PendingPaintings;

public class SVSheetTable
extends JTable {
    private final HSSFSheet sheet;
    private final PendingPaintings pendingPaintings;
    private FormulaDisplayListener formulaListener;
    private JScrollPane scroll;
    private static final Color HEADER_BACKGROUND = new Color(235, 235, 235);
    private static final int magicCharFactor = 7;

    public SVSheetTable(HSSFSheet sheet) {
        super(new SVTableModel(sheet));
        this.sheet = sheet;
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoResizeMode(0);
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new HeaderCellRenderer());
        this.pendingPaintings = new PendingPaintings(this);
        TableColumnModel columns = this.getColumnModel();
        for (int i = 0; i < columns.getColumnCount(); ++i) {
            TableColumn column = columns.getColumn(i);
            int width = sheet.getColumnWidth(i);
            column.setPreferredWidth(width / 256 * 7);
        }
        Toolkit t = this.getToolkit();
        int res = t.getScreenResolution();
        TableModel model = this.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            HSSFRow row = sheet.getRow(i - sheet.getFirstRowNum());
            if (row == null) continue;
            short h = row.getHeight();
            int height = Math.round(Math.max(1, h / (res / 70 * 20) + 3));
            System.out.printf("%d: %d (%d @ %d)%n", i, height, h, res);
            this.setRowHeight(i, height);
        }
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e2) {
                Container grandparent;
                Container changedParent;
                if ((e2.getChangeFlags() & 1L) != 0L && (changedParent = e2.getChangedParent()) instanceof JViewport && (grandparent = changedParent.getParent()) instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)grandparent;
                    SVSheetTable.this.setupScroll(jScrollPane);
                }
            }
        });
    }

    public void setupScroll(JScrollPane scroll) {
        if (scroll == this.scroll) {
            return;
        }
        this.scroll = scroll;
        if (scroll == null) {
            return;
        }
        SVRowHeader rowHeader = new SVRowHeader(this.sheet, this, 0);
        scroll.setRowHeaderView(rowHeader);
        scroll.setCorner("UPPER_LEADING_CORNER", this.headerCell("?"));
    }

    public void setFormulaDisplay(JTextComponent formulaDisplay) {
        ListSelectionModel rowSelMod = this.getSelectionModel();
        ListSelectionModel colSelMod = this.getColumnModel().getSelectionModel();
        if (formulaDisplay == null) {
            rowSelMod.removeListSelectionListener(this.formulaListener);
            colSelMod.removeListSelectionListener(this.formulaListener);
            this.formulaListener = null;
        }
        if (formulaDisplay != null) {
            this.formulaListener = new FormulaDisplayListener(formulaDisplay);
            rowSelMod.addListSelectionListener(this.formulaListener);
            colSelMod.addListSelectionListener(this.formulaListener);
        }
    }

    public JTextComponent getFormulaDisplay() {
        if (this.formulaListener == null) {
            return null;
        }
        return this.formulaListener.formulaDisplay;
    }

    public Component headerCell(String text) {
        return new HeaderCell(text, -1);
    }

    public void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        this.pendingPaintings.clear();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        this.pendingPaintings.paint(g);
    }

    private class FormulaDisplayListener
    implements ListSelectionListener {
        private final JTextComponent formulaDisplay;

        public FormulaDisplayListener(JTextComponent formulaDisplay) {
            this.formulaDisplay = formulaDisplay;
        }

        public void valueChanged(ListSelectionEvent e2) {
            int row = SVSheetTable.this.getSelectedRow();
            int col = SVSheetTable.this.getSelectedColumn();
            if (row < 0 || col < 0) {
                return;
            }
            if (e2.getValueIsAdjusting()) {
                return;
            }
            HSSFCell cell = (HSSFCell)SVSheetTable.this.getValueAt(row, col);
            String formula = "";
            if (cell != null && (formula = cell.getCellType() == 2 ? cell.getCellFormula() : cell.toString()) == null) {
                formula = "";
            }
            this.formulaDisplay.setText(formula);
        }
    }

    private class HeaderCellRenderer
    implements TableCellRenderer {
        private HeaderCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new HeaderCell(value, row);
        }
    }

    private class HeaderCell
    extends JLabel {
        private final int row;

        public HeaderCell(Object value, int row) {
            super(value.toString(), 0);
            this.row = row;
            this.setBackground(HEADER_BACKGROUND);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
            SVSheetTable.this.setRowSelectionAllowed(false);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (this.row >= 0) {
                d.height = SVSheetTable.this.getRowHeight(this.row);
            }
            return d;
        }

        public Dimension getMaximumSize() {
            Dimension d = super.getMaximumSize();
            if (this.row >= 0) {
                d.height = SVSheetTable.this.getRowHeight(this.row);
            }
            return d;
        }

        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            if (this.row >= 0) {
                d.height = SVSheetTable.this.getRowHeight(this.row);
            }
            return d;
        }
    }
}

