/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.List;
import java.util.Map;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.usermodel.HSSFCombobox;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPolygon;
import org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import org.apache.poi.hssf.usermodel.HSSFTextbox;
import org.apache.poi.poifs.filesystem.DirectoryNode;

public class HSSFShapeFactory {
    private static final short OBJECT_TYPE_LINE = 1;
    private static final short OBJECT_TYPE_RECTANGLE = 2;
    private static final short OBJECT_TYPE_OVAL = 3;
    private static final short OBJECT_TYPE_ARC = 4;
    private static final short OBJECT_TYPE_PICTURE = 8;

    public static void createShapeTree(EscherContainerRecord container2, EscherAggregate agg, HSSFShapeContainer out, DirectoryNode root) {
        if (container2.getRecordId() == -4093) {
            ObjRecord obj = null;
            EscherClientDataRecord clientData = (EscherClientDataRecord)((EscherContainerRecord)container2.getChild(0)).getChildById((short)-4079);
            if (null != clientData) {
                obj = (ObjRecord)agg.getShapeToObjMapping().get(clientData);
            }
            HSSFShapeGroup group2 = new HSSFShapeGroup(container2, obj);
            List<EscherContainerRecord> children = container2.getChildContainers();
            for (int i = 0; i < children.size(); ++i) {
                EscherContainerRecord spContainer = children.get(i);
                if (i == 0) continue;
                HSSFShapeFactory.createShapeTree(spContainer, agg, group2, root);
            }
            out.addShape(group2);
        } else if (container2.getRecordId() == -4092) {
            HSSFSimpleShape shape;
            Map<EscherRecord, Record> shapeToObj = agg.getShapeToObjMapping();
            ObjRecord objRecord = null;
            TextObjectRecord txtRecord = null;
            for (EscherRecord record : container2.getChildRecords()) {
                switch (record.getRecordId()) {
                    case -4079: {
                        objRecord = (ObjRecord)shapeToObj.get(record);
                        break;
                    }
                    case -4083: {
                        txtRecord = (TextObjectRecord)shapeToObj.get(record);
                    }
                }
            }
            if (HSSFShapeFactory.isEmbeddedObject(objRecord)) {
                HSSFObjectData objectData = new HSSFObjectData(container2, objRecord, root);
                out.addShape(objectData);
                return;
            }
            CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)objRecord.getSubRecords().get(0);
            switch (cmo.getObjectType()) {
                case 8: {
                    shape = new HSSFPicture(container2, objRecord);
                    break;
                }
                case 2: {
                    shape = new HSSFSimpleShape(container2, objRecord, txtRecord);
                    break;
                }
                case 1: {
                    shape = new HSSFSimpleShape(container2, objRecord);
                    break;
                }
                case 20: {
                    shape = new HSSFCombobox(container2, objRecord);
                    break;
                }
                case 30: {
                    EscherOptRecord optRecord = (EscherOptRecord)container2.getChildById((short)-4085);
                    Object property = optRecord.lookup(325);
                    if (null != property) {
                        shape = new HSSFPolygon(container2, objRecord, txtRecord);
                        break;
                    }
                    shape = new HSSFSimpleShape(container2, objRecord, txtRecord);
                    break;
                }
                case 6: {
                    shape = new HSSFTextbox(container2, objRecord, txtRecord);
                    break;
                }
                case 25: {
                    shape = new HSSFComment(container2, objRecord, txtRecord, agg.getNoteRecordByObj(objRecord));
                    break;
                }
                default: {
                    shape = new HSSFSimpleShape(container2, objRecord, txtRecord);
                }
            }
            out.addShape(shape);
        }
    }

    private static boolean isEmbeddedObject(ObjRecord obj) {
        for (SubRecord sub : obj.getSubRecords()) {
            if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
            return true;
        }
        return false;
    }
}

