/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;

public class RDFReaderRIOT
implements RDFReader {
    private final String basename;
    protected final Lang hintlang;
    protected Context context = new Context();
    protected RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFReaderRIOT() {
        this((Lang)null);
    }

    public RDFReaderRIOT(String lang) {
        this(RDFLanguages.nameToLang(lang));
    }

    public RDFReaderRIOT(Lang hintlang) {
        this.hintlang = hintlang;
        this.basename = hintlang == null ? "org.apache.jena.riot.reader.generic" : "org.apache.jena.riot.reader." + hintlang.getLabel().toLowerCase(Locale.ROOT);
    }

    @Override
    public void read(Model model, Reader r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public void read(Model model, InputStream r, String base) {
        this.startRead(model);
        RDFDataMgr.read(model, r, base, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public void read(Model model, String url) {
        this.startRead(model);
        RDFDataMgr.read(model, url, this.hintlang);
        this.finishRead(model);
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        Symbol sym2 = Symbol.create(this.basename + propName);
        Object oldObj = this.context.get(sym2);
        return oldObj;
    }

    protected void startRead(Model model) {
        model.notifyEvent(GraphEvents.startRead);
    }

    protected void finishRead(Model model) {
        model.notifyEvent(GraphEvents.finishRead);
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

