/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;

public class RtfTable
extends RtfContainer {
    private RtfTableRow row;
    private int highestRow;
    private Boolean isNestedTable;
    private RtfAttributes borderAttributes;
    private ITableColumnsInfo tableContext;
    private int nestedTableDepth;
    private RtfAttributes headerAttribs;

    RtfTable(IRtfTableContainer parent, Writer w, ITableColumnsInfo tc) throws IOException {
        super((RtfContainer)((Object)parent), w);
        this.tableContext = tc;
    }

    RtfTable(IRtfTableContainer parent, Writer w, RtfAttributes attrs, ITableColumnsInfo tc) throws IOException {
        super((RtfContainer)((Object)parent), w, attrs);
        this.tableContext = tc;
    }

    public RtfTableRow newTableRow() throws IOException {
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, this.attrib, this.highestRow);
        return this.row;
    }

    public RtfTableRow newTableRow(RtfAttributes attrs) throws IOException, FOPException {
        RtfAttributes attr = null;
        if (this.attrib != null) {
            try {
                attr = (RtfAttributes)this.attrib.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new FOPException(e2);
            }
            attr.set(attrs);
        } else {
            attr = attrs;
        }
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, attr, this.highestRow);
        return this.row;
    }

    @Override
    protected void writeRtfPrefix() throws IOException {
        if (this.isNestedTable()) {
            this.writeControlWordNS("pard");
        }
        this.writeGroupMark(true);
    }

    @Override
    protected void writeRtfSuffix() throws IOException {
        this.writeGroupMark(false);
        if (this.isNestedTable()) {
            this.getRow().writeRowAndCellsDefintions();
        }
    }

    public boolean isHighestRow(int id) {
        return this.highestRow == id;
    }

    public ITableColumnsInfo getITableColumnsInfo() {
        return this.tableContext;
    }

    public void setHeaderAttribs(RtfAttributes attrs) {
        this.headerAttribs = attrs;
    }

    public RtfAttributes getHeaderAttribs() {
        return this.headerAttribs;
    }

    @Override
    public RtfAttributes getRtfAttributes() {
        if (this.headerAttribs != null) {
            return this.headerAttribs;
        }
        return super.getRtfAttributes();
    }

    public boolean isNestedTable() {
        if (this.isNestedTable == null) {
            RtfContainer e2 = this;
            while (e2.parent != null) {
                if (e2.parent instanceof RtfTableCell) {
                    this.isNestedTable = Boolean.TRUE;
                    return true;
                }
                e2 = e2.parent;
            }
        } else {
            return this.isNestedTable;
        }
        this.isNestedTable = Boolean.FALSE;
        return false;
    }

    public RtfTableRow getRow() {
        RtfContainer e2 = this;
        while (e2.parent != null) {
            if (e2.parent instanceof RtfTableRow) {
                return (RtfTableRow)e2.parent;
            }
            e2 = e2.parent;
        }
        return null;
    }

    public void setNestedTableDepth(int nestedTableDepth) {
        this.nestedTableDepth = nestedTableDepth;
    }

    public int getNestedTableDepth() {
        return this.nestedTableDepth;
    }

    public void setBorderAttributes(RtfAttributes attributes) {
        this.borderAttributes = attributes;
    }

    public RtfAttributes getBorderAttributes() {
        return this.borderAttributes;
    }
}

