/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;

public class RtfBookmark
extends RtfElement {
    private String bookmark;
    public static final int MAX_BOOKMARK_LENGTH = 40;
    public static final char REPLACE_CHARACTER = '_';

    RtfBookmark(RtfContainer parent, Writer writer, String bookmark) throws IOException {
        super(parent, writer);
        int now2 = bookmark.length();
        this.bookmark = bookmark.substring(0, now2 < 40 ? now2 : 40);
        this.bookmark = this.bookmark.replace('.', '_');
        this.bookmark = this.bookmark.replace(' ', '_');
    }

    @Override
    public void writeRtfPrefix() throws IOException {
        this.startBookmark();
    }

    @Override
    public void writeRtfContent() throws IOException {
    }

    @Override
    public void writeRtfSuffix() throws IOException {
        this.endBookmark();
    }

    private void startBookmark() throws IOException {
        this.writeRtfBookmark("bkmkstart");
    }

    private void endBookmark() throws IOException {
        this.writeRtfBookmark("bkmkend");
    }

    private void writeRtfBookmark(String tag) throws IOException {
        if (this.bookmark == null) {
            return;
        }
        this.writeGroupMark(true);
        this.writeStarControlWord(tag);
        this.writer.write(this.bookmark);
        this.writeGroupMark(false);
    }

    @Override
    public boolean isEmpty() {
        return this.bookmark == null || this.bookmark.trim().length() == 0;
    }
}

