/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.print;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.print.PageableRenderer;

public class PrintRenderer
extends PageableRenderer {
    public static final String PRINTER_JOB = "printerjob";
    public static final String COPIES = "copies";
    private int copies = 1;
    private PrinterJob printerJob;

    public PrintRenderer(FOUserAgent userAgent) {
        super(userAgent);
        this.setRendererOptions();
    }

    private void initializePrinterJob() {
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
            this.printerJob.setJobName("FOP Document");
            this.printerJob.setCopies(this.copies);
            if (System.getProperty("dialog") != null && !this.printerJob.printDialog()) {
                throw new RuntimeException("Printing cancelled by operator");
            }
            this.printerJob.setPageable(this);
        }
    }

    private void setRendererOptions() {
        Object o;
        Map rendererOptions = this.getUserAgent().getRendererOptions();
        Object printerJobO = rendererOptions.get(PRINTER_JOB);
        if (printerJobO != null) {
            if (!(printerJobO instanceof PrinterJob)) {
                throw new IllegalArgumentException("Renderer option printerjob must be an instance of java.awt.print.PrinterJob, but an instance of " + printerJobO.getClass().getName() + " was given.");
            }
            this.printerJob = (PrinterJob)printerJobO;
            this.printerJob.setPageable(this);
        }
        if ((o = rendererOptions.get(COPIES)) != null) {
            this.copies = this.getPositiveInteger(o);
        }
        this.initializePrinterJob();
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public int getEndNumber() {
        return this.endNumber;
    }

    public void setEndPage(int end) {
        this.endNumber = end;
    }

    public int getStartPage() {
        return this.startNumber;
    }

    public void setStartPage(int start) {
        this.startNumber = start;
    }

    @Override
    public void stopRenderer() throws IOException {
        super.stopRenderer();
        try {
            this.printerJob.print();
        }
        catch (PrinterException e2) {
            log.error(e2);
            throw new IOException("Unable to print: " + e2.getClass().getName() + ": " + e2.getMessage());
        }
        this.clearViewportList();
    }
}

