/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.util.EnumMap;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.fonts.DefaultFontConfig;
import org.apache.fop.fonts.FontEventAdapter;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.pcl.Java2DRendererOption;
import org.apache.fop.render.pcl.PCLRenderingMode;

public final class PCLRendererConfig
implements RendererConfig {
    private final Map<Java2DRendererOption, Object> params = new EnumMap<Java2DRendererOption, Object>(Java2DRendererOption.class);
    private final DefaultFontConfig fontConfig;

    private PCLRendererConfig(DefaultFontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    @Override
    public DefaultFontConfig getFontInfoConfig() {
        return this.fontConfig;
    }

    public PCLRenderingMode getRenderingMode() {
        return this.getParam(Java2DRendererOption.RENDERING_MODE, PCLRenderingMode.class);
    }

    public Boolean isTextRendering() {
        return this.getParam(Java2DRendererOption.TEXT_RENDERING, Boolean.class);
    }

    public Boolean isDisablePjl() {
        return this.getParam(Java2DRendererOption.DISABLE_PJL, Boolean.class);
    }

    public Boolean isColorEnabled() {
        return this.getParam(Java2DRendererOption.MODE_COLOR, Boolean.class);
    }

    public Boolean isOptimizeResources() {
        return this.getParam(Java2DRendererOption.OPTIMIZE_RESOURCES, Boolean.class);
    }

    private <T> T getParam(Java2DRendererOption option, Class<T> type) {
        assert (option.getType().equals(type));
        return type.cast(this.params.get(option));
    }

    private <T> void setParam(Java2DRendererOption option, T value) {
        assert (option.getType().isInstance(value));
        this.params.put(option, value);
    }

    public static final class PCLRendererConfigParser
    implements RendererConfig.RendererConfigParser {
        @Override
        public PCLRendererConfig build(FOUserAgent userAgent, Configuration cfg) throws FOPException {
            PCLRendererConfig config = new PCLRendererConfig(new DefaultFontConfig.DefaultFontConfigParser().parse(cfg, userAgent.validateStrictly(), new FontEventAdapter(userAgent.getEventBroadcaster())));
            this.configure(cfg, config);
            return config;
        }

        private void configure(Configuration cfg, PCLRendererConfig config) throws FOPException {
            if (cfg != null) {
                String textRendering;
                String rendering;
                Configuration imagesCfg = cfg.getChild("images");
                String imageMode = imagesCfg.getAttribute("mode", null);
                if ("color".equalsIgnoreCase(imageMode)) {
                    config.setParam(Java2DRendererOption.MODE_COLOR, true);
                }
                if ((rendering = cfg.getChild(Java2DRendererOption.RENDERING_MODE.getName()).getValue(null)) != null) {
                    try {
                        config.setParam(Java2DRendererOption.RENDERING_MODE, (Object)PCLRenderingMode.getValueOf(rendering));
                    }
                    catch (IllegalArgumentException e2) {
                        throw new FOPException("Valid values for 'rendering' are 'quality', 'speed' and 'bitmap'. Value found: " + rendering);
                    }
                }
                if ("bitmap".equalsIgnoreCase(textRendering = cfg.getChild(Java2DRendererOption.TEXT_RENDERING.getName()).getValue(null))) {
                    config.setParam(Java2DRendererOption.TEXT_RENDERING, true);
                } else if (textRendering == null || "auto".equalsIgnoreCase(textRendering)) {
                    config.setParam(Java2DRendererOption.TEXT_RENDERING, false);
                } else {
                    throw new FOPException("Valid values for 'text-rendering' are 'auto' and 'bitmap'. Value found: " + textRendering);
                }
                config.setParam(Java2DRendererOption.DISABLE_PJL, cfg.getChild(Java2DRendererOption.DISABLE_PJL.getName()).getValueAsBoolean(false));
                config.setParam(Java2DRendererOption.OPTIMIZE_RESOURCES, cfg.getChild(Java2DRendererOption.OPTIMIZE_RESOURCES.getName()).getValueAsBoolean(false));
            }
        }

        @Override
        public String getMimeType() {
            return "application/x-pcl";
        }
    }
}

