/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.pdf.PDFObject;

public class PDFGState
extends PDFObject {
    public static final String GSTATE_LINE_WIDTH = "LW";
    public static final String GSTATE_LINE_CAP = "LC";
    public static final String GSTATE_LINE_JOIN = "LJ";
    public static final String GSTATE_MITER_LIMIT = "ML";
    public static final String GSTATE_DASH_PATTERN = "D";
    public static final String GSTATE_RENDERING_INTENT = "RI";
    public static final String GSTATE_OVERPRINT_STROKE = "OP";
    public static final String GSTATE_OVERPRINT_FILL = "op";
    public static final String GSTATE_OVERPRINT_MODE = "OPM";
    public static final String GSTATE_FONT = "Font";
    public static final String GSTATE_BLACK_GENERATION = "BG";
    public static final String GSTATE_BLACK_GENERATION2 = "BG2";
    public static final String GSTATE_UNDERCOLOR_REMOVAL = "UCR";
    public static final String GSTATE_UNDERCOLOR_REMOVAL2 = "UCR2";
    public static final String GSTATE_TRANSFER_FUNCTION = "TR";
    public static final String GSTATE_TRANSFER_FUNCTION2 = "TR2";
    public static final String GSTATE_HALFTONE_DICT = "HT";
    public static final String GSTATE_HALFTONE_PHASE = "HTP";
    public static final String GSTATE_FLATNESS = "FL";
    public static final String GSTATE_SMOOTHNESS = "SM";
    public static final String GSTATE_STRIKE_ADJ = "SA";
    public static final String GSTATE_BLEND_MODE = "BM";
    public static final String GSTATE_SOFT_MASK = "SMask";
    public static final String GSTATE_ALPHA_STROKE = "CA";
    public static final String GSTATE_ALPHA_NONSTROKE = "ca";
    public static final String GSTATE_ALPHA_SOURCE_FLAG = "AIS";
    public static final String GSTATE_TEXT_KNOCKOUT = "TK";
    public static final PDFGState DEFAULT = new PDFGState();
    private Map values = new HashMap();
    private int objNum;

    public String getName() {
        if (this.objNum == 0) {
            this.objNum = ++this.getDocument().gStateObjectCount;
        }
        return "GS" + this.objNum;
    }

    public void setAlpha(float val, boolean fill) {
        if (fill) {
            this.values.put(GSTATE_ALPHA_NONSTROKE, Float.valueOf(val));
        } else {
            this.values.put(GSTATE_ALPHA_STROKE, Float.valueOf(val));
        }
    }

    public void addValues(PDFGState state) {
        this.values.putAll(state.values);
    }

    public void addValues(Map vals) {
        this.values.putAll(vals);
    }

    @Override
    public String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("<<\n/Type /ExtGState\n");
        this.appendVal(sb, GSTATE_ALPHA_NONSTROKE);
        this.appendVal(sb, GSTATE_ALPHA_STROKE);
        sb.append(">>");
        return sb.toString();
    }

    private void appendVal(StringBuffer sb, String name) {
        Object val = this.values.get(name);
        if (val != null) {
            sb.append("/" + name + " " + val + "\n");
        }
    }

    @Override
    protected boolean contentEquals(PDFObject obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PDFGState)) {
            return false;
        }
        Map vals1 = this.values;
        Map vals2 = ((PDFGState)obj).values;
        if (vals1.size() != vals2.size()) {
            return false;
        }
        for (Map.Entry e2 : vals2.entrySet()) {
            Object str2 = e2.getKey();
            Object obj1 = vals1.get(str2);
            if (obj1.equals(e2.getValue())) continue;
            return false;
        }
        return true;
    }

    static {
        Map vals = PDFGState.DEFAULT.values;
        vals.put(GSTATE_ALPHA_STROKE, Float.valueOf(1.0f));
        vals.put(GSTATE_ALPHA_NONSTROKE, Float.valueOf(1.0f));
    }
}

