/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class CourierBoldOblique
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Courier-BoldOblique";
    private static final String fullName = "Courier Bold Oblique";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 562;
    private static final int xHeight = 439;
    private static final int ascender = 626;
    private static final int descender = -142;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private boolean enableKerning;

    public CourierBoldOblique() {
        this(false);
    }

    public CourierBoldOblique(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    @Override
    public String getEncodingName() {
        return encoding;
    }

    @Override
    public URI getFontURI() {
        return fontFileURI;
    }

    @Override
    public String getFontName() {
        return fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    @Override
    public FontType getFontType() {
        return FontType.TYPE1;
    }

    @Override
    public int getAscender(int size) {
        return size * 626;
    }

    @Override
    public int getCapHeight(int size) {
        return size * 562;
    }

    @Override
    public int getDescender(int size) {
        return size * -142;
    }

    @Override
    public int getXHeight(int size) {
        return size * 439;
    }

    @Override
    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    @Override
    public int getWidth(int i, int size) {
        return size * width[i];
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    @Override
    public boolean hasKerningInfo() {
        return false;
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    @Override
    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        CourierBoldOblique.width[65] = 600;
        CourierBoldOblique.boundingBoxes[65] = new Rectangle(-9, 0, 641, 562);
        CourierBoldOblique.width[198] = 600;
        CourierBoldOblique.boundingBoxes[198] = new Rectangle(-29, 0, 737, 562);
        CourierBoldOblique.width[193] = 600;
        CourierBoldOblique.boundingBoxes[193] = new Rectangle(-9, 0, 664, 784);
        CourierBoldOblique.width[194] = 600;
        CourierBoldOblique.boundingBoxes[194] = new Rectangle(-9, 0, 641, 780);
        CourierBoldOblique.width[196] = 600;
        CourierBoldOblique.boundingBoxes[196] = new Rectangle(-9, 0, 641, 761);
        CourierBoldOblique.width[192] = 600;
        CourierBoldOblique.boundingBoxes[192] = new Rectangle(-9, 0, 641, 784);
        CourierBoldOblique.width[197] = 600;
        CourierBoldOblique.boundingBoxes[197] = new Rectangle(-9, 0, 641, 801);
        CourierBoldOblique.width[195] = 600;
        CourierBoldOblique.boundingBoxes[195] = new Rectangle(-9, 0, 678, 759);
        CourierBoldOblique.width[66] = 600;
        CourierBoldOblique.boundingBoxes[66] = new Rectangle(30, 0, 600, 562);
        CourierBoldOblique.width[67] = 600;
        CourierBoldOblique.boundingBoxes[67] = new Rectangle(74, -18, 601, 598);
        CourierBoldOblique.width[199] = 600;
        CourierBoldOblique.boundingBoxes[199] = new Rectangle(74, -206, 601, 786);
        CourierBoldOblique.width[68] = 600;
        CourierBoldOblique.boundingBoxes[68] = new Rectangle(30, 0, 634, 562);
        CourierBoldOblique.width[69] = 600;
        CourierBoldOblique.boundingBoxes[69] = new Rectangle(25, 0, 645, 562);
        CourierBoldOblique.width[201] = 600;
        CourierBoldOblique.boundingBoxes[201] = new Rectangle(25, 0, 645, 784);
        CourierBoldOblique.width[202] = 600;
        CourierBoldOblique.boundingBoxes[202] = new Rectangle(25, 0, 645, 780);
        CourierBoldOblique.width[203] = 600;
        CourierBoldOblique.boundingBoxes[203] = new Rectangle(25, 0, 645, 761);
        CourierBoldOblique.width[200] = 600;
        CourierBoldOblique.boundingBoxes[200] = new Rectangle(25, 0, 645, 784);
        CourierBoldOblique.width[208] = 600;
        CourierBoldOblique.boundingBoxes[208] = new Rectangle(30, 0, 634, 562);
        CourierBoldOblique.width[128] = 600;
        CourierBoldOblique.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        CourierBoldOblique.width[70] = 600;
        CourierBoldOblique.boundingBoxes[70] = new Rectangle(39, 0, 645, 562);
        CourierBoldOblique.width[71] = 600;
        CourierBoldOblique.boundingBoxes[71] = new Rectangle(74, -18, 601, 598);
        CourierBoldOblique.width[72] = 600;
        CourierBoldOblique.boundingBoxes[72] = new Rectangle(20, 0, 680, 562);
        CourierBoldOblique.width[73] = 600;
        CourierBoldOblique.boundingBoxes[73] = new Rectangle(77, 0, 566, 562);
        CourierBoldOblique.width[205] = 600;
        CourierBoldOblique.boundingBoxes[205] = new Rectangle(77, 0, 566, 784);
        CourierBoldOblique.width[206] = 600;
        CourierBoldOblique.boundingBoxes[206] = new Rectangle(77, 0, 566, 780);
        CourierBoldOblique.width[207] = 600;
        CourierBoldOblique.boundingBoxes[207] = new Rectangle(77, 0, 566, 761);
        CourierBoldOblique.width[204] = 600;
        CourierBoldOblique.boundingBoxes[204] = new Rectangle(77, 0, 566, 784);
        CourierBoldOblique.width[74] = 600;
        CourierBoldOblique.boundingBoxes[74] = new Rectangle(58, -18, 663, 580);
        CourierBoldOblique.width[75] = 600;
        CourierBoldOblique.boundingBoxes[75] = new Rectangle(21, 0, 671, 562);
        CourierBoldOblique.width[76] = 600;
        CourierBoldOblique.boundingBoxes[76] = new Rectangle(39, 0, 597, 562);
        CourierBoldOblique.width[77] = 600;
        CourierBoldOblique.boundingBoxes[77] = new Rectangle(-2, 0, 724, 562);
        CourierBoldOblique.width[78] = 600;
        CourierBoldOblique.boundingBoxes[78] = new Rectangle(8, -12, 722, 574);
        CourierBoldOblique.width[209] = 600;
        CourierBoldOblique.boundingBoxes[209] = new Rectangle(8, -12, 722, 771);
        CourierBoldOblique.width[79] = 600;
        CourierBoldOblique.boundingBoxes[79] = new Rectangle(74, -18, 571, 598);
        CourierBoldOblique.width[140] = 600;
        CourierBoldOblique.boundingBoxes[140] = new Rectangle(26, 0, 675, 562);
        CourierBoldOblique.width[211] = 600;
        CourierBoldOblique.boundingBoxes[211] = new Rectangle(74, -18, 571, 802);
        CourierBoldOblique.width[212] = 600;
        CourierBoldOblique.boundingBoxes[212] = new Rectangle(74, -18, 571, 798);
        CourierBoldOblique.width[214] = 600;
        CourierBoldOblique.boundingBoxes[214] = new Rectangle(74, -18, 571, 779);
        CourierBoldOblique.width[210] = 600;
        CourierBoldOblique.boundingBoxes[210] = new Rectangle(74, -18, 571, 802);
        CourierBoldOblique.width[216] = 600;
        CourierBoldOblique.boundingBoxes[216] = new Rectangle(48, -22, 625, 606);
        CourierBoldOblique.width[213] = 600;
        CourierBoldOblique.boundingBoxes[213] = new Rectangle(74, -18, 595, 777);
        CourierBoldOblique.width[80] = 600;
        CourierBoldOblique.boundingBoxes[80] = new Rectangle(48, 0, 595, 562);
        CourierBoldOblique.width[81] = 600;
        CourierBoldOblique.boundingBoxes[81] = new Rectangle(83, -138, 553, 718);
        CourierBoldOblique.width[82] = 600;
        CourierBoldOblique.boundingBoxes[82] = new Rectangle(24, 0, 593, 562);
        CourierBoldOblique.width[83] = 600;
        CourierBoldOblique.boundingBoxes[83] = new Rectangle(54, -22, 619, 604);
        CourierBoldOblique.width[138] = 600;
        CourierBoldOblique.boundingBoxes[138] = new Rectangle(54, -22, 635, 812);
        CourierBoldOblique.width[84] = 600;
        CourierBoldOblique.boundingBoxes[84] = new Rectangle(86, 0, 593, 562);
        CourierBoldOblique.width[222] = 600;
        CourierBoldOblique.boundingBoxes[222] = new Rectangle(48, 0, 572, 562);
        CourierBoldOblique.width[85] = 600;
        CourierBoldOblique.boundingBoxes[85] = new Rectangle(101, -18, 615, 580);
        CourierBoldOblique.width[218] = 600;
        CourierBoldOblique.boundingBoxes[218] = new Rectangle(101, -18, 615, 802);
        CourierBoldOblique.width[219] = 600;
        CourierBoldOblique.boundingBoxes[219] = new Rectangle(101, -18, 615, 798);
        CourierBoldOblique.width[220] = 600;
        CourierBoldOblique.boundingBoxes[220] = new Rectangle(101, -18, 615, 779);
        CourierBoldOblique.width[217] = 600;
        CourierBoldOblique.boundingBoxes[217] = new Rectangle(101, -18, 615, 802);
        CourierBoldOblique.width[86] = 600;
        CourierBoldOblique.boundingBoxes[86] = new Rectangle(84, 0, 649, 562);
        CourierBoldOblique.width[87] = 600;
        CourierBoldOblique.boundingBoxes[87] = new Rectangle(79, 0, 659, 562);
        CourierBoldOblique.width[88] = 600;
        CourierBoldOblique.boundingBoxes[88] = new Rectangle(12, 0, 678, 562);
        CourierBoldOblique.width[89] = 600;
        CourierBoldOblique.boundingBoxes[89] = new Rectangle(109, 0, 600, 562);
        CourierBoldOblique.width[221] = 600;
        CourierBoldOblique.boundingBoxes[221] = new Rectangle(109, 0, 600, 784);
        CourierBoldOblique.width[159] = 600;
        CourierBoldOblique.boundingBoxes[159] = new Rectangle(109, 0, 600, 761);
        CourierBoldOblique.width[90] = 600;
        CourierBoldOblique.boundingBoxes[90] = new Rectangle(62, 0, 575, 562);
        CourierBoldOblique.width[142] = 600;
        CourierBoldOblique.boundingBoxes[142] = new Rectangle(62, 0, 597, 790);
        CourierBoldOblique.width[97] = 600;
        CourierBoldOblique.boundingBoxes[97] = new Rectangle(61, -15, 532, 469);
        CourierBoldOblique.width[225] = 600;
        CourierBoldOblique.boundingBoxes[225] = new Rectangle(61, -15, 548, 676);
        CourierBoldOblique.width[226] = 600;
        CourierBoldOblique.boundingBoxes[226] = new Rectangle(61, -15, 546, 672);
        CourierBoldOblique.width[180] = 600;
        CourierBoldOblique.boundingBoxes[180] = new Rectangle(312, 508, 297, 153);
        CourierBoldOblique.width[228] = 600;
        CourierBoldOblique.boundingBoxes[228] = new Rectangle(61, -15, 534, 653);
        CourierBoldOblique.width[230] = 600;
        CourierBoldOblique.boundingBoxes[230] = new Rectangle(21, -15, 631, 469);
        CourierBoldOblique.width[224] = 600;
        CourierBoldOblique.boundingBoxes[224] = new Rectangle(61, -15, 532, 676);
        CourierBoldOblique.width[38] = 600;
        CourierBoldOblique.boundingBoxes[38] = new Rectangle(61, -15, 534, 558);
        CourierBoldOblique.width[229] = 600;
        CourierBoldOblique.boundingBoxes[229] = new Rectangle(61, -15, 532, 693);
        CourierBoldOblique.width[94] = 600;
        CourierBoldOblique.boundingBoxes[94] = new Rectangle(171, 250, 385, 366);
        CourierBoldOblique.width[126] = 600;
        CourierBoldOblique.boundingBoxes[126] = new Rectangle(120, 153, 470, 203);
        CourierBoldOblique.width[42] = 600;
        CourierBoldOblique.boundingBoxes[42] = new Rectangle(179, 219, 419, 382);
        CourierBoldOblique.width[64] = 600;
        CourierBoldOblique.boundingBoxes[64] = new Rectangle(65, -15, 577, 631);
        CourierBoldOblique.width[227] = 600;
        CourierBoldOblique.boundingBoxes[227] = new Rectangle(61, -15, 582, 651);
        CourierBoldOblique.width[98] = 600;
        CourierBoldOblique.boundingBoxes[98] = new Rectangle(13, -15, 623, 641);
        CourierBoldOblique.width[92] = 600;
        CourierBoldOblique.boundingBoxes[92] = new Rectangle(222, -77, 274, 703);
        CourierBoldOblique.width[124] = 600;
        CourierBoldOblique.boundingBoxes[124] = new Rectangle(201, -250, 304, 1000);
        CourierBoldOblique.width[123] = 600;
        CourierBoldOblique.boundingBoxes[123] = new Rectangle(203, -102, 392, 718);
        CourierBoldOblique.width[125] = 600;
        CourierBoldOblique.boundingBoxes[125] = new Rectangle(114, -102, 392, 718);
        CourierBoldOblique.width[91] = 600;
        CourierBoldOblique.boundingBoxes[91] = new Rectangle(223, -102, 383, 718);
        CourierBoldOblique.width[93] = 600;
        CourierBoldOblique.boundingBoxes[93] = new Rectangle(103, -102, 383, 718);
        CourierBoldOblique.width[166] = 600;
        CourierBoldOblique.boundingBoxes[166] = new Rectangle(217, -175, 272, 850);
        CourierBoldOblique.width[149] = 600;
        CourierBoldOblique.boundingBoxes[149] = new Rectangle(196, 132, 327, 298);
        CourierBoldOblique.width[99] = 600;
        CourierBoldOblique.boundingBoxes[99] = new Rectangle(81, -15, 550, 474);
        CourierBoldOblique.width[231] = 600;
        CourierBoldOblique.boundingBoxes[231] = new Rectangle(81, -206, 550, 665);
        CourierBoldOblique.width[184] = 600;
        CourierBoldOblique.boundingBoxes[184] = new Rectangle(168, -206, 200, 206);
        CourierBoldOblique.width[162] = 600;
        CourierBoldOblique.boundingBoxes[162] = new Rectangle(121, -49, 484, 663);
        CourierBoldOblique.width[136] = 600;
        CourierBoldOblique.boundingBoxes[136] = new Rectangle(212, 483, 395, 174);
        CourierBoldOblique.width[58] = 600;
        CourierBoldOblique.boundingBoxes[58] = new Rectangle(205, -15, 275, 440);
        CourierBoldOblique.width[44] = 600;
        CourierBoldOblique.boundingBoxes[44] = new Rectangle(99, -111, 331, 285);
        CourierBoldOblique.width[169] = 600;
        CourierBoldOblique.boundingBoxes[169] = new Rectangle(53, -18, 614, 598);
        CourierBoldOblique.width[164] = 600;
        CourierBoldOblique.boundingBoxes[164] = new Rectangle(77, 49, 567, 468);
        CourierBoldOblique.width[100] = 600;
        CourierBoldOblique.boundingBoxes[100] = new Rectangle(60, -15, 585, 641);
        CourierBoldOblique.width[134] = 600;
        CourierBoldOblique.boundingBoxes[134] = new Rectangle(175, -70, 411, 650);
        CourierBoldOblique.width[135] = 600;
        CourierBoldOblique.boundingBoxes[135] = new Rectangle(121, -70, 466, 650);
        CourierBoldOblique.width[176] = 600;
        CourierBoldOblique.boundingBoxes[176] = new Rectangle(173, 243, 397, 373);
        CourierBoldOblique.width[168] = 600;
        CourierBoldOblique.boundingBoxes[168] = new Rectangle(246, 498, 349, 140);
        CourierBoldOblique.width[247] = 600;
        CourierBoldOblique.boundingBoxes[247] = new Rectangle(114, 16, 482, 484);
        CourierBoldOblique.width[36] = 600;
        CourierBoldOblique.boundingBoxes[36] = new Rectangle(87, -126, 543, 792);
        CourierBoldOblique.width[101] = 600;
        CourierBoldOblique.boundingBoxes[101] = new Rectangle(81, -15, 524, 469);
        CourierBoldOblique.width[233] = 600;
        CourierBoldOblique.boundingBoxes[233] = new Rectangle(81, -15, 528, 676);
        CourierBoldOblique.width[234] = 600;
        CourierBoldOblique.boundingBoxes[234] = new Rectangle(81, -15, 526, 672);
        CourierBoldOblique.width[235] = 600;
        CourierBoldOblique.boundingBoxes[235] = new Rectangle(81, -15, 524, 653);
        CourierBoldOblique.width[232] = 600;
        CourierBoldOblique.boundingBoxes[232] = new Rectangle(81, -15, 524, 676);
        CourierBoldOblique.width[56] = 600;
        CourierBoldOblique.boundingBoxes[56] = new Rectangle(115, -15, 489, 631);
        CourierBoldOblique.width[133] = 600;
        CourierBoldOblique.boundingBoxes[133] = new Rectangle(35, -15, 552, 131);
        CourierBoldOblique.width[151] = 600;
        CourierBoldOblique.boundingBoxes[151] = new Rectangle(33, 203, 644, 110);
        CourierBoldOblique.width[150] = 600;
        CourierBoldOblique.boundingBoxes[150] = new Rectangle(108, 203, 494, 110);
        CourierBoldOblique.width[61] = 600;
        CourierBoldOblique.boundingBoxes[61] = new Rectangle(96, 118, 518, 280);
        CourierBoldOblique.width[240] = 600;
        CourierBoldOblique.boundingBoxes[240] = new Rectangle(93, -27, 568, 653);
        CourierBoldOblique.width[33] = 600;
        CourierBoldOblique.boundingBoxes[33] = new Rectangle(215, -15, 280, 587);
        CourierBoldOblique.width[161] = 600;
        CourierBoldOblique.boundingBoxes[161] = new Rectangle(196, -146, 281, 595);
        CourierBoldOblique.width[102] = 600;
        CourierBoldOblique.boundingBoxes[102] = new Rectangle(83, 0, 594, 626);
        CourierBoldOblique.width[53] = 600;
        CourierBoldOblique.boundingBoxes[53] = new Rectangle(77, -15, 544, 616);
        CourierBoldOblique.width[131] = 600;
        CourierBoldOblique.boundingBoxes[131] = new Rectangle(-57, -131, 759, 747);
        CourierBoldOblique.width[52] = 600;
        CourierBoldOblique.boundingBoxes[52] = new Rectangle(81, 0, 478, 616);
        CourierBoldOblique.width[103] = 600;
        CourierBoldOblique.boundingBoxes[103] = new Rectangle(40, -146, 634, 600);
        CourierBoldOblique.width[223] = 600;
        CourierBoldOblique.boundingBoxes[223] = new Rectangle(22, -15, 607, 641);
        CourierBoldOblique.width[96] = 600;
        CourierBoldOblique.boundingBoxes[96] = new Rectangle(272, 508, 231, 153);
        CourierBoldOblique.width[62] = 600;
        CourierBoldOblique.boundingBoxes[62] = new Rectangle(97, 15, 492, 486);
        CourierBoldOblique.width[171] = 600;
        CourierBoldOblique.boundingBoxes[171] = new Rectangle(62, 70, 577, 376);
        CourierBoldOblique.width[187] = 600;
        CourierBoldOblique.boundingBoxes[187] = new Rectangle(71, 70, 576, 376);
        CourierBoldOblique.width[139] = 600;
        CourierBoldOblique.boundingBoxes[139] = new Rectangle(195, 70, 350, 376);
        CourierBoldOblique.width[155] = 600;
        CourierBoldOblique.boundingBoxes[155] = new Rectangle(165, 70, 349, 376);
        CourierBoldOblique.width[104] = 600;
        CourierBoldOblique.boundingBoxes[104] = new Rectangle(18, 0, 597, 626);
        CourierBoldOblique.width[45] = 600;
        CourierBoldOblique.boundingBoxes[45] = new Rectangle(143, 203, 424, 110);
        CourierBoldOblique.width[105] = 600;
        CourierBoldOblique.boundingBoxes[105] = new Rectangle(77, 0, 469, 658);
        CourierBoldOblique.width[237] = 600;
        CourierBoldOblique.boundingBoxes[237] = new Rectangle(77, 0, 532, 661);
        CourierBoldOblique.width[238] = 600;
        CourierBoldOblique.boundingBoxes[238] = new Rectangle(77, 0, 500, 657);
        CourierBoldOblique.width[239] = 600;
        CourierBoldOblique.boundingBoxes[239] = new Rectangle(77, 0, 484, 618);
        CourierBoldOblique.width[236] = 600;
        CourierBoldOblique.boundingBoxes[236] = new Rectangle(77, 0, 469, 661);
        CourierBoldOblique.width[106] = 600;
        CourierBoldOblique.boundingBoxes[106] = new Rectangle(36, -146, 544, 804);
        CourierBoldOblique.width[107] = 600;
        CourierBoldOblique.boundingBoxes[107] = new Rectangle(33, 0, 610, 626);
        CourierBoldOblique.width[108] = 600;
        CourierBoldOblique.boundingBoxes[108] = new Rectangle(77, 0, 469, 626);
        CourierBoldOblique.width[60] = 600;
        CourierBoldOblique.boundingBoxes[60] = new Rectangle(120, 15, 493, 486);
        CourierBoldOblique.width[172] = 600;
        CourierBoldOblique.boundingBoxes[172] = new Rectangle(135, 103, 482, 310);
        CourierBoldOblique.width[109] = 600;
        CourierBoldOblique.boundingBoxes[109] = new Rectangle(-22, 0, 671, 454);
        CourierBoldOblique.width[175] = 600;
        CourierBoldOblique.boundingBoxes[175] = new Rectangle(195, 505, 442, 80);
        CourierBoldOblique.width[181] = 600;
        CourierBoldOblique.boundingBoxes[181] = new Rectangle(49, -142, 543, 581);
        CourierBoldOblique.width[215] = 600;
        CourierBoldOblique.boundingBoxes[215] = new Rectangle(104, 39, 502, 439);
        CourierBoldOblique.width[110] = 600;
        CourierBoldOblique.boundingBoxes[110] = new Rectangle(18, 0, 597, 454);
        CourierBoldOblique.width[57] = 600;
        CourierBoldOblique.boundingBoxes[57] = new Rectangle(75, -15, 517, 631);
        CourierBoldOblique.width[241] = 600;
        CourierBoldOblique.boundingBoxes[241] = new Rectangle(18, 0, 625, 636);
        CourierBoldOblique.width[35] = 600;
        CourierBoldOblique.boundingBoxes[35] = new Rectangle(88, -45, 553, 696);
        CourierBoldOblique.width[111] = 600;
        CourierBoldOblique.boundingBoxes[111] = new Rectangle(71, -15, 551, 469);
        CourierBoldOblique.width[243] = 600;
        CourierBoldOblique.boundingBoxes[243] = new Rectangle(71, -15, 578, 676);
        CourierBoldOblique.width[244] = 600;
        CourierBoldOblique.boundingBoxes[244] = new Rectangle(71, -15, 551, 672);
        CourierBoldOblique.width[246] = 600;
        CourierBoldOblique.boundingBoxes[246] = new Rectangle(71, -15, 551, 653);
        CourierBoldOblique.width[156] = 600;
        CourierBoldOblique.boundingBoxes[156] = new Rectangle(18, -15, 644, 469);
        CourierBoldOblique.width[242] = 600;
        CourierBoldOblique.boundingBoxes[242] = new Rectangle(71, -15, 551, 676);
        CourierBoldOblique.width[49] = 600;
        CourierBoldOblique.boundingBoxes[49] = new Rectangle(93, 0, 469, 616);
        CourierBoldOblique.width[189] = 600;
        CourierBoldOblique.boundingBoxes[189] = new Rectangle(22, -60, 694, 721);
        CourierBoldOblique.width[188] = 600;
        CourierBoldOblique.boundingBoxes[188] = new Rectangle(13, -60, 694, 721);
        CourierBoldOblique.width[185] = 600;
        CourierBoldOblique.boundingBoxes[185] = new Rectangle(212, 230, 302, 386);
        CourierBoldOblique.width[170] = 600;
        CourierBoldOblique.boundingBoxes[170] = new Rectangle(188, 196, 338, 384);
        CourierBoldOblique.width[186] = 600;
        CourierBoldOblique.boundingBoxes[186] = new Rectangle(188, 196, 355, 384);
        CourierBoldOblique.width[248] = 600;
        CourierBoldOblique.boundingBoxes[248] = new Rectangle(54, -24, 584, 487);
        CourierBoldOblique.width[245] = 600;
        CourierBoldOblique.boundingBoxes[245] = new Rectangle(71, -15, 572, 651);
        CourierBoldOblique.width[112] = 600;
        CourierBoldOblique.boundingBoxes[112] = new Rectangle(-32, -142, 654, 596);
        CourierBoldOblique.width[182] = 600;
        CourierBoldOblique.boundingBoxes[182] = new Rectangle(61, -70, 639, 650);
        CourierBoldOblique.width[40] = 600;
        CourierBoldOblique.boundingBoxes[40] = new Rectangle(265, -102, 327, 718);
        CourierBoldOblique.width[41] = 600;
        CourierBoldOblique.boundingBoxes[41] = new Rectangle(117, -102, 327, 718);
        CourierBoldOblique.width[37] = 600;
        CourierBoldOblique.boundingBoxes[37] = new Rectangle(101, -15, 524, 631);
        CourierBoldOblique.width[46] = 600;
        CourierBoldOblique.boundingBoxes[46] = new Rectangle(206, -15, 221, 186);
        CourierBoldOblique.width[183] = 600;
        CourierBoldOblique.boundingBoxes[183] = new Rectangle(248, 165, 213, 186);
        CourierBoldOblique.width[137] = 600;
        CourierBoldOblique.boundingBoxes[137] = new Rectangle(-45, -15, 788, 631);
        CourierBoldOblique.width[43] = 600;
        CourierBoldOblique.boundingBoxes[43] = new Rectangle(114, 39, 482, 439);
        CourierBoldOblique.width[177] = 600;
        CourierBoldOblique.boundingBoxes[177] = new Rectangle(76, 24, 538, 491);
        CourierBoldOblique.width[113] = 600;
        CourierBoldOblique.boundingBoxes[113] = new Rectangle(60, -142, 625, 596);
        CourierBoldOblique.width[63] = 600;
        CourierBoldOblique.boundingBoxes[63] = new Rectangle(183, -14, 409, 594);
        CourierBoldOblique.width[191] = 600;
        CourierBoldOblique.boundingBoxes[191] = new Rectangle(100, -146, 409, 595);
        CourierBoldOblique.width[34] = 600;
        CourierBoldOblique.boundingBoxes[34] = new Rectangle(211, 277, 374, 285);
        CourierBoldOblique.width[132] = 600;
        CourierBoldOblique.boundingBoxes[132] = new Rectangle(34, -142, 526, 285);
        CourierBoldOblique.width[147] = 600;
        CourierBoldOblique.boundingBoxes[147] = new Rectangle(190, 277, 404, 285);
        CourierBoldOblique.width[148] = 600;
        CourierBoldOblique.boundingBoxes[148] = new Rectangle(119, 277, 526, 285);
        CourierBoldOblique.width[145] = 600;
        CourierBoldOblique.boundingBoxes[145] = new Rectangle(297, 277, 190, 285);
        CourierBoldOblique.width[146] = 600;
        CourierBoldOblique.boundingBoxes[146] = new Rectangle(229, 277, 314, 285);
        CourierBoldOblique.width[130] = 600;
        CourierBoldOblique.boundingBoxes[130] = new Rectangle(144, -142, 314, 285);
        CourierBoldOblique.width[39] = 600;
        CourierBoldOblique.boundingBoxes[39] = new Rectangle(303, 277, 190, 285);
        CourierBoldOblique.width[114] = 600;
        CourierBoldOblique.boundingBoxes[114] = new Rectangle(47, 0, 608, 454);
        CourierBoldOblique.width[174] = 600;
        CourierBoldOblique.boundingBoxes[174] = new Rectangle(53, -18, 614, 598);
        CourierBoldOblique.width[115] = 600;
        CourierBoldOblique.boundingBoxes[115] = new Rectangle(66, -17, 542, 476);
        CourierBoldOblique.width[154] = 600;
        CourierBoldOblique.boundingBoxes[154] = new Rectangle(66, -17, 567, 684);
        CourierBoldOblique.width[167] = 600;
        CourierBoldOblique.boundingBoxes[167] = new Rectangle(74, -70, 546, 650);
        CourierBoldOblique.width[59] = 600;
        CourierBoldOblique.boundingBoxes[59] = new Rectangle(99, -111, 382, 536);
        CourierBoldOblique.width[55] = 600;
        CourierBoldOblique.boundingBoxes[55] = new Rectangle(147, 0, 475, 601);
        CourierBoldOblique.width[54] = 600;
        CourierBoldOblique.boundingBoxes[54] = new Rectangle(135, -15, 517, 631);
        CourierBoldOblique.width[47] = 600;
        CourierBoldOblique.boundingBoxes[47] = new Rectangle(90, -77, 536, 703);
        CourierBoldOblique.width[32] = 600;
        CourierBoldOblique.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        CourierBoldOblique.width[163] = 600;
        CourierBoldOblique.boundingBoxes[163] = new Rectangle(106, -28, 544, 639);
        CourierBoldOblique.width[116] = 600;
        CourierBoldOblique.boundingBoxes[116] = new Rectangle(118, -15, 449, 577);
        CourierBoldOblique.width[254] = 600;
        CourierBoldOblique.boundingBoxes[254] = new Rectangle(-32, -142, 654, 768);
        CourierBoldOblique.width[51] = 600;
        CourierBoldOblique.boundingBoxes[51] = new Rectangle(71, -15, 500, 631);
        CourierBoldOblique.width[190] = 600;
        CourierBoldOblique.boundingBoxes[190] = new Rectangle(8, -60, 691, 721);
        CourierBoldOblique.width[179] = 600;
        CourierBoldOblique.boundingBoxes[179] = new Rectangle(193, 222, 333, 394);
        CourierBoldOblique.width[152] = 600;
        CourierBoldOblique.boundingBoxes[152] = new Rectangle(199, 493, 444, 143);
        CourierBoldOblique.width[153] = 600;
        CourierBoldOblique.boundingBoxes[153] = new Rectangle(86, 230, 783, 332);
        CourierBoldOblique.width[50] = 600;
        CourierBoldOblique.boundingBoxes[50] = new Rectangle(61, 0, 533, 616);
        CourierBoldOblique.width[178] = 600;
        CourierBoldOblique.boundingBoxes[178] = new Rectangle(191, 230, 351, 386);
        CourierBoldOblique.width[117] = 600;
        CourierBoldOblique.boundingBoxes[117] = new Rectangle(70, -15, 522, 454);
        CourierBoldOblique.width[250] = 600;
        CourierBoldOblique.boundingBoxes[250] = new Rectangle(70, -15, 529, 676);
        CourierBoldOblique.width[251] = 600;
        CourierBoldOblique.boundingBoxes[251] = new Rectangle(70, -15, 527, 672);
        CourierBoldOblique.width[252] = 600;
        CourierBoldOblique.boundingBoxes[252] = new Rectangle(70, -15, 525, 653);
        CourierBoldOblique.width[249] = 600;
        CourierBoldOblique.boundingBoxes[249] = new Rectangle(70, -15, 522, 676);
        CourierBoldOblique.width[95] = 600;
        CourierBoldOblique.boundingBoxes[95] = new Rectangle(-27, -125, 612, 50);
        CourierBoldOblique.width[118] = 600;
        CourierBoldOblique.boundingBoxes[118] = new Rectangle(70, 0, 625, 439);
        CourierBoldOblique.width[119] = 600;
        CourierBoldOblique.boundingBoxes[119] = new Rectangle(53, 0, 659, 439);
        CourierBoldOblique.width[120] = 600;
        CourierBoldOblique.boundingBoxes[120] = new Rectangle(6, 0, 665, 439);
        CourierBoldOblique.width[121] = 600;
        CourierBoldOblique.boundingBoxes[121] = new Rectangle(-21, -142, 716, 581);
        CourierBoldOblique.width[253] = 600;
        CourierBoldOblique.boundingBoxes[253] = new Rectangle(-21, -142, 716, 803);
        CourierBoldOblique.width[255] = 600;
        CourierBoldOblique.boundingBoxes[255] = new Rectangle(-21, -142, 716, 780);
        CourierBoldOblique.width[165] = 600;
        CourierBoldOblique.boundingBoxes[165] = new Rectangle(98, 0, 612, 562);
        CourierBoldOblique.width[122] = 600;
        CourierBoldOblique.boundingBoxes[122] = new Rectangle(81, 0, 533, 439);
        CourierBoldOblique.width[158] = 600;
        CourierBoldOblique.boundingBoxes[158] = new Rectangle(81, 0, 562, 667);
        CourierBoldOblique.width[48] = 600;
        CourierBoldOblique.boundingBoxes[48] = new Rectangle(135, -15, 458, 631);
        familyNames = new HashSet();
        familyNames.add("Courier");
    }
}

