/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.awt.Rectangle;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.CharNormalize;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CIDFull;
import org.apache.fop.fonts.CIDSet;
import org.apache.fop.fonts.CIDSubset;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.util.CharUtilities;

public class MultiByteFont
extends CIDFont
implements Substitutable,
Positionable {
    private static final Log log = LogFactory.getLog(MultiByteFont.class);
    private String ttcName;
    private String encoding = "Identity-H";
    private int defaultWidth;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    protected final CIDSet cidSet;
    private GlyphDefinitionTable gdef;
    private GlyphSubstitutionTable gsub;
    private GlyphPositioningTable gpos;
    private int numMapped;
    private int numUnmapped;
    private int nextPrivateUse = 57344;
    private int firstPrivate;
    private int lastPrivate;
    private int firstUnmapped;
    private int lastUnmapped;
    protected Rectangle[] boundingBoxes;
    private boolean isOTFFile;
    private static final int NUM_MOST_LIKELY_GLYPHS = 256;
    private int[] mostLikelyGlyphs = new int[256];
    private LinkedHashMap<Integer, String> usedGlyphNames = new LinkedHashMap();

    public MultiByteFont(InternalResourceResolver resourceResolver, EmbeddingMode embeddingMode) {
        super(resourceResolver);
        this.setFontType(FontType.TYPE0);
        this.setEmbeddingMode(embeddingMode);
        this.cidSet = embeddingMode != EmbeddingMode.FULL ? new CIDSubset(this) : new CIDFull(this);
    }

    @Override
    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    @Override
    public String getRegistry() {
        return "Adobe";
    }

    @Override
    public String getOrdering() {
        return "UCS";
    }

    @Override
    public int getSupplement() {
        return 0;
    }

    @Override
    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public void setIsOTFFile(boolean isOTFFile) {
        this.isOTFFile = isOTFFile;
    }

    public boolean isOTFFile() {
        return this.isOTFFile;
    }

    public void setCIDType(CIDFontType cidType) {
        this.cidType = cidType;
    }

    @Override
    public String getEmbedFontName() {
        if (this.isEmbeddable()) {
            return FontUtil.stripWhiteSpace(super.getFontName());
        }
        return super.getFontName();
    }

    @Override
    public boolean isEmbeddable() {
        return this.getEmbedFileURI() != null || this.getEmbedResourceName() != null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        return this.getEmbeddingMode() != EmbeddingMode.FULL;
    }

    @Override
    public CIDSet getCIDSet() {
        return this.cidSet;
    }

    public void mapUsedGlyphName(int gid, String value) {
        this.usedGlyphNames.put(gid, value);
    }

    public LinkedHashMap<Integer, String> getUsedGlyphNames() {
        return this.usedGlyphNames;
    }

    @Override
    public String getEncodingName() {
        return this.encoding;
    }

    @Override
    public int getWidth(int i, int size) {
        if (this.isEmbeddable()) {
            int glyphIndex = this.cidSet.getOriginalGlyphIndex(i);
            return size * this.width[glyphIndex];
        }
        return size * this.width[i];
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length);
        return arr;
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        int index = this.isEmbeddable() ? this.cidSet.getOriginalGlyphIndex(glyphIndex) : glyphIndex;
        Rectangle bbox = this.boundingBoxes[index];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    public int findGlyphIndex(int c) {
        int idx = c;
        int retIdx = 0;
        if (idx < 256 && this.mostLikelyGlyphs[idx] != 0) {
            return this.mostLikelyGlyphs[idx];
        }
        for (CMapSegment i : this.cmap) {
            if (retIdx != 0 || i.getUnicodeStart() > idx || i.getUnicodeEnd() < idx) continue;
            retIdx = i.getGlyphStartIndex() + idx - i.getUnicodeStart();
            if (idx < 256) {
                this.mostLikelyGlyphs[idx] = retIdx;
            }
            if (retIdx == 0) continue;
            break;
        }
        return retIdx;
    }

    protected synchronized void addPrivateUseMapping(int pu, int gi) {
        assert (this.findGlyphIndex(pu) == 0);
        this.cmap.add(new CMapSegment(pu, pu, gi));
    }

    private int createPrivateUseMapping(int gi) {
        while (this.nextPrivateUse < 63744 && this.findGlyphIndex(this.nextPrivateUse) != 0) {
            ++this.nextPrivateUse;
        }
        if (this.nextPrivateUse < 63744) {
            int pu = this.nextPrivateUse;
            this.addPrivateUseMapping(pu, gi);
            if (this.firstPrivate == 0) {
                this.firstPrivate = pu;
            }
            this.lastPrivate = pu;
            ++this.numMapped;
            if (log.isDebugEnabled()) {
                log.debug("Create private use mapping from " + CharUtilities.format(pu) + " to glyph index " + gi + " in font '" + this.getFullName() + "'");
            }
            return pu;
        }
        if (this.firstUnmapped == 0) {
            this.firstUnmapped = gi;
        }
        this.lastUnmapped = gi;
        ++this.numUnmapped;
        log.warn("Exhausted private use area: unable to map " + this.numUnmapped + " glyphs in glyph index range [" + this.firstUnmapped + "," + this.lastUnmapped + "] (inclusive) of font '" + this.getFullName() + "'");
        return 0;
    }

    private int findCharacterFromGlyphIndex(int gi, boolean augment) {
        int cc = 0;
        for (CMapSegment segment : this.cmap) {
            int s = segment.getGlyphStartIndex();
            int e2 = s + (segment.getUnicodeEnd() - segment.getUnicodeStart());
            if (gi < s || gi > e2) continue;
            cc = segment.getUnicodeStart() + (gi - s);
            break;
        }
        if (cc == 0 && augment) {
            cc = this.createPrivateUseMapping(gi);
        }
        return cc;
    }

    private int findCharacterFromGlyphIndex(int gi) {
        return this.findCharacterFromGlyphIndex(gi, true);
    }

    protected BitSet getGlyphIndices() {
        BitSet bitset = new BitSet();
        bitset.set(0);
        bitset.set(1);
        bitset.set(2);
        for (CMapSegment i : this.cmap) {
            int start = i.getUnicodeStart();
            int end = i.getUnicodeEnd();
            int glyphIndex = i.getGlyphStartIndex();
            while (start++ < end + 1) {
                bitset.set(glyphIndex++);
            }
        }
        return bitset;
    }

    protected char[] getChars() {
        char[] chars = new char[this.width.length];
        for (CMapSegment i : this.cmap) {
            int start = i.getUnicodeStart();
            int end = i.getUnicodeEnd();
            int glyphIndex = i.getGlyphStartIndex();
            while (start < end + 1) {
                chars[glyphIndex++] = (char)start++;
            }
        }
        return chars;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        int glyphIndex = this.findGlyphIndex(c);
        if (glyphIndex == 0) {
            this.warnMissingGlyph(c);
            if (!this.isOTFFile) {
                glyphIndex = this.findGlyphIndex(35);
            }
        }
        if (this.isEmbeddable()) {
            glyphIndex = this.cidSet.mapChar(glyphIndex, c);
        }
        if (this.isCID() && glyphIndex > 256) {
            this.mapUnencodedChar(c);
        }
        return (char)glyphIndex;
    }

    @Override
    public int mapCodePoint(int cp) {
        this.notifyMapOperation();
        int glyphIndex = this.findGlyphIndex(cp);
        if (glyphIndex == 0) {
            for (char ch : Character.toChars(cp)) {
                this.warnMissingGlyph(ch);
            }
            if (!this.isOTFFile) {
                glyphIndex = this.findGlyphIndex(35);
            }
        }
        if (this.isEmbeddable()) {
            glyphIndex = this.cidSet.mapCodePoint(glyphIndex, cp);
        }
        return (char)glyphIndex;
    }

    @Override
    public boolean hasChar(char c) {
        return this.hasCodePoint(c);
    }

    @Override
    public boolean hasCodePoint(int cp) {
        return this.findGlyphIndex(cp) != 0;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public void setTTCName(String ttcName) {
        this.ttcName = ttcName;
    }

    public void setWidthArray(int[] wds) {
        this.width = wds;
    }

    public void setBBoxArray(Rectangle[] boundingBoxes) {
        this.boundingBoxes = boundingBoxes;
    }

    @Override
    public Map<Integer, Integer> getUsedGlyphs() {
        return this.cidSet.getGlyphs();
    }

    @Override
    public char getUnicodeFromGID(int glyphIndex) {
        return this.cidSet.getUnicodeFromGID(glyphIndex);
    }

    public int getGIDFromChar(char ch) {
        return this.cidSet.getGIDFromChar(ch);
    }

    public void setGDEF(GlyphDefinitionTable gdef) {
        if (this.gdef != null && gdef != null) {
            throw new IllegalStateException("font already associated with GDEF table");
        }
        this.gdef = gdef;
    }

    public GlyphDefinitionTable getGDEF() {
        return this.gdef;
    }

    public void setGSUB(GlyphSubstitutionTable gsub) {
        if (this.gsub != null && gsub != null) {
            throw new IllegalStateException("font already associated with GSUB table");
        }
        this.gsub = gsub;
    }

    public GlyphSubstitutionTable getGSUB() {
        return this.gsub;
    }

    public void setGPOS(GlyphPositioningTable gpos) {
        if (this.gpos != null && gpos != null) {
            throw new IllegalStateException("font already associated with GPOS table");
        }
        this.gpos = gpos;
    }

    public GlyphPositioningTable getGPOS() {
        return this.gpos;
    }

    @Override
    public boolean performsSubstitution() {
        return this.gsub != null;
    }

    @Override
    public CharSequence performSubstitution(CharSequence charSequence, String script, String language, List associations, boolean retainControls) {
        if (this.gsub != null) {
            charSequence = this.gsub.preProcess(charSequence, script, this, associations);
            GlyphSequence glyphSequence = this.charSequenceToGlyphSequence(charSequence, associations);
            GlyphSequence glyphSequenceSubstituted = this.gsub.substitute(glyphSequence, script, language);
            if (associations != null) {
                associations.clear();
                associations.addAll(glyphSequenceSubstituted.getAssociations());
            }
            if (!retainControls) {
                glyphSequenceSubstituted = MultiByteFont.elideControls(glyphSequenceSubstituted);
            }
            return this.mapGlyphsToChars(glyphSequenceSubstituted);
        }
        return charSequence;
    }

    public GlyphSequence charSequenceToGlyphSequence(CharSequence charSequence, List associations) {
        CharSequence normalizedCharSequence = this.normalize(charSequence, associations);
        return this.mapCharsToGlyphs(normalizedCharSequence, associations);
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language, List associations) {
        if (this.gdef != null) {
            GlyphSequence igs = this.mapCharsToGlyphs(cs, associations);
            GlyphSequence ogs = this.gdef.reorderCombiningMarks(igs, this.getUnscaledWidths(igs), gpa, script, language);
            if (associations != null) {
                associations.clear();
                associations.addAll(ogs.getAssociations());
            }
            CharSequence ocs = this.mapGlyphsToChars(ogs);
            return ocs;
        }
        return cs;
    }

    protected int[] getUnscaledWidths(GlyphSequence gs) {
        int[] widths = new int[gs.getGlyphCount()];
        int n = widths.length;
        for (int i = 0; i < n; ++i) {
            if (i >= this.width.length) continue;
            widths[i] = this.width[i];
        }
        return widths;
    }

    @Override
    public boolean performsPositioning() {
        return this.gpos != null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        if (this.gpos != null) {
            int[][] adjustments;
            GlyphSequence gs = this.mapCharsToGlyphs(cs, null);
            if (this.gpos.position(gs, script, language, fontSize, this.width, adjustments = new int[gs.getGlyphCount()][4])) {
                return this.scaleAdjustments(adjustments, fontSize);
            }
            return null;
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        throw new UnsupportedOperationException();
    }

    private int[][] scaleAdjustments(int[][] adjustments, int fontSize) {
        if (adjustments != null) {
            for (int[] gpa : adjustments) {
                for (int k = 0; k < 4; ++k) {
                    gpa[k] = gpa[k] * fontSize / 1000;
                }
            }
            return adjustments;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GlyphSequence mapCharsToGlyphs(CharSequence cs, List associations) {
        IntBuffer cb = IntBuffer.allocate(cs.length());
        IntBuffer gb = IntBuffer.allocate(cs.length());
        int giMissing = this.findGlyphIndex(35);
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            int cc = cs.charAt(i);
            if (cc >= 55296 && cc < 56320) {
                char sl;
                if (i + 1 >= n) throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at end of sequence");
                int sh = cc;
                if ((sl = cs.charAt(++i)) < '\udc00' || sl >= '\ue000') throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated high surrogate at index " + i);
                cc = 65536 + (sh - 55296 << 10) + (sl - 56320 << 0);
            } else if (cc >= 56320 && cc < 57344) {
                throw new IllegalArgumentException("ill-formed UTF-16 sequence, contains isolated low surrogate at index " + i);
            }
            this.notifyMapOperation();
            int gi = this.findGlyphIndex(cc);
            if (gi == 0) {
                this.warnMissingGlyph((char)cc);
                gi = giMissing;
            }
            cb.put(cc);
            gb.put(gi);
        }
        cb.flip();
        gb.flip();
        associations = associations != null && associations.size() == cs.length() ? new ArrayList(associations) : null;
        return new GlyphSequence(cb, gb, associations);
    }

    private CharSequence mapGlyphsToChars(GlyphSequence gs) {
        int ng = gs.getGlyphCount();
        int ccMissing = 35;
        ArrayList<Character> chars = new ArrayList<Character>(gs.getUTF16CharacterCount());
        int n = ng;
        for (int i = 0; i < n; ++i) {
            int gi = gs.getGlyph(i);
            int cc = this.findCharacterFromGlyphIndex(gi);
            if (cc == 0 || cc > 0x10FFFF) {
                cc = ccMissing;
                log.warn("Unable to map glyph index " + gi + " to Unicode scalar in font '" + this.getFullName() + "', substituting missing character '" + (char)cc + "'");
            }
            if (cc > 65535) {
                int sh = ((cc -= 65536) >> 10 & 0x3FF) + 55296;
                int sl = (cc >> 0 & 0x3FF) + 56320;
                chars.add(Character.valueOf((char)sh));
                chars.add(Character.valueOf((char)sl));
                continue;
            }
            chars.add(Character.valueOf((char)cc));
        }
        CharBuffer cb = CharBuffer.allocate(chars.size());
        Iterator i$ = chars.iterator();
        while (i$.hasNext()) {
            char c = ((Character)i$.next()).charValue();
            cb.put(c);
        }
        cb.flip();
        return cb;
    }

    private CharSequence normalize(CharSequence cs, List associations) {
        return this.hasDecomposable(cs) ? this.decompose(cs, associations) : cs;
    }

    private boolean hasDecomposable(CharSequence cs) {
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            char cc = cs.charAt(i);
            if (!CharNormalize.isDecomposable(cc)) continue;
            return true;
        }
        return false;
    }

    private CharSequence decompose(CharSequence cs, List associations) {
        StringBuffer sb = new StringBuffer(cs.length());
        int[] daBuffer = new int[CharNormalize.maximumDecompositionLength()];
        int n = cs.length();
        for (int i = 0; i < n; ++i) {
            int[] da;
            char cc = cs.charAt(i);
            for (int aDa : da = CharNormalize.decompose(cc, daBuffer)) {
                if (aDa <= 0) break;
                sb.append((char)aDa);
            }
        }
        return sb;
    }

    private static GlyphSequence elideControls(GlyphSequence gs) {
        if (MultiByteFont.hasElidableControl(gs)) {
            int[] ca = gs.getCharacterArray(false);
            IntBuffer ngb = IntBuffer.allocate(gs.getGlyphCount());
            ArrayList<CharAssociation> nal = new ArrayList<CharAssociation>(gs.getGlyphCount());
            int n = gs.getGlyphCount();
            for (int i = 0; i < n; ++i) {
                int ch;
                int s;
                CharAssociation a = gs.getAssociation(i);
                int e2 = a.getEnd();
                for (s = a.getStart(); s < e2 && MultiByteFont.isElidableControl(ch = ca[s]); ++s) {
                }
                if (s == e2) continue;
                ngb.put(gs.getGlyph(i));
                nal.add(a);
            }
            ngb.flip();
            return new GlyphSequence(gs.getCharacters(), ngb, nal, gs.getPredications());
        }
        return gs;
    }

    private static boolean hasElidableControl(GlyphSequence gs) {
        int[] ca;
        for (int ch : ca = gs.getCharacterArray(false)) {
            if (!MultiByteFont.isElidableControl(ch)) continue;
            return true;
        }
        return false;
    }

    private static boolean isElidableControl(int ch) {
        if (ch < 32) {
            return true;
        }
        if (ch >= 128 && ch < 160) {
            return true;
        }
        if (ch >= 8192 && ch <= 8303) {
            if (ch >= 8203 && ch <= 8207) {
                return true;
            }
            if (ch >= 8232 && ch <= 8238) {
                return true;
            }
            if (ch >= 8294) {
                return true;
            }
            return ch == 8288;
        }
        return false;
    }

    @Override
    public boolean hasFeature(int tableType, String script, String language, String feature) {
        GlyphTable table = tableType == 1 ? this.getGSUB() : (tableType == 2 ? this.getGPOS() : (tableType == 5 ? this.getGDEF() : null));
        return table != null && table.hasFeature(script, language, feature);
    }

    public Map<Integer, Integer> getWidthsMap() {
        return null;
    }

    public InputStream getCmapStream() {
        return null;
    }
}

