/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.DefaultFontConfig;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontConfig;
import org.apache.fop.fonts.FontConfigurator;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUris;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.fonts.autodetect.FontInfoFinder;
import org.apache.fop.util.LogUtil;

public class DefaultFontConfigurator
implements FontConfigurator<EmbedFontInfo> {
    protected static final Log log = LogFactory.getLog(DefaultFontConfigurator.class);
    private final FontManager fontManager;
    private final InternalResourceResolver resourceResolver;
    private final FontEventListener listener;
    private final boolean strict;

    public DefaultFontConfigurator(FontManager fontManager, FontEventListener listener, boolean strict) {
        this.fontManager = fontManager;
        this.resourceResolver = fontManager.getResourceResolver();
        this.listener = listener;
        this.strict = strict;
    }

    @Override
    public List<EmbedFontInfo> configure(FontConfig fontInfoConfig) throws FOPException {
        ArrayList<EmbedFontInfo> fontInfoList = new ArrayList<EmbedFontInfo>();
        if (fontInfoConfig != null) {
            assert (fontInfoConfig instanceof DefaultFontConfig);
            DefaultFontConfig adobeFontInfoConfig = (DefaultFontConfig)fontInfoConfig;
            long start = 0L;
            if (log.isDebugEnabled()) {
                log.debug("Starting font configuration...");
                start = System.currentTimeMillis();
            }
            FontAdder fontAdder = new FontAdder(this.fontManager, this.resourceResolver, this.listener);
            this.fontManager.autoDetectFonts(adobeFontInfoConfig.isAutoDetectFonts(), fontAdder, this.strict, this.listener, fontInfoList);
            this.addDirectories(adobeFontInfoConfig, fontAdder, fontInfoList);
            FontCache fontCache = this.fontManager.getFontCache();
            try {
                this.addFonts(adobeFontInfoConfig, fontCache, fontInfoList);
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(log, use, this.strict);
            }
            this.fontManager.updateReferencedFonts(fontInfoList);
            List<String> referencedFonts = adobeFontInfoConfig.getReferencedFontFamily();
            if (referencedFonts.size() > 0) {
                FontTriplet.Matcher matcher = FontManagerConfigurator.createFontsMatcher(referencedFonts, this.strict);
                this.fontManager.updateReferencedFonts(fontInfoList, matcher);
            }
            this.fontManager.saveCache();
            if (log.isDebugEnabled()) {
                log.debug("Finished font configuration in " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        return Collections.unmodifiableList(fontInfoList);
    }

    private void addDirectories(DefaultFontConfig fontInfoConfig, FontAdder fontAdder, List<EmbedFontInfo> fontInfoList) throws FOPException {
        List<DefaultFontConfig.Directory> directories = fontInfoConfig.getDirectories();
        for (DefaultFontConfig.Directory directory : directories) {
            FontFileFinder fontFileFinder = new FontFileFinder(directory.isRecursive() ? -1 : 1, this.listener);
            try {
                List<URL> fontURLList = fontFileFinder.find(directory.getDirectory());
                fontAdder.add(fontURLList, fontInfoList);
            }
            catch (IOException e2) {
                LogUtil.handleException(log, e2, this.strict);
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(log, use, this.strict);
            }
        }
    }

    private void addFonts(DefaultFontConfig fontInfoConfig, FontCache fontCache, List<EmbedFontInfo> fontInfoList) throws FOPException, URISyntaxException {
        List<DefaultFontConfig.Font> fonts = fontInfoConfig.getFonts();
        for (DefaultFontConfig.Font font : fonts) {
            EmbedFontInfo embedFontInfo = this.getFontInfo(font, fontCache);
            if (embedFontInfo == null) continue;
            fontInfoList.add(embedFontInfo);
        }
    }

    private EmbedFontInfo getFontInfo(DefaultFontConfig.Font font, FontCache fontCache) throws FOPException, URISyntaxException {
        String embed = font.getEmbedURI();
        String metrics = font.getMetrics();
        String afm = font.getAfm();
        String pfm = font.getPfm();
        URI embedUri = InternalResourceResolver.cleanURI(embed);
        URI metricsUri = metrics == null ? null : InternalResourceResolver.cleanURI(metrics);
        URI afmUri = afm == null ? null : InternalResourceResolver.cleanURI(afm);
        URI pfmUri = pfm == null ? null : InternalResourceResolver.cleanURI(pfm);
        FontUris fontUris = afmUri != null || pfmUri != null ? new FontUris(embedUri, metricsUri, afmUri, pfmUri) : new FontUris(embedUri, metricsUri);
        String subFont = font.getSubFont();
        List<FontTriplet> tripletList = font.getTripletList();
        if (tripletList.size() == 0) {
            URI fontUri = this.resourceResolver.resolveFromBase(embedUri);
            FontInfoFinder finder = new FontInfoFinder();
            finder.setEventListener(this.listener);
            EmbedFontInfo[] infos = finder.find(fontUri, this.resourceResolver, fontCache);
            return infos[0];
        }
        EncodingMode encodingMode = EncodingMode.getValue(font.getEncodingMode());
        EmbeddingMode embeddingMode = EmbeddingMode.getValue(font.getEmbeddingMode());
        EmbedFontInfo embedFontInfo = new EmbedFontInfo(fontUris, font.isKerning(), font.isAdvanced(), tripletList, subFont, encodingMode, embeddingMode, font.getSimulateStyle(), font.getEmbedAsType1());
        if (fontCache != null && !fontCache.containsFont(embedFontInfo)) {
            fontCache.addFont(embedFontInfo, this.resourceResolver);
        }
        if (log.isDebugEnabled()) {
            URI embedFile = embedFontInfo.getEmbedURI();
            log.debug("Adding font " + (embedFile != null ? embedFile + ", " : "") + "metrics URI " + embedFontInfo.getMetricsURI());
            for (FontTriplet triplet : tripletList) {
                log.debug("  Font triplet " + triplet.getName() + ", " + triplet.getStyle() + ", " + triplet.getWeight());
            }
        }
        return embedFontInfo;
    }
}

