/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;

public final class StringProperty
extends Property {
    private static final PropertyCache<StringProperty> CACHE = new PropertyCache();
    public static final StringProperty EMPTY_STRING_PROPERTY = new StringProperty("");
    private final String str;

    private StringProperty(String str2) {
        this.str = str2;
    }

    public static StringProperty getInstance(String str2) {
        if ("".equals(str2) || str2 == null) {
            return EMPTY_STRING_PROPERTY;
        }
        return CACHE.fetch(new StringProperty(str2));
    }

    @Override
    public Object getObject() {
        return this.str;
    }

    @Override
    public String getString() {
        return this.str;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StringProperty) {
            StringProperty sp = (StringProperty)obj;
            return sp.str == this.str || sp.str.equals(this.str);
        }
        return false;
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int propId) {
            super(propId);
        }

        @Override
        public Property make(PropertyList propertyList, String value, FObj fo) {
            int vlen = value.length() - 1;
            if (vlen > 0) {
                String str2;
                char q1 = value.charAt(0);
                if (q1 == '\"' || q1 == '\'') {
                    if (value.charAt(vlen) == q1) {
                        return new StringProperty(value.substring(1, vlen));
                    }
                    Property.log.warn("String-valued property starts with quote but doesn't end with quote: " + value);
                }
                if ((str2 = this.checkValueKeywords(value)) != null) {
                    value = str2;
                }
            }
            return StringProperty.getInstance(value);
        }
    }
}

