/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.extensions.svg;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.batik.anim.dom.SVG12DOMImplementation;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.DelegatingContentHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SVGDOMContentHandlerFactory
implements ContentHandlerFactory {
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();

    @Override
    public String[] getSupportedNamespaces() {
        return new String[]{"http://www.w3.org/2000/svg"};
    }

    @Override
    public ContentHandler createContentHandler() throws SAXException {
        return new Handler();
    }

    private static class Handler
    extends DelegatingContentHandler
    implements ContentHandlerFactory.ObjectSource {
        private Document doc;
        private ContentHandlerFactory.ObjectBuiltListener obListener;

        public Document getDocument() {
            return this.doc;
        }

        @Override
        public Object getObject() {
            return this.getDocument();
        }

        @Override
        public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener listener) {
            this.obListener = listener;
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.doc != null) {
                super.startDocument();
            }
        }

        private DOMImplementation getDOMImplementation(String ver) {
            if (ver == null || ver.length() == 0 || ver.equals("1.0") || ver.equals("1.1")) {
                return SVGDOMImplementation.getDOMImplementation();
            }
            if (ver.equals("1.2")) {
                return SVG12DOMImplementation.getDOMImplementation();
            }
            throw new RuntimeException("Unsupport SVG version '" + ver + "'");
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.doc == null) {
                TransformerHandler handler;
                try {
                    handler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException e2) {
                    throw new SAXException("Error creating a new TransformerHandler", e2);
                }
                String version2 = atts.getValue("version");
                DOMImplementation domImplementation = this.getDOMImplementation(version2);
                this.doc = domImplementation.createDocument(uri, qName, null);
                this.doc.removeChild(this.doc.getDocumentElement());
                handler.setResult(new DOMResult(this.doc));
                this.setDelegateContentHandler(handler);
                this.setDelegateLexicalHandler(handler);
                this.setDelegateDTDHandler(handler);
                handler.startDocument();
            }
            super.startElement(uri, localName, qName, atts);
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.obListener != null) {
                this.obListener.notifyObjectBuilt(this.getObject());
            }
        }
    }
}

