/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.xmlgraphics.util.Service;
import org.w3c.dom.DOMImplementation;
import org.xml.sax.Locator;

public class ElementMappingRegistry {
    private static final Log LOG = LogFactory.getLog(ElementMappingRegistry.class);
    protected Map<String, Map<String, ElementMapping.Maker>> fobjTable = new HashMap<String, Map<String, ElementMapping.Maker>>();
    protected Map<String, ElementMapping> namespaces = new HashMap<String, ElementMapping>();

    public ElementMappingRegistry(FopFactory factory) {
        this.setupDefaultMappings();
    }

    private void setupDefaultMappings() {
        Iterator<String> providers = Service.providerNames(ElementMapping.class);
        if (providers != null) {
            while (providers.hasNext()) {
                String mapping = providers.next();
                try {
                    this.addElementMapping(mapping);
                }
                catch (IllegalArgumentException e2) {
                    LOG.warn("Error while adding element mapping", e2);
                }
            }
        }
    }

    public void addElementMapping(String mappingClassName) throws IllegalArgumentException {
        try {
            ElementMapping mapping = (ElementMapping)Class.forName(mappingClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.addElementMapping(mapping);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Could not find " + mappingClassName);
        }
        catch (InstantiationException e3) {
            throw new IllegalArgumentException("Could not instantiate " + mappingClassName);
        }
        catch (IllegalAccessException e4) {
            throw new IllegalArgumentException("Could not access " + mappingClassName);
        }
        catch (ClassCastException e5) {
            throw new IllegalArgumentException(mappingClassName + " is not an ElementMapping");
        }
        catch (NoSuchMethodException e6) {
            throw new IllegalArgumentException(e6);
        }
        catch (InvocationTargetException e7) {
            throw new IllegalArgumentException(e7);
        }
    }

    public void addElementMapping(ElementMapping mapping) {
        this.fobjTable.put(mapping.getNamespaceURI(), mapping.getTable());
        this.namespaces.put(mapping.getNamespaceURI().intern(), mapping);
    }

    public ElementMapping.Maker findFOMaker(String namespaceURI, String localName, Locator locator) throws FOPException {
        Map<String, ElementMapping.Maker> table = this.fobjTable.get(namespaceURI);
        ElementMapping.Maker fobjMaker = null;
        if (table != null && (fobjMaker = table.get(localName)) == null) {
            fobjMaker = table.get("<default>");
        }
        if (fobjMaker == null) {
            if (this.namespaces.containsKey(namespaceURI.intern())) {
                throw new FOPException(FONode.errorText(locator) + "No element mapping definition found for " + FONode.getNodeString(namespaceURI, localName), locator);
            }
            fobjMaker = new UnknownXMLObj.Maker(namespaceURI);
        }
        return fobjMaker;
    }

    public DOMImplementation getDOMImplementationForNamespace(String namespaceURI) {
        ElementMapping mapping = this.namespaces.get(namespaceURI);
        if (mapping == null) {
            return null;
        }
        return mapping.getDOMImplementation();
    }

    public ElementMapping getElementMapping(String namespaceURI) {
        return this.namespaces.get(namespaceURI);
    }

    public boolean isKnownNamespace(String namespaceURI) {
        return this.namespaces.containsKey(namespaceURI);
    }
}

