/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiClass;
import org.apache.fop.complexscripts.bidi.BidiConstants;
import org.apache.fop.traits.Direction;
import org.apache.fop.util.CharUtilities;

public final class UnicodeBidiAlgorithm
implements BidiConstants {
    private static final Log log = LogFactory.getLog(UnicodeBidiAlgorithm.class);

    private UnicodeBidiAlgorithm() {
    }

    public static int[] resolveLevels(CharSequence cs, Direction defaultLevel) {
        int[] chars = new int[cs.length()];
        if (UnicodeBidiAlgorithm.convertToScalar(cs, chars) || defaultLevel == Direction.RL) {
            return UnicodeBidiAlgorithm.resolveLevels(chars, defaultLevel == Direction.RL ? 1 : 0, new int[chars.length]);
        }
        return null;
    }

    public static int[] resolveLevels(int[] chars, int defaultLevel, int[] levels) {
        return UnicodeBidiAlgorithm.resolveLevels(chars, UnicodeBidiAlgorithm.getClasses(chars), defaultLevel, levels, false);
    }

    public static int[] resolveLevels(int[] chars, int[] classes, int defaultLevel, int[] levels, boolean useRuleL1) {
        int[] ica = classes;
        int[] wca = UnicodeBidiAlgorithm.copySequence(ica);
        int[] ea = new int[levels.length];
        UnicodeBidiAlgorithm.resolveExplicit(wca, defaultLevel, ea);
        UnicodeBidiAlgorithm.resolveRuns(wca, defaultLevel, ea, UnicodeBidiAlgorithm.levelsFromEmbeddings(ea, levels));
        if (useRuleL1) {
            UnicodeBidiAlgorithm.resolveSeparators(ica, wca, defaultLevel, levels);
        }
        UnicodeBidiAlgorithm.dump("RL: CC(" + (chars != null ? chars.length : -1) + ")", chars, classes, defaultLevel, levels);
        return levels;
    }

    private static int[] copySequence(int[] ta) {
        int[] na = new int[ta.length];
        System.arraycopy(ta, 0, na, 0, na.length);
        return na;
    }

    private static void resolveExplicit(int[] wca, int defaultLevel, int[] ea) {
        int[] es = new int[61];
        int ei = 0;
        int ec = defaultLevel;
        for (int bc : wca) {
            int el;
            switch (bc) {
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    int en = bc == 6 || bc == 7 ? (ec & 0xFFFFFF7F) + 1 | 1 : (ec & 0xFFFFFF7F) + 2 & 0xFFFFFFFE;
                    if (en < 62) {
                        es[ei++] = ec;
                        ec = bc == 3 || bc == 7 ? en | 0x80 : en & 0xFFFFFF7F;
                    }
                    el = ec;
                    break;
                }
                case 8: {
                    el = ec;
                    if (ei <= 0) break;
                    ec = es[--ei];
                    break;
                }
                case 16: {
                    el = ec = defaultLevel;
                    ei = 0;
                    break;
                }
                default: {
                    el = ec;
                }
            }
            switch (bc) {
                case 15: {
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    wca[i] = 15;
                    break;
                }
                default: {
                    if ((el & 0x80) == 0) break;
                    wca[i] = UnicodeBidiAlgorithm.directionOfLevel(el);
                }
            }
            ea[i] = el;
        }
    }

    private static int directionOfLevel(int level) {
        return (level & 1) != 0 ? 4 : 1;
    }

    private static int levelOfEmbedding(int embedding) {
        return embedding & 0xFFFFFF7F;
    }

    private static int[] levelsFromEmbeddings(int[] ea, int[] la) {
        assert (ea != null);
        assert (la != null);
        assert (la.length == ea.length);
        int n = la.length;
        for (int i = 0; i < n; ++i) {
            la[i] = UnicodeBidiAlgorithm.levelOfEmbedding(ea[i]);
        }
        return la;
    }

    private static void resolveRuns(int[] wca, int defaultLevel, int[] ea, int[] la) {
        if (la.length != wca.length) {
            throw new IllegalArgumentException("levels sequence length must match classes sequence length");
        }
        if (la.length != ea.length) {
            throw new IllegalArgumentException("levels sequence length must match embeddings sequence length");
        }
        int i = 0;
        int n = ea.length;
        int lPrev = defaultLevel;
        while (i < n) {
            int s;
            int e2 = s = i;
            int l = UnicodeBidiAlgorithm.findNextNonRetainedFormattingLevel(wca, ea, s, lPrev);
            while (e2 < n) {
                if (la[e2] != l) {
                    if (!UnicodeBidiAlgorithm.startsWithRetainedFormattingRun(wca, ea, e2)) break;
                    e2 += UnicodeBidiAlgorithm.getLevelRunLength(ea, e2);
                    continue;
                }
                ++e2;
            }
            lPrev = UnicodeBidiAlgorithm.resolveRun(wca, defaultLevel, ea, la, s, e2, l, lPrev);
            i = e2;
        }
    }

    private static int findNextNonRetainedFormattingLevel(int[] wca, int[] ea, int start, int lPrev) {
        int s;
        int e2 = wca.length;
        for (s = start; s < e2 && UnicodeBidiAlgorithm.startsWithRetainedFormattingRun(wca, ea, s); s += UnicodeBidiAlgorithm.getLevelRunLength(ea, s)) {
        }
        if (s < e2) {
            return UnicodeBidiAlgorithm.levelOfEmbedding(ea[s]);
        }
        return lPrev;
    }

    private static int getLevelRunLength(int[] ea, int start) {
        assert (start < ea.length);
        int nl = 0;
        int e2 = ea.length;
        int l0 = UnicodeBidiAlgorithm.levelOfEmbedding(ea[start]);
        for (int s = start; s < e2 && UnicodeBidiAlgorithm.levelOfEmbedding(ea[s]) == l0; ++s) {
            ++nl;
        }
        return nl;
    }

    private static boolean startsWithRetainedFormattingRun(int[] wca, int[] ea, int start) {
        int nl = UnicodeBidiAlgorithm.getLevelRunLength(ea, start);
        if (nl > 0) {
            int nc = UnicodeBidiAlgorithm.getRetainedFormattingRunLength(wca, start);
            return nc >= nl;
        }
        return false;
    }

    private static int getRetainedFormattingRunLength(int[] wca, int start) {
        assert (start < wca.length);
        int nc = 0;
        int e2 = wca.length;
        for (int s = start; s < e2 && wca[s] == 15; ++s) {
            ++nc;
        }
        return nc;
    }

    private static int resolveRun(int[] wca, int defaultLevel, int[] ea, int[] la, int start, int end, int level, int levelPrev) {
        int sor = UnicodeBidiAlgorithm.directionOfLevel(UnicodeBidiAlgorithm.max(levelPrev, level));
        int le = -1;
        if (end == wca.length) {
            le = UnicodeBidiAlgorithm.max(level, defaultLevel);
        } else {
            for (int i = end; i < wca.length; ++i) {
                if (wca[i] == 15) continue;
                le = UnicodeBidiAlgorithm.max(level, la[i]);
                break;
            }
            if (le < 0) {
                le = UnicodeBidiAlgorithm.max(level, defaultLevel);
            }
        }
        int eor = UnicodeBidiAlgorithm.directionOfLevel(le);
        if (log.isDebugEnabled()) {
            log.debug("BR[" + UnicodeBidiAlgorithm.padLeft(start, 3) + "," + UnicodeBidiAlgorithm.padLeft(end, 3) + "] :" + UnicodeBidiAlgorithm.padLeft(level, 2) + ": SOR(" + UnicodeBidiAlgorithm.getClassName(sor) + "), EOR(" + UnicodeBidiAlgorithm.getClassName(eor) + ")");
        }
        UnicodeBidiAlgorithm.resolveWeak(wca, defaultLevel, ea, la, start, end, level, sor, eor);
        UnicodeBidiAlgorithm.resolveNeutrals(wca, defaultLevel, ea, la, start, end, level, sor, eor);
        UnicodeBidiAlgorithm.resolveImplicit(wca, defaultLevel, ea, la, start, end, level, sor, eor);
        return UnicodeBidiAlgorithm.isRetainedFormatting(wca, start, end) ? levelPrev : level;
    }

    private static void resolveWeak(int[] wca, int defaultLevel, int[] ea, int[] la, int start, int end, int level, int sor, int eor) {
        int j;
        int bcNext;
        int bc;
        int bc2;
        int i;
        int n = end;
        int bcPrev = sor;
        for (i = start; i < n; ++i) {
            bc2 = wca[i];
            if (bc2 == 14) {
                wca[i] = bcPrev;
                continue;
            }
            if (bc2 == 15) continue;
            bcPrev = bc2;
        }
        n = end;
        bcPrev = sor;
        for (i = start; i < n; ++i) {
            bc2 = wca[i];
            if (bc2 == 9) {
                if (bcPrev != 5) continue;
                wca[i] = 12;
                continue;
            }
            if (!UnicodeBidiAlgorithm.isStrong(bc2)) continue;
            bcPrev = bc2;
        }
        n = end;
        for (i = start; i < n; ++i) {
            bc = wca[i];
            if (bc != 5) continue;
            wca[i] = 4;
        }
        n = end;
        bcPrev = sor;
        for (i = start; i < n; ++i) {
            bc2 = wca[i];
            if (bc2 == 10) {
                bcNext = eor;
                for (j = i + 1; j < n; ++j) {
                    bc2 = wca[j];
                    if (bc2 == 15) continue;
                    bcNext = bc2;
                    break;
                }
                if (bcPrev == 9 && bcNext == 9) {
                    wca[i] = 9;
                }
            } else if (bc2 == 13) {
                bcNext = eor;
                for (j = i + 1; j < n; ++j) {
                    bc2 = wca[j];
                    if (bc2 == 15) continue;
                    bcNext = bc2;
                    break;
                }
                if (bcPrev == 9 && bcNext == 9) {
                    wca[i] = 9;
                } else if (bcPrev == 12 && bcNext == 12) {
                    wca[i] = 12;
                }
            }
            if (bc2 == 15) continue;
            bcPrev = bc2;
        }
        n = end;
        bcPrev = sor;
        for (i = start; i < n; ++i) {
            bc2 = wca[i];
            if (bc2 == 11) {
                bcNext = eor;
                for (j = i + 1; j < n; ++j) {
                    bc2 = wca[j];
                    if (bc2 == 15 || bc2 == 11) continue;
                    bcNext = bc2;
                    break;
                }
                if (bcPrev != 9 && bcNext != 9) continue;
                wca[i] = 9;
                continue;
            }
            if (bc2 == 15) continue;
            bcPrev = bc2;
        }
        n = end;
        for (i = start; i < n; ++i) {
            bc = wca[i];
            if (bc != 11 && bc != 10 && bc != 13) continue;
            wca[i] = 19;
            UnicodeBidiAlgorithm.resolveAdjacentBoundaryNeutrals(wca, start, end, i, 19);
        }
        n = end;
        bcPrev = sor;
        for (i = start; i < n; ++i) {
            bc2 = wca[i];
            if (bc2 == 9) {
                if (bcPrev != 1) continue;
                wca[i] = 1;
                continue;
            }
            if (bc2 != 1 && bc2 != 4) continue;
            bcPrev = bc2;
        }
    }

    private static void resolveNeutrals(int[] wca, int defaultLevel, int[] ea, int[] la, int start, int end, int level, int sor, int eor) {
        int i;
        int n = end;
        int bcPrev = sor;
        for (i = start; i < n; ++i) {
            int bc = wca[i];
            if (UnicodeBidiAlgorithm.isNeutral(bc)) {
                int bcNext = eor;
                for (int j = i + 1; j < n; ++j) {
                    bc = wca[j];
                    if (bc == 1 || bc == 4) {
                        bcNext = bc;
                        break;
                    }
                    if (bc == 12 || bc == 9) {
                        bcNext = 4;
                        break;
                    }
                    if (!UnicodeBidiAlgorithm.isNeutral(bc) && !UnicodeBidiAlgorithm.isRetainedFormatting(bc)) break;
                }
                if (bcPrev != bcNext) continue;
                wca[i] = bcPrev;
                UnicodeBidiAlgorithm.resolveAdjacentBoundaryNeutrals(wca, start, end, i, bcPrev);
                continue;
            }
            if (bc == 1 || bc == 4) {
                bcPrev = bc;
                continue;
            }
            if (bc != 12 && bc != 9) continue;
            bcPrev = 4;
        }
        n = end;
        for (i = start; i < n; ++i) {
            int bcEmbedding;
            int bc = wca[i];
            if (!UnicodeBidiAlgorithm.isNeutral(bc)) continue;
            wca[i] = bcEmbedding = UnicodeBidiAlgorithm.directionOfLevel(UnicodeBidiAlgorithm.levelOfEmbedding(ea[i]));
            UnicodeBidiAlgorithm.resolveAdjacentBoundaryNeutrals(wca, start, end, i, bcEmbedding);
        }
    }

    private static void resolveAdjacentBoundaryNeutrals(int[] wca, int start, int end, int index, int bcNew) {
        int bc;
        int i;
        if (index < start || index >= end) {
            throw new IllegalArgumentException();
        }
        for (i = index - 1; i >= start && (bc = wca[i]) == 15; --i) {
            wca[i] = bcNew;
        }
        for (i = index + 1; i < end && (bc = wca[i]) == 15; ++i) {
            wca[i] = bcNew;
        }
    }

    private static void resolveImplicit(int[] wca, int defaultLevel, int[] ea, int[] la, int start, int end, int level, int sor, int eor) {
        int n = end;
        for (int i = start; i < n; ++i) {
            int bc = wca[i];
            int el = la[i];
            int ed = 0;
            if ((el & 1) == 0) {
                if (bc == 4) {
                    ed = 1;
                } else if (bc == 12) {
                    ed = 2;
                } else if (bc == 9) {
                    ed = 2;
                }
            } else if (bc == 1) {
                ed = 1;
            } else if (bc == 9) {
                ed = 1;
            } else if (bc == 12) {
                ed = 1;
            }
            la[i] = el + ed;
        }
    }

    private static void resolveSeparators(int[] ica, int[] wca, int dl, int[] la) {
        int ic;
        int i;
        int n = ica.length;
        block0: for (i = 0; i < n; ++i) {
            ic = ica[i];
            if (ic != 17 && ic != 16) continue;
            la[i] = dl;
            for (int k = i - 1; k >= 0; --k) {
                int pc = ica[k];
                if (UnicodeBidiAlgorithm.isRetainedFormatting(pc)) continue;
                if (pc != 18) continue block0;
                la[k] = dl;
            }
        }
        for (i = ica.length; i > 0; --i) {
            int k = i - 1;
            ic = ica[k];
            if (UnicodeBidiAlgorithm.isRetainedFormatting(ic)) continue;
            if (ic != 18) break;
            la[k] = dl;
        }
        n = ica.length;
        for (i = 0; i < n; ++i) {
            ic = ica[i];
            if (!UnicodeBidiAlgorithm.isRetainedFormatting(ic)) continue;
            la[i] = i == 0 ? dl : la[i - 1];
        }
    }

    private static boolean isStrong(int bc) {
        switch (bc) {
            case 1: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNeutral(int bc) {
        switch (bc) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRetainedFormatting(int bc) {
        switch (bc) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static boolean isRetainedFormatting(int[] ca, int s, int e2) {
        for (int i = s; i < e2; ++i) {
            if (UnicodeBidiAlgorithm.isRetainedFormatting(ca[i])) continue;
            return false;
        }
        return true;
    }

    private static int max(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    private static int[] getClasses(int[] chars) {
        int[] classes = new int[chars.length];
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            int ch = chars[i];
            int bc = ch >= 0 ? BidiClass.getBidiClass(chars[i]) : 20;
            classes[i] = bc;
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean convertToScalar(CharSequence cs, int[] chars) throws IllegalArgumentException {
        boolean triggered = false;
        if (chars.length != cs.length()) {
            throw new IllegalArgumentException("characters array length must match input sequence length");
        }
        int i = 0;
        int n = chars.length;
        while (i < n) {
            int chOut;
            int chIn = cs.charAt(i);
            if (chIn < 55296) {
                chOut = chIn;
            } else if (chIn < 56320) {
                int chHi = chIn;
                if (i + 1 >= n) throw new IllegalArgumentException("truncated surrogate pair");
                char chLo = cs.charAt(i + 1);
                if (chLo < '\udc00' || chLo > '\udfff') throw new IllegalArgumentException("isolated high surrogate");
                chOut = UnicodeBidiAlgorithm.convertToScalar(chHi, chLo);
            } else {
                if (chIn < 57344) {
                    throw new IllegalArgumentException("isolated low surrogate");
                }
                chOut = chIn;
            }
            if (!triggered && UnicodeBidiAlgorithm.triggersBidi(chOut)) {
                triggered = true;
            }
            if ((chOut & 0xFF0000) == 0) {
                chars[i++] = chOut;
                continue;
            }
            chars[i++] = chOut;
            chars[i++] = -1;
        }
        return triggered;
    }

    private static int convertToScalar(int chHi, int chLo) {
        if (chHi < 55296 || chHi > 56319) {
            throw new IllegalArgumentException("bad high surrogate");
        }
        if (chLo < 56320 || chLo > 57343) {
            throw new IllegalArgumentException("bad low surrogate");
        }
        return ((chHi & 0x3FF) << 10 | chLo & 0x3FF) + 65536;
    }

    private static boolean triggersBidi(int ch) {
        switch (BidiClass.getBidiClass(ch)) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private static void dump(String header, int[] chars, int[] classes, int defaultLevel, int[] levels) {
        log.debug(header);
        log.debug("BD: default level(" + defaultLevel + ")");
        StringBuffer sb = new StringBuffer();
        if (chars != null) {
            int n = chars.length;
            for (int i = 0; i < n; ++i) {
                int ch = chars[i];
                sb.setLength(0);
                if (ch > 32 && ch < 127) {
                    sb.append((char)ch);
                } else {
                    sb.append(CharUtilities.charToNCRef(ch));
                }
                for (int k = sb.length(); k < 12; ++k) {
                    sb.append(' ');
                }
                sb.append(": " + UnicodeBidiAlgorithm.padRight(UnicodeBidiAlgorithm.getClassName(classes[i]), 4) + " " + levels[i]);
                log.debug(sb);
            }
        } else {
            int n = classes.length;
            for (int i = 0; i < n; ++i) {
                sb.setLength(0);
                for (int k = sb.length(); k < 12; ++k) {
                    sb.append(' ');
                }
                sb.append(": " + UnicodeBidiAlgorithm.padRight(UnicodeBidiAlgorithm.getClassName(classes[i]), 4) + " " + levels[i]);
                log.debug(sb);
            }
        }
    }

    private static String getClassName(int bc) {
        switch (bc) {
            case 1: {
                return "L";
            }
            case 2: {
                return "LRE";
            }
            case 3: {
                return "LRO";
            }
            case 4: {
                return "R";
            }
            case 5: {
                return "AL";
            }
            case 6: {
                return "RLE";
            }
            case 7: {
                return "RLO";
            }
            case 8: {
                return "PDF";
            }
            case 9: {
                return "EN";
            }
            case 10: {
                return "ES";
            }
            case 11: {
                return "ET";
            }
            case 12: {
                return "AN";
            }
            case 13: {
                return "CS";
            }
            case 14: {
                return "NSM";
            }
            case 15: {
                return "BN";
            }
            case 16: {
                return "B";
            }
            case 17: {
                return "S";
            }
            case 18: {
                return "WS";
            }
            case 19: {
                return "ON";
            }
            case 20: {
                return "SUR";
            }
        }
        return "?";
    }

    private static String padLeft(int n, int width) {
        return UnicodeBidiAlgorithm.padLeft(Integer.toString(n), width);
    }

    private static String padLeft(String s, int width) {
        StringBuffer sb = new StringBuffer();
        for (int i = s.length(); i < width; ++i) {
            sb.append(' ');
        }
        sb.append(s);
        return sb.toString();
    }

    private static String padRight(String s, int width) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = sb.length(); i < width; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

