/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.HaltingThread;
import org.w3c.dom.svg.SVGDocument;

public class GVTTreeBuilder
extends HaltingThread {
    protected SVGDocument svgDocument;
    protected BridgeContext bridgeContext;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildStarted((GVTTreeBuilderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildCompleted((GVTTreeBuilderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildCancelled((GVTTreeBuilderEvent)event);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object listener, Object event) {
            ((GVTTreeBuilderListener)listener).gvtBuildFailed((GVTTreeBuilderEvent)event);
        }
    };

    public GVTTreeBuilder(SVGDocument doc, BridgeContext bc) {
        this.svgDocument = doc;
        this.bridgeContext = bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        GVTTreeBuilderEvent ev = new GVTTreeBuilderEvent(this, null);
        try {
            this.fireEvent(startedDispatcher, ev);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, ev);
                return;
            }
            GVTBuilder builder = null;
            builder = this.bridgeContext.isDynamic() ? new DynamicGVTBuilder() : new GVTBuilder();
            GraphicsNode gvtRoot = builder.build(this.bridgeContext, this.svgDocument);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, ev);
                return;
            }
            ev = new GVTTreeBuilderEvent(this, gvtRoot);
            this.fireEvent(completedDispatcher, ev);
        }
        catch (InterruptedBridgeException e2) {
            this.fireEvent(cancelledDispatcher, ev);
        }
        catch (BridgeException e3) {
            this.exception = e3;
            ev = new GVTTreeBuilderEvent(this, e3.getGraphicsNode());
            this.fireEvent(failedDispatcher, ev);
        }
        catch (Exception e4) {
            this.exception = e4;
            this.fireEvent(failedDispatcher, ev);
        }
        catch (ThreadDeath td) {
            this.exception = new Exception(td.getMessage());
            this.fireEvent(failedDispatcher, ev);
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.exception = new Exception(t.getMessage());
            this.fireEvent(failedDispatcher, ev);
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public void addGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.listeners.add(l);
    }

    public void removeGVTTreeBuilderListener(GVTTreeBuilderListener l) {
        this.listeners.remove(l);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object event) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, event, true);
    }
}

