/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public class AbstractRotateInteractor
extends InteractorAdapter {
    protected boolean finished;
    protected double initialRotation;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.finished = false;
        JGVTComponent c = (JGVTComponent)e2.getSource();
        Dimension d = c.getSize();
        double dx = e2.getX() - d.width / 2;
        double dy = e2.getY() - d.height / 2;
        double cos = -dy / Math.sqrt(dx * dx + dy * dy);
        this.initialRotation = dx > 0.0 ? Math.acos(cos) : -Math.acos(cos);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.finished = true;
        JGVTComponent c = (JGVTComponent)e2.getSource();
        AffineTransform at = this.rotateTransform(c.getSize(), e2.getX(), e2.getY());
        at.concatenate(c.getRenderingTransform());
        c.setRenderingTransform(at);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.finished = true;
        JGVTComponent c = (JGVTComponent)e2.getSource();
        c.setPaintingTransform(null);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        JGVTComponent c = (JGVTComponent)e2.getSource();
        c.setPaintingTransform(this.rotateTransform(c.getSize(), e2.getX(), e2.getY()));
    }

    protected AffineTransform rotateTransform(Dimension d, int x, int y) {
        double dx = x - d.width / 2;
        double dy = y - d.height / 2;
        double cos = -dy / Math.sqrt(dx * dx + dy * dy);
        double angle = dx > 0.0 ? Math.acos(cos) : -Math.acos(cos);
        return AffineTransform.getRotateInstance(angle -= this.initialRotation, d.width / 2, d.height / 2);
    }
}

