/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class AWTGlyphGeometryCache {
    protected static final int INITIAL_CAPACITY = 71;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue referenceQueue = new ReferenceQueue();

    public AWTGlyphGeometryCache() {
        this.table = new Entry[71];
    }

    public AWTGlyphGeometryCache(int c) {
        this.table = new Entry[c];
    }

    public int size() {
        return this.count;
    }

    public Value get(char c) {
        int hash = this.hashCode(c) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.match(c)) {
                return (Value)e2.get();
            }
            e2 = e2.next;
        }
        return null;
    }

    public Value put(char c, Value value) {
        int len;
        this.removeClearedEntries();
        int hash = this.hashCode(c) & Integer.MAX_VALUE;
        int index = hash % this.table.length;
        Entry e2 = this.table[index];
        if (e2 != null) {
            if (e2.hash == hash && e2.match(c)) {
                Object old = e2.get();
                this.table[index] = new Entry(hash, c, value, e2.next);
                return (Value)old;
            }
            Entry o = e2;
            e2 = e2.next;
            while (e2 != null) {
                if (e2.hash == hash && e2.match(c)) {
                    Object old = e2.get();
                    o.next = e2 = new Entry(hash, c, value, e2.next);
                    return (Value)old;
                }
                o = e2;
                e2 = e2.next;
            }
        }
        if (this.count++ >= (len = this.table.length) - (len >> 2)) {
            this.rehash();
            index = hash % this.table.length;
        }
        this.table[index] = new Entry(hash, c, value, this.table[index]);
        return null;
    }

    public void clear() {
        this.table = new Entry[71];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = e2.hash % this.table.length;
                e2.next = this.table[index];
                this.table[index] = e2;
            }
        }
    }

    protected int hashCode(char c) {
        return c;
    }

    protected void removeClearedEntries() {
        Entry e2;
        while ((e2 = (Entry)this.referenceQueue.poll()) != null) {
            int index = e2.hash % this.table.length;
            Entry t = this.table[index];
            if (t == e2) {
                this.table[index] = e2.next;
            } else {
                while (t != null) {
                    Entry c = t.next;
                    if (c == e2) {
                        t.next = e2.next;
                        break;
                    }
                    t = c;
                }
            }
            --this.count;
        }
    }

    protected class Entry
    extends SoftReference {
        public int hash;
        public char c;
        public Entry next;

        public Entry(int hash, char c, Value value, Entry next) {
            super(value, AWTGlyphGeometryCache.this.referenceQueue);
            this.hash = hash;
            this.c = c;
            this.next = next;
        }

        public boolean match(char o2) {
            return this.c == o2;
        }
    }

    public static class Value {
        protected Shape outline;
        protected Rectangle2D gmB;
        protected Rectangle2D outlineBounds;

        public Value(Shape outline, Rectangle2D gmB) {
            this.outline = outline;
            this.outlineBounds = outline.getBounds2D();
            this.gmB = gmB;
        }

        public Shape getOutline() {
            return this.outline;
        }

        public Rectangle2D getBounds2D() {
            return this.gmB;
        }

        public Rectangle2D getOutlineBounds2D() {
            return this.outlineBounds;
        }
    }
}

