/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import org.apache.batik.anim.dom.SVGOMAnimatedRect;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.batik.parser.FragmentIdentifierHandler;
import org.apache.batik.parser.FragmentIdentifierParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGPreserveAspectRatio;
import org.w3c.dom.svg.SVGRect;

public abstract class ViewBox
implements SVGConstants,
ErrorConstants {
    protected ViewBox() {
    }

    public static AffineTransform getViewTransform(String ref, Element e2, float w, float h, BridgeContext ctx) {
        boolean meet;
        short align;
        float[] vb;
        if (ref == null || ref.length() == 0) {
            return ViewBox.getPreserveAspectRatioTransform(e2, w, h, ctx);
        }
        ViewHandler vh = new ViewHandler();
        FragmentIdentifierParser p = new FragmentIdentifierParser();
        p.setFragmentIdentifierHandler(vh);
        p.parse(ref);
        Element viewElement = e2;
        if (vh.hasId) {
            Document document = e2.getOwnerDocument();
            viewElement = document.getElementById(vh.id);
        }
        if (viewElement == null) {
            throw new BridgeException(ctx, e2, "uri.malformed", new Object[]{ref});
        }
        Element ancestorSVG = ViewBox.getClosestAncestorSVGElement(e2);
        if (!viewElement.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !viewElement.getLocalName().equals("view")) {
            viewElement = ancestorSVG;
        }
        if (vh.hasViewBox) {
            vb = vh.viewBox;
        } else {
            Element elt = DOMUtilities.isAttributeSpecifiedNS(viewElement, null, "viewBox") ? viewElement : ancestorSVG;
            String viewBoxStr = elt.getAttributeNS(null, "viewBox");
            vb = ViewBox.parseViewBoxAttribute(elt, viewBoxStr, ctx);
        }
        if (vh.hasPreserveAspectRatio) {
            align = vh.align;
            meet = vh.meet;
        } else {
            Element elt = DOMUtilities.isAttributeSpecifiedNS(viewElement, null, "preserveAspectRatio") ? viewElement : ancestorSVG;
            String aspectRatio = elt.getAttributeNS(null, "preserveAspectRatio");
            PreserveAspectRatioParser pp = new PreserveAspectRatioParser();
            ViewHandler ph = new ViewHandler();
            pp.setPreserveAspectRatioHandler(ph);
            try {
                pp.parse(aspectRatio);
            }
            catch (ParseException pEx) {
                throw new BridgeException(ctx, elt, pEx, "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, pEx});
            }
            align = ph.align;
            meet = ph.meet;
        }
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform(vb, align, meet, w, h);
        if (vh.hasTransform) {
            transform.concatenate(vh.getAffineTransform());
        }
        return transform;
    }

    private static Element getClosestAncestorSVGElement(Element e2) {
        for (Node n = e2; n != null && n.getNodeType() == 1; n = n.getParentNode()) {
            Element tmp = n;
            if (!tmp.getNamespaceURI().equals("http://www.w3.org/2000/svg") || !tmp.getLocalName().equals("svg")) continue;
            return tmp;
        }
        return null;
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e2, float w, float h) {
        return ViewBox.getPreserveAspectRatioTransform(e2, w, h, null);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e2, float w, float h, BridgeContext ctx) {
        String viewBox = e2.getAttributeNS(null, "viewBox");
        String aspectRatio = e2.getAttributeNS(null, "preserveAspectRatio");
        return ViewBox.getPreserveAspectRatioTransform(e2, viewBox, aspectRatio, w, h, ctx);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e2, String viewBox, String aspectRatio, float w, float h, BridgeContext ctx) {
        if (viewBox.length() == 0) {
            return new AffineTransform();
        }
        float[] vb = ViewBox.parseViewBoxAttribute(e2, viewBox, ctx);
        PreserveAspectRatioParser p = new PreserveAspectRatioParser();
        ViewHandler ph = new ViewHandler();
        p.setPreserveAspectRatioHandler(ph);
        try {
            p.parse(aspectRatio);
        }
        catch (ParseException pEx) {
            throw new BridgeException(ctx, e2, pEx, "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, pEx});
        }
        return ViewBox.getPreserveAspectRatioTransform(vb, ph.align, ph.meet, w, h);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e2, float[] vb, float w, float h, BridgeContext ctx) {
        String aspectRatio = e2.getAttributeNS(null, "preserveAspectRatio");
        PreserveAspectRatioParser p = new PreserveAspectRatioParser();
        ViewHandler ph = new ViewHandler();
        p.setPreserveAspectRatioHandler(ph);
        try {
            p.parse(aspectRatio);
        }
        catch (ParseException pEx) {
            throw new BridgeException(ctx, e2, pEx, "attribute.malformed", new Object[]{"preserveAspectRatio", aspectRatio, pEx});
        }
        return ViewBox.getPreserveAspectRatioTransform(vb, ph.align, ph.meet, w, h);
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e2, float[] vb, float w, float h, SVGAnimatedPreserveAspectRatio aPAR, BridgeContext ctx) {
        try {
            SVGPreserveAspectRatio pAR = aPAR.getAnimVal();
            short align = pAR.getAlign();
            boolean meet = pAR.getMeetOrSlice() == 1;
            return ViewBox.getPreserveAspectRatioTransform(vb, align, meet, w, h);
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    public static AffineTransform getPreserveAspectRatioTransform(Element e2, SVGAnimatedRect aViewBox, SVGAnimatedPreserveAspectRatio aPAR, float w, float h, BridgeContext ctx) {
        if (!((SVGOMAnimatedRect)aViewBox).isSpecified()) {
            return new AffineTransform();
        }
        SVGRect viewBox = aViewBox.getAnimVal();
        float[] vb = new float[]{viewBox.getX(), viewBox.getY(), viewBox.getWidth(), viewBox.getHeight()};
        return ViewBox.getPreserveAspectRatioTransform(e2, vb, w, h, aPAR, ctx);
    }

    public static float[] parseViewBoxAttribute(Element e2, String value, BridgeContext ctx) {
        int i;
        if (value.length() == 0) {
            return null;
        }
        float[] vb = new float[4];
        StringTokenizer st = new StringTokenizer(value, " ,");
        try {
            for (i = 0; i < 4 && st.hasMoreTokens(); ++i) {
                vb[i] = Float.parseFloat(st.nextToken());
            }
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, e2, nfEx, "attribute.malformed", new Object[]{"viewBox", value, nfEx});
        }
        if (i != 4) {
            throw new BridgeException(ctx, e2, "attribute.malformed", new Object[]{"viewBox", value});
        }
        if (vb[2] < 0.0f || vb[3] < 0.0f) {
            throw new BridgeException(ctx, e2, "attribute.malformed", new Object[]{"viewBox", value});
        }
        if (vb[2] == 0.0f || vb[3] == 0.0f) {
            return null;
        }
        return vb;
    }

    public static AffineTransform getPreserveAspectRatioTransform(float[] vb, short align, boolean meet, float w, float h) {
        if (vb == null) {
            return new AffineTransform();
        }
        AffineTransform result = new AffineTransform();
        float vpar = vb[2] / vb[3];
        float svgar = w / h;
        if (align == 1) {
            result.scale(w / vb[2], h / vb[3]);
            result.translate(-vb[0], -vb[1]);
        } else if (vpar < svgar && meet || vpar >= svgar && !meet) {
            float sf = h / vb[3];
            result.scale(sf, sf);
            switch (align) {
                case 2: 
                case 5: 
                case 8: {
                    result.translate(-vb[0], -vb[1]);
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    result.translate(-vb[0] - (vb[2] - w * vb[3] / h) / 2.0f, -vb[1]);
                    break;
                }
                default: {
                    result.translate(-vb[0] - (vb[2] - w * vb[3] / h), -vb[1]);
                    break;
                }
            }
        } else {
            float sf = w / vb[2];
            result.scale(sf, sf);
            switch (align) {
                case 2: 
                case 3: 
                case 4: {
                    result.translate(-vb[0], -vb[1]);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    result.translate(-vb[0], -vb[1] - (vb[3] - h * vb[2] / w) / 2.0f);
                    break;
                }
                default: {
                    result.translate(-vb[0], -vb[1] - (vb[3] - h * vb[2] / w));
                }
            }
        }
        return result;
    }

    protected static class ViewHandler
    extends AWTTransformProducer
    implements FragmentIdentifierHandler {
        public boolean hasTransform;
        public boolean hasId;
        public boolean hasViewBox;
        public boolean hasViewTargetParams;
        public boolean hasZoomAndPanParams;
        public String id;
        public float[] viewBox;
        public String viewTargetParams;
        public boolean isMagnify;
        public boolean hasPreserveAspectRatio;
        public short align;
        public boolean meet = true;

        protected ViewHandler() {
        }

        @Override
        public void endTransformList() throws ParseException {
            super.endTransformList();
            this.hasTransform = true;
        }

        @Override
        public void startFragmentIdentifier() throws ParseException {
        }

        @Override
        public void idReference(String s) throws ParseException {
            this.id = s;
            this.hasId = true;
        }

        @Override
        public void viewBox(float x, float y, float width, float height) throws ParseException {
            this.hasViewBox = true;
            this.viewBox = new float[4];
            this.viewBox[0] = x;
            this.viewBox[1] = y;
            this.viewBox[2] = width;
            this.viewBox[3] = height;
        }

        @Override
        public void startViewTarget() throws ParseException {
        }

        @Override
        public void viewTarget(String name) throws ParseException {
            this.viewTargetParams = name;
            this.hasViewTargetParams = true;
        }

        @Override
        public void endViewTarget() throws ParseException {
        }

        @Override
        public void zoomAndPan(boolean magnify) {
            this.isMagnify = magnify;
            this.hasZoomAndPanParams = true;
        }

        @Override
        public void endFragmentIdentifier() throws ParseException {
        }

        @Override
        public void startPreserveAspectRatio() throws ParseException {
        }

        @Override
        public void none() throws ParseException {
            this.align = 1;
        }

        @Override
        public void xMaxYMax() throws ParseException {
            this.align = (short)10;
        }

        @Override
        public void xMaxYMid() throws ParseException {
            this.align = (short)7;
        }

        @Override
        public void xMaxYMin() throws ParseException {
            this.align = (short)4;
        }

        @Override
        public void xMidYMax() throws ParseException {
            this.align = (short)9;
        }

        @Override
        public void xMidYMid() throws ParseException {
            this.align = (short)6;
        }

        @Override
        public void xMidYMin() throws ParseException {
            this.align = (short)3;
        }

        @Override
        public void xMinYMax() throws ParseException {
            this.align = (short)8;
        }

        @Override
        public void xMinYMid() throws ParseException {
            this.align = (short)5;
        }

        @Override
        public void xMinYMin() throws ParseException {
            this.align = (short)2;
        }

        @Override
        public void meet() throws ParseException {
            this.meet = true;
        }

        @Override
        public void slice() throws ParseException {
            this.meet = false;
        }

        @Override
        public void endPreserveAspectRatio() throws ParseException {
            this.hasPreserveAspectRatio = true;
        }
    }
}

