/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa.literal;

import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.rootdev.javardfa.Parser;
import net.rootdev.javardfa.literal.CanonicalXMLEventWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralCollector {
    final String XMLLiteral = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
    private final Stack<Collector> collectors;
    private List<XMLEvent> queuedEvents;
    private int level;
    private final Parser parser;
    private final StartElement fakeEnvelope;
    private final XMLEventFactory eventFactory;
    private final XMLOutputFactory outputFactory;

    public LiteralCollector(Parser parser, XMLEventFactory eventFactory, XMLOutputFactory outputFactory) {
        this.parser = parser;
        this.collectors = new Stack();
        this.queuedEvents = null;
        this.eventFactory = eventFactory;
        this.outputFactory = outputFactory;
        this.fakeEnvelope = eventFactory.createStartElement("", "", "fake");
    }

    public boolean isCollecting() {
        return !this.collectors.isEmpty();
    }

    public boolean isCollectingXML() {
        if (!this.isCollecting()) {
            return false;
        }
        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(this.collectors.peek().datatype);
    }

    public void collect(String subject, Collection<String> props, String datatype, String lang) {
        if (!this.isCollecting()) {
            this.queuedEvents = new LinkedList<XMLEvent>();
            this.level = 0;
        }
        Collector coll = new Collector(subject, props, datatype, lang, this.level, this.queuedEvents.size());
        this.collectors.push(coll);
    }

    public void handleEvent(XMLEvent event) {
        if (!this.isCollecting()) {
            return;
        }
        if (event.isStartElement()) {
            this.handleStartEvent(event);
        } else if (event.isEndElement()) {
            this.handleEndEvent(event);
        } else {
            this.queuedEvents.add(event);
        }
    }

    private void handleStartEvent(XMLEvent event) {
        ++this.level;
        this.queuedEvents.add(event);
        if (this.collectors.peek().datatype == null) {
            this.collectors.peek().datatype = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral";
        }
    }

    private void handleEndEvent(XMLEvent event) {
        this.queuedEvents.add(event);
        if (this.collectors.peek().level == this.level) {
            Collector coll = this.collectors.pop();
            this.emitTriples(coll, this.queuedEvents.subList(coll.start, this.queuedEvents.size()));
        }
        --this.level;
    }

    private void emitTriples(Collector coll, List<XMLEvent> subList) {
        String lex;
        String string = lex = "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(coll.datatype) ? this.gatherXML(subList, coll.lang) : this.gatherText(subList);
        if (coll.datatype != null && !"".equals(coll.datatype)) {
            this.parser.emitTriplesDatatypeLiteral(coll.subject, coll.props, lex, coll.datatype);
        } else {
            this.parser.emitTriplesPlainLiteral(coll.subject, coll.props, lex, coll.lang);
        }
    }

    private String gatherXML(List<XMLEvent> subList, String lang) {
        try {
            return this.gatherXMLEx(subList, lang);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Problem gathering XML", ex);
        }
    }

    private String gatherXMLEx(List<XMLEvent> subList, String lang) throws XMLStreamException {
        Attribute xmlLang = lang == null ? null : this.eventFactory.createAttribute("xml:lang", lang);
        StringWriter sw = new StringWriter();
        XMLStreamWriter out = this.outputFactory.createXMLStreamWriter(sw);
        CanonicalXMLEventWriter xmlWriter = new CanonicalXMLEventWriter(out, xmlLang);
        xmlWriter.add(this.fakeEnvelope);
        for (XMLEvent e2 : subList) {
            xmlWriter.add(e2);
        }
        xmlWriter.flush();
        String xml = sw.toString();
        int start = xml.indexOf(62) + 1;
        int end = xml.lastIndexOf(60);
        return xml.substring(start, end);
    }

    private String gatherText(List<XMLEvent> subList) {
        StringBuilder sb = new StringBuilder();
        for (XMLEvent e2 : subList) {
            if (!e2.isCharacters()) continue;
            sb.append(e2.asCharacters().getData());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Collector {
        private final String subject;
        private final Collection<String> props;
        private String datatype;
        private final String lang;
        private final int level;
        private final int start;

        private Collector(String subject, Collection<String> props, String datatype, String lang, int level, int start) {
            this.subject = subject;
            this.props = props;
            this.datatype = datatype;
            this.lang = lang;
            this.level = level;
            this.start = start;
        }
    }
}

