/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.parser;

import com.sun.xml.xsom.impl.parser.Messages;
import com.sun.xml.xsom.parser.XMLParser;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXPParser
implements XMLParser {
    private static final String ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    private static final Logger LOGGER = Logger.getLogger(JAXPParser.class.getName());
    private final SAXParserFactory factory;

    public JAXPParser(SAXParserFactory factory) {
        factory.setNamespaceAware(true);
        this.factory = factory;
    }

    public JAXPParser() {
        this(SAXParserFactory.newInstance());
    }

    @Override
    public void parse(InputSource source, ContentHandler handler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
        try {
            SAXParser saxParser = JAXPParser.allowFileAccess(this.factory.newSAXParser(), false);
            XMLReaderEx reader = new XMLReaderEx(saxParser.getXMLReader());
            reader.setContentHandler(handler);
            if (errorHandler != null) {
                reader.setErrorHandler(errorHandler);
            }
            if (entityResolver != null) {
                reader.setEntityResolver(entityResolver);
            }
            reader.parse(source);
        }
        catch (ParserConfigurationException e2) {
            SAXParseException spe = new SAXParseException(e2.getMessage(), null, e2);
            errorHandler.fatalError(spe);
            throw spe;
        }
    }

    private static SAXParser allowFileAccess(SAXParser saxParser, boolean disableSecureProcessing) throws SAXException {
        if (disableSecureProcessing) {
            return saxParser;
        }
        try {
            saxParser.setProperty(ACCESS_EXTERNAL_SCHEMA, "file");
            LOGGER.log(Level.FINE, Messages.format("JAXPSupportedProperty", ACCESS_EXTERNAL_SCHEMA));
        }
        catch (SAXException ignored) {
            LOGGER.log(Level.CONFIG, Messages.format("JAXPUnsupportedProperty", ACCESS_EXTERNAL_SCHEMA), ignored);
        }
        return saxParser;
    }

    private static class XMLReaderEx
    extends XMLFilterImpl {
        private Locator locator;

        XMLReaderEx(XMLReader parent) {
            this.setParent(parent);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            try {
                InputSource is = null;
                if (this.getEntityResolver() != null) {
                    is = this.getEntityResolver().resolveEntity(publicId, systemId);
                }
                if (is != null) {
                    return is;
                }
                is = new InputSource(new URL(systemId).openStream());
                is.setSystemId(systemId);
                is.setPublicId(publicId);
                return is;
            }
            catch (IOException e2) {
                SAXParseException spe = new SAXParseException(Messages.format("EntityResolutionFailure", systemId, e2.toString()), this.locator, e2);
                if (this.getErrorHandler() != null) {
                    this.getErrorHandler().fatalError(spe);
                }
                throw spe;
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }
    }
}

