/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class Ring {
    private final Map<Class, Object> components = new HashMap<Class, Object>();
    private static final ThreadLocal<Ring> instances = new ThreadLocal();

    private Ring() {
    }

    public static <T> void add(Class<T> clazz, T instance) {
        assert (!Ring.get().components.containsKey(clazz));
        Ring.get().components.put(clazz, instance);
    }

    public static <T> void add(T o) {
        Ring.add(o.getClass(), o);
    }

    public static <T> T get(Class<T> key) {
        Object t = Ring.get().components.get(key);
        if (t == null) {
            try {
                Constructor<T> c = key.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                t = c.newInstance(new Object[0]);
                if (!Ring.get().components.containsKey(key)) {
                    Ring.add(key, t);
                }
            }
            catch (InstantiationException e2) {
                throw new Error(e2);
            }
            catch (IllegalAccessException e3) {
                throw new Error(e3);
            }
            catch (NoSuchMethodException e4) {
                throw new Error(e4);
            }
            catch (InvocationTargetException e5) {
                throw new Error(e5);
            }
        }
        assert (t != null);
        return (T)t;
    }

    public static Ring get() {
        return instances.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ring begin() {
        Ring r = null;
        ThreadLocal<Ring> threadLocal = instances;
        synchronized (threadLocal) {
            r = instances.get();
            instances.set(new Ring());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(Ring old) {
        ThreadLocal<Ring> threadLocal = instances;
        synchronized (threadLocal) {
            instances.remove();
            instances.set(old);
        }
    }
}

