/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.api.impl.s2j;

import com.sun.codemodel.JCodeModel;
import com.sun.istack.NotNull;
import com.sun.istack.SAXParseException2;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.ModelLoader;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.SpecVersion;
import com.sun.tools.xjc.api.impl.s2j.DowngradingErrorHandler;
import com.sun.tools.xjc.api.impl.s2j.JAXBModelImpl;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.internalizer.DOMForest;
import com.sun.tools.xjc.reader.internalizer.SCDBasedBindingSet;
import com.sun.tools.xjc.reader.xmlschema.parser.LSInputSAXWrapper;
import com.sun.tools.xjc.reader.xmlschema.parser.XMLSchemaInternalizationLogic;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.v2.util.XmlFactory;
import com.sun.xml.xsom.XSSchemaSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public final class SchemaCompilerImpl
extends ErrorReceiver
implements SchemaCompiler {
    private ErrorListener errorListener;
    protected final Options opts = new Options();
    @NotNull
    protected DOMForest forest;
    private boolean hadError;
    private static boolean NO_CORRECTNESS_CHECK = false;

    public SchemaCompilerImpl() {
        this.opts.compatibilityMode = 2;
        this.resetSchema();
        if (System.getProperty("xjc-api.test") != null) {
            this.opts.debugMode = true;
            this.opts.verbose = true;
        }
    }

    @Override
    @NotNull
    public Options getOptions() {
        return this.opts;
    }

    @Override
    public ContentHandler getParserHandler(String systemId) {
        return this.forest.getParserHandler(systemId, true);
    }

    @Override
    public void parseSchema(String systemId, Element element) {
        this.checkAbsoluteness(systemId);
        try {
            DOMScanner scanner = new DOMScanner();
            LocatorImpl loc = new LocatorImpl();
            loc.setSystemId(systemId);
            scanner.setLocator(loc);
            scanner.setContentHandler(this.getParserHandler(systemId));
            scanner.scan(element);
        }
        catch (SAXException e2) {
            this.fatalError(new SAXParseException2(e2.getMessage(), null, systemId, -1, -1, e2));
        }
    }

    @Override
    public void parseSchema(InputSource source) {
        this.checkAbsoluteness(source.getSystemId());
        try {
            this.forest.parse(source, true);
        }
        catch (SAXException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void setTargetVersion(SpecVersion version2) {
        if (version2 == null) {
            version2 = SpecVersion.LATEST;
        }
        this.opts.target = version2;
    }

    @Override
    public void parseSchema(String systemId, XMLStreamReader reader) throws XMLStreamException {
        this.checkAbsoluteness(systemId);
        this.forest.parse(systemId, reader, true);
    }

    private void checkAbsoluteness(String systemId) {
        try {
            new URL(systemId);
        }
        catch (MalformedURLException mue) {
            try {
                new URI(systemId);
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException("system ID '" + systemId + "' isn't absolute", e2);
            }
        }
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.forest.setEntityResolver(entityResolver);
        this.opts.entityResolver = entityResolver;
    }

    @Override
    public void setDefaultPackageName(String packageName) {
        this.opts.defaultPackage2 = packageName;
    }

    @Override
    public void forcePackageName(String packageName) {
        this.opts.defaultPackage = packageName;
    }

    @Override
    public void setClassNameAllocator(ClassNameAllocator allocator) {
        this.opts.classNameAllocator = allocator;
    }

    @Override
    public void resetSchema() {
        this.forest = new DOMForest(new XMLSchemaInternalizationLogic(), this.opts);
        this.forest.setErrorHandler(this);
        this.forest.setEntityResolver(this.opts.entityResolver);
    }

    @Override
    public JAXBModelImpl bind() {
        for (InputSource is : this.opts.getBindFiles()) {
            this.parseSchema(is);
        }
        SCDBasedBindingSet scdBasedBindingSet = this.forest.transform(this.opts.isExtensionMode());
        if (!NO_CORRECTNESS_CHECK) {
            SchemaFactory sf = XmlFactory.createSchemaFactory("http://www.w3.org/2001/XMLSchema", this.opts.disableXmlSecurity);
            if (this.opts.entityResolver != null) {
                sf.setResourceResolver(new LSResourceResolver(){

                    @Override
                    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                        try {
                            InputSource is = SchemaCompilerImpl.this.opts.entityResolver.resolveEntity(namespaceURI, systemId);
                            if (is == null) {
                                return null;
                            }
                            return new LSInputSAXWrapper(is);
                        }
                        catch (SAXException e2) {
                            return null;
                        }
                        catch (IOException e3) {
                            return null;
                        }
                    }
                });
            }
            sf.setErrorHandler(new DowngradingErrorHandler(this));
            this.forest.weakSchemaCorrectnessCheck(sf);
            if (this.hadError) {
                return null;
            }
        }
        JCodeModel codeModel = new JCodeModel();
        ModelLoader gl = new ModelLoader(this.opts, codeModel, this);
        try {
            XSSchemaSet result = gl.createXSOM(this.forest, scdBasedBindingSet);
            if (result == null) {
                return null;
            }
            Model model = gl.annotateXMLSchema(result);
            if (model == null) {
                return null;
            }
            if (this.hadError) {
                return null;
            }
            model.setPackageLevelAnnotations(this.opts.packageLevelAnnotations);
            Outline context = model.generateCode(this.opts, this);
            if (context == null) {
                return null;
            }
            if (this.hadError) {
                return null;
            }
            return new JAXBModelImpl(context);
        }
        catch (SAXException e2) {
            return null;
        }
    }

    @Override
    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    @Override
    public void info(SAXParseException exception) {
        if (this.errorListener != null) {
            this.errorListener.info(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) {
        if (this.errorListener != null) {
            this.errorListener.warning(exception);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        this.hadError = true;
        if (this.errorListener != null) {
            this.errorListener.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
        this.hadError = true;
        if (this.errorListener != null) {
            this.errorListener.fatalError(exception);
        }
    }

    static {
        try {
            NO_CORRECTNESS_CHECK = Boolean.getBoolean(SchemaCompilerImpl.class.getName() + ".noCorrectnessCheck");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

