/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.episode;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.v2.schemagen.episode.Bindings;
import com.sun.xml.bind.v2.schemagen.episode.SchemaBindings;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSFunction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluginImpl
extends Plugin {
    private File episodeFile;
    private static final XSFunction<String> SCD = new XSFunction<String>(){

        private String name(XSDeclaration decl) {
            if (decl.getTargetNamespace().equals("")) {
                return decl.getName();
            }
            return "tns:" + decl.getName();
        }

        @Override
        public String complexType(XSComplexType type) {
            return "~" + this.name(type);
        }

        @Override
        public String simpleType(XSSimpleType simpleType2) {
            return "~" + this.name(simpleType2);
        }

        @Override
        public String elementDecl(XSElementDecl decl) {
            return this.name(decl);
        }

        @Override
        public String annotation(XSAnnotation ann) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attGroupDecl(XSAttGroupDecl decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attributeDecl(XSAttributeDecl decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attributeUse(XSAttributeUse use) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String schema(XSSchema schema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String facet(XSFacet facet2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String notation(XSNotation notation2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String identityConstraint(XSIdentityConstraint decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String xpath(XSXPath xpath2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String particle(XSParticle particle2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String empty(XSContentType empty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String wildcard(XSWildcard wc) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelGroupDecl(XSModelGroupDecl decl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelGroup(XSModelGroup group2) {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    public String getOptionName() {
        return "episode";
    }

    @Override
    public String getUsage() {
        return "  -episode <FILE>    :  generate the episode file for separate compilation";
    }

    @Override
    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if (args[i].equals("-episode")) {
            this.episodeFile = new File(opt.requireArgument("-episode", args, ++i));
            return 2;
        }
        return 0;
    }

    @Override
    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) throws SAXException {
        try {
            OutlineAdaptor adaptor;
            String packageName;
            String fullName;
            XSComponent sc;
            LinkedHashMap<XSSchema, PerSchemaOutlineAdaptors> perSchema = new LinkedHashMap<XSSchema, PerSchemaOutlineAdaptors>();
            boolean hasComponentInNoNamespace = false;
            ArrayList<OutlineAdaptor> outlines = new ArrayList<OutlineAdaptor>();
            for (ClassOutline classOutline : model.getClasses()) {
                sc = classOutline.target.getSchemaComponent();
                fullName = classOutline.implClass.fullName();
                packageName = classOutline.implClass.getPackage().name();
                adaptor = new OutlineAdaptor(sc, OutlineAdaptor.OutlineType.CLASS, fullName, packageName);
                outlines.add(adaptor);
            }
            for (EnumOutline enumOutline : model.getEnums()) {
                sc = enumOutline.target.getSchemaComponent();
                fullName = enumOutline.clazz.fullName();
                packageName = enumOutline.clazz.getPackage().name();
                adaptor = new OutlineAdaptor(sc, OutlineAdaptor.OutlineType.ENUM, fullName, packageName);
                outlines.add(adaptor);
            }
            for (OutlineAdaptor outlineAdaptor : outlines) {
                XSDeclaration decl;
                sc = outlineAdaptor.schemaComponent;
                if (sc == null || !(sc instanceof XSDeclaration) || (decl = (XSDeclaration)sc).isLocal()) continue;
                PerSchemaOutlineAdaptors list = (PerSchemaOutlineAdaptors)perSchema.get(decl.getOwnerSchema());
                if (list == null) {
                    list = new PerSchemaOutlineAdaptors();
                    perSchema.put(decl.getOwnerSchema(), list);
                }
                list.add(outlineAdaptor);
                if (!decl.getTargetNamespace().equals("")) continue;
                hasComponentInNoNamespace = true;
            }
            FileOutputStream os = new FileOutputStream(this.episodeFile);
            Bindings bindings2 = TXW.create(Bindings.class, new StreamSerializer(os, "UTF-8"));
            if (hasComponentInNoNamespace) {
                bindings2._namespace("http://java.sun.com/xml/ns/jaxb", "jaxb");
            } else {
                bindings2._namespace("http://java.sun.com/xml/ns/jaxb", "");
            }
            bindings2.version("2.1");
            bindings2._comment("\n\n" + opt.getPrologComment() + "\n  ");
            for (Map.Entry e2 : perSchema.entrySet()) {
                String packageName2;
                PerSchemaOutlineAdaptors ps = (PerSchemaOutlineAdaptors)e2.getValue();
                Bindings group2 = bindings2.bindings();
                String tns = ((XSSchema)e2.getKey()).getTargetNamespace();
                if (!tns.equals("")) {
                    group2._namespace(tns, "tns");
                }
                group2.scd("x-schema::" + (tns.equals("") ? "" : "tns"));
                SchemaBindings schemaBindings = group2.schemaBindings();
                schemaBindings.map(false);
                if (ps.packageNames.size() == 1 && (packageName2 = (String)ps.packageNames.iterator().next()) != null && packageName2.length() > 0) {
                    schemaBindings._package().name(packageName2);
                }
                for (OutlineAdaptor oa : ps.outlineAdaptors) {
                    Bindings child = group2.bindings();
                    oa.buildBindings(child);
                }
                group2.commit(true);
            }
            bindings2.commit();
            return true;
        }
        catch (IOException e3) {
            errorHandler.error(new SAXParseException("Failed to write to " + this.episodeFile, null, e3));
            return false;
        }
    }

    private static final class PerSchemaOutlineAdaptors {
        private final List<OutlineAdaptor> outlineAdaptors = new ArrayList<OutlineAdaptor>();
        private final Set<String> packageNames = new HashSet<String>();

        private PerSchemaOutlineAdaptors() {
        }

        private void add(OutlineAdaptor outlineAdaptor) {
            this.outlineAdaptors.add(outlineAdaptor);
            this.packageNames.add(outlineAdaptor.packageName);
        }
    }

    private static final class OutlineAdaptor {
        private final XSComponent schemaComponent;
        private final OutlineType outlineType;
        private final String implName;
        private final String packageName;

        public OutlineAdaptor(XSComponent schemaComponent, OutlineType outlineType, String implName, String packageName) {
            this.schemaComponent = schemaComponent;
            this.outlineType = outlineType;
            this.implName = implName;
            this.packageName = packageName;
        }

        private void buildBindings(Bindings bindings2) {
            bindings2.scd((String)this.schemaComponent.apply(SCD));
            this.outlineType.bindingsBuilder.build(this, bindings2);
        }

        private static enum OutlineType {
            CLASS(new BindingsBuilder(){

                @Override
                public void build(OutlineAdaptor adaptor, Bindings bindings2) {
                    bindings2.klass().ref(adaptor.implName);
                }
            }),
            ENUM(new BindingsBuilder(){

                @Override
                public void build(OutlineAdaptor adaptor, Bindings bindings2) {
                    bindings2.typesafeEnumClass().ref(adaptor.implName);
                }
            });

            private final BindingsBuilder bindingsBuilder;

            private OutlineType(BindingsBuilder bindingsBuilder) {
                this.bindingsBuilder = bindingsBuilder;
            }

            private static interface BindingsBuilder {
                public void build(OutlineAdaptor var1, Bindings var2);
            }
        }
    }
}

