/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.rngom.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private final Class cls;
    private ResourceBundle bundle;
    private final Localizer parent;

    public Localizer(Class cls) {
        this(null, cls);
    }

    public Localizer(Localizer parent, Class cls) {
        this.parent = parent;
        this.cls = cls;
    }

    private String getString(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e2) {
            if (this.parent != null) {
                return this.parent.getString(key);
            }
            throw e2;
        }
    }

    public String message(String key) {
        return MessageFormat.format(this.getString(key), new Object[0]);
    }

    public String message(String key, Object arg) {
        return MessageFormat.format(this.getString(key), arg);
    }

    public String message(String key, Object arg1, Object arg2) {
        return MessageFormat.format(this.getString(key), arg1, arg2);
    }

    public String message(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            String s = this.cls.getName();
            int i = s.lastIndexOf(46);
            s = i > 0 ? s.substring(0, i + 1) : "";
            this.bundle = ResourceBundle.getBundle(s + "Messages");
        }
        return this.bundle;
    }
}

