/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc.api.impl.j2s;

import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.J2SJAXBModel;
import com.sun.tools.xjc.api.Reference;
import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.bind.v2.model.core.ArrayInfo;
import com.sun.xml.bind.v2.model.core.ClassInfo;
import com.sun.xml.bind.v2.model.core.Element;
import com.sun.xml.bind.v2.model.core.ElementInfo;
import com.sun.xml.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.bind.v2.model.core.NonElement;
import com.sun.xml.bind.v2.model.core.Ref;
import com.sun.xml.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.schemagen.XmlSchemaGenerator;
import com.sun.xml.txw2.output.ResultFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;

final class JAXBModelImpl
implements J2SJAXBModel {
    private final Map<QName, Reference> additionalElementDecls;
    private final List<String> classList = new ArrayList<String>();
    private final TypeInfoSet<TypeMirror, TypeElement, VariableElement, ExecutableElement> types;
    private final AnnotationReader<TypeMirror, TypeElement, VariableElement, ExecutableElement> reader;
    private XmlSchemaGenerator<TypeMirror, TypeElement, VariableElement, ExecutableElement> xsdgen;
    private final Map<Reference, NonElement<TypeMirror, TypeElement>> refMap = new HashMap<Reference, NonElement<TypeMirror, TypeElement>>();

    public JAXBModelImpl(TypeInfoSet<TypeMirror, TypeElement, VariableElement, ExecutableElement> types, AnnotationReader<TypeMirror, TypeElement, VariableElement, ExecutableElement> reader, Collection<Reference> rootClasses, Map<QName, Reference> additionalElementDecls) {
        this.types = types;
        this.reader = reader;
        this.additionalElementDecls = additionalElementDecls;
        Navigator<TypeMirror, TypeElement, VariableElement, ExecutableElement> navigator = types.getNavigator();
        for (ClassInfo<TypeMirror, TypeElement> classInfo : types.beans().values()) {
            this.classList.add(classInfo.getName());
        }
        for (ArrayInfo arrayInfo : types.arrays().values()) {
            String javaName = navigator.getTypeName((TypeMirror)arrayInfo.getType());
            this.classList.add(javaName);
        }
        for (EnumLeafInfo enumLeafInfo : types.enums().values()) {
            QName tn = enumLeafInfo.getTypeName();
            if (tn == null) continue;
            String javaName = navigator.getTypeName((TypeMirror)enumLeafInfo.getType());
            this.classList.add(javaName);
        }
        for (Reference reference : rootClasses) {
            this.refMap.put(reference, this.getXmlType(reference));
        }
        Iterator<Map.Entry<QName, Reference>> itr = additionalElementDecls.entrySet().iterator();
        while (itr.hasNext()) {
            ClassInfo xct;
            Element elem;
            Map.Entry<QName, Reference> entry = itr.next();
            if (entry.getValue() == null) continue;
            NonElement<TypeMirror, TypeElement> xt = this.getXmlType(entry.getValue());
            assert (xt != null);
            this.refMap.put(entry.getValue(), xt);
            if (xt instanceof ClassInfo && (elem = (xct = (ClassInfo)xt).asElement()) != null && elem.getElementName().equals(entry.getKey())) {
                itr.remove();
                continue;
            }
            ElementInfo<TypeMirror, Object> ei = types.getElementInfo(null, entry.getKey());
            if (ei == null || ei.getContentType() != xt) continue;
            itr.remove();
        }
    }

    @Override
    public List<String> getClassList() {
        return this.classList;
    }

    @Override
    public QName getXmlTypeName(Reference javaType) {
        NonElement<TypeMirror, TypeElement> ti = this.refMap.get(javaType);
        if (ti != null) {
            return ti.getTypeName();
        }
        return null;
    }

    private NonElement<TypeMirror, TypeElement> getXmlType(Reference r) {
        if (r == null) {
            throw new IllegalArgumentException();
        }
        XmlJavaTypeAdapter xjta = r.annotations.getAnnotation(XmlJavaTypeAdapter.class);
        XmlList xl = r.annotations.getAnnotation(XmlList.class);
        Ref<TypeMirror, TypeElement> ref = new Ref<TypeMirror, TypeElement>(this.reader, this.types.getNavigator(), r.type, xjta, xl);
        return this.types.getTypeInfo(ref);
    }

    @Override
    public void generateSchema(SchemaOutputResolver outputResolver, ErrorListener errorListener) throws IOException {
        this.getSchemaGenerator().write(outputResolver, errorListener);
    }

    @Override
    public void generateEpisodeFile(Result output) {
        this.getSchemaGenerator().writeEpisodeFile(ResultFactory.createSerializer(output));
    }

    private synchronized XmlSchemaGenerator<TypeMirror, TypeElement, VariableElement, ExecutableElement> getSchemaGenerator() {
        if (this.xsdgen == null) {
            this.xsdgen = new XmlSchemaGenerator<TypeMirror, TypeElement, VariableElement, ExecutableElement>(this.types.getNavigator(), this.types);
            for (Map.Entry<QName, Reference> e2 : this.additionalElementDecls.entrySet()) {
                Reference value = e2.getValue();
                if (value != null) {
                    TypeMirror type;
                    NonElement<TypeMirror, TypeElement> typeInfo = this.refMap.get(value);
                    if (typeInfo == null) {
                        throw new IllegalArgumentException(e2.getValue() + " was not specified to JavaCompiler.bind");
                    }
                    this.xsdgen.add(e2.getKey(), (type = value.type) == null || !type.getKind().isPrimitive(), typeInfo);
                    continue;
                }
                this.xsdgen.add(e2.getKey(), false, null);
            }
        }
        return this.xsdgen;
    }
}

