/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import com.sun.istack.tools.SecureLoader;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Task;

public abstract class ProtectedTask
extends Task
implements DynamicConfigurator {
    private final AntElement root = new AntElement("root");

    public void setDynamicAttribute(String name, String value) throws BuildException {
        this.root.setDynamicAttribute(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        return this.root.createDynamicElement(name);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        ClassLoader cl;
        ClassLoader ccl = SecureLoader.getContextClassLoader();
        try {
            cl = this.createClassLoader();
            Class<?> driver = cl.loadClass(this.getCoreClassName());
            Task t = (Task)driver.newInstance();
            t.setProject(this.getProject());
            t.setTaskName(this.getTaskName());
            this.root.configure(t);
            SecureLoader.setContextClassLoader(cl);
            t.execute();
            driver = null;
            t.setTaskName(null);
            t.setProject(null);
            t = null;
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (UnsupportedClassVersionError e2) {
            try {
                throw new BuildException("Requires JDK 5.0 or later. Please download it from http://java.sun.com/j2se/1.5/");
                catch (ClassNotFoundException e3) {
                    throw new BuildException((Throwable)e3);
                }
                catch (InstantiationException e4) {
                    throw new BuildException((Throwable)e4);
                }
                catch (IllegalAccessException e5) {
                    throw new BuildException((Throwable)e5);
                }
                catch (IOException e6) {
                    throw new BuildException((Throwable)e6);
                }
            }
            catch (Throwable throwable) {
                ClassLoader cl2 = Thread.currentThread().getContextClassLoader();
                SecureLoader.setContextClassLoader(ccl);
                while (cl2 != null && !ccl.equals(cl2)) {
                    if (cl2 instanceof Closeable) {
                        try {
                            ((Closeable)((Object)cl2)).close();
                        }
                        catch (IOException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                    }
                    if (cl2 instanceof URLClassLoader) {
                        try {
                            Class<?> clUtil = ccl.loadClass("sun.misc.ClassLoaderUtil");
                            Method release = clUtil.getDeclaredMethod("releaseLoader", URLClassLoader.class);
                            release.invoke(null, cl2);
                        }
                        catch (ClassNotFoundException clUtil) {
                        }
                        catch (IllegalAccessException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                        catch (InvocationTargetException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                        catch (NoSuchMethodException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                        catch (SecurityException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                    }
                    cl2 = this.getParentClassLoader(cl2);
                }
                cl2 = null;
                throw throwable;
            }
        }
        SecureLoader.setContextClassLoader(ccl);
        while (cl != null) {
            if (ccl.equals(cl)) return;
            if (cl instanceof Closeable) {
                try {
                    ((Closeable)((Object)cl)).close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            if (cl instanceof URLClassLoader) {
                try {
                    Class<?> clUtil = ccl.loadClass("sun.misc.ClassLoaderUtil");
                    Method release = clUtil.getDeclaredMethod("releaseLoader", URLClassLoader.class);
                    release.invoke(null, cl);
                }
                catch (ClassNotFoundException clUtil) {
                }
                catch (IllegalAccessException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (SecurityException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            cl = this.getParentClassLoader(cl);
        }
    }

    protected abstract String getCoreClassName();

    protected abstract ClassLoader createClassLoader() throws ClassNotFoundException, IOException;

    private ClassLoader getParentClassLoader(final ClassLoader cl) {
        if (cl instanceof AntClassLoader) {
            if (System.getSecurityManager() == null) {
                return this.getPCL(cl);
            }
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ProtectedTask.this.getPCL(cl);
                }
            });
        }
        return SecureLoader.getParentClassLoader(cl);
    }

    private ClassLoader getPCL(ClassLoader cl) {
        try {
            Method parentM = AntClassLoader.class.getDeclaredMethod("getConfiguredParent", new Class[0]);
            return (ClassLoader)parentM.invoke((Object)cl, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Field parentF = null;
            try {
                parentF = AntClassLoader.class.getDeclaredField("parent");
                parentF.setAccessible(true);
                ClassLoader classLoader = (ClassLoader)parentF.get(cl);
                return classLoader;
            }
            catch (IllegalAccessException ex1) {
                throw new BuildException((Throwable)ex1);
            }
            catch (IllegalArgumentException ex1) {
                throw new BuildException((Throwable)ex1);
            }
            catch (NoSuchFieldException ex1) {
            }
            catch (SecurityException ex1) {
                throw new BuildException((Throwable)ex1);
            }
            finally {
                if (parentF != null) {
                    parentF.setAccessible(false);
                }
            }
            return null;
        }
    }

    private class AntElement
    implements DynamicConfigurator {
        private final String name;
        private final Map attributes = new HashMap();
        private final List elements = new ArrayList();

        public AntElement(String name) {
            this.name = name;
        }

        public void setDynamicAttribute(String name, String value) throws BuildException {
            this.attributes.put(name, value);
        }

        public Object createDynamicElement(String name) throws BuildException {
            AntElement e2 = new AntElement(name);
            this.elements.add(e2);
            return e2;
        }

        public void configure(Object antObject) {
            IntrospectionHelper ih = IntrospectionHelper.getHelper(antObject.getClass());
            for (Map.Entry att : this.attributes.entrySet()) {
                ih.setAttribute(ProtectedTask.this.getProject(), antObject, (String)att.getKey(), (String)att.getValue());
            }
            for (AntElement e2 : this.elements) {
                Object child = ih.createElement(ProtectedTask.this.getProject(), antObject, e2.name);
                e2.configure(child);
                ih.storeElement(ProtectedTask.this.getProject(), antObject, child, e2.name);
            }
        }
    }
}

